/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.capabilites.entity;

import javax.annotation.Nonnull;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSReqPlayerInfo;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;

@OnlyIn(value=Dist.CLIENT)
public class RemoteClientPlayerData<T extends AbstractClientPlayerEntity>
extends PlayerData<T> {
    protected float prevYaw;
    protected float bodyYaw;
    protected float prevBodyYaw;
    private ItemStack prevHeldItem;
    private ItemStack prevHeldItemOffHand;
    private boolean swingArm;

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.prevHeldItem = ItemStack.field_190927_a;
        this.prevHeldItemOffHand = ItemStack.field_190927_a;
        if (!(this instanceof ClientPlayerData)) {
            ModNetworkManager.sendToServer(new CTSReqPlayerInfo(((AbstractClientPlayerEntity)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    public void updateMotion() {
        AnimatorClient animator = this.getClientAnimator();
        if (((AbstractClientPlayerEntity)this.orgEntity).func_110143_aJ() <= 0.0f) {
            this.currentMotion = LivingMotion.DEATH;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_184613_cA()) {
            this.currentMotion = LivingMotion.FLYING;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_184187_bx() != null) {
            this.currentMotion = LivingMotion.MOUNT;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_213283_Z() == Pose.SWIMMING && !((AbstractClientPlayerEntity)this.orgEntity).func_184587_cr()) {
            this.currentMotion = LivingMotion.SWIMMING;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_70608_bn()) {
            this.currentMotion = LivingMotion.SLEEP;
        } else if (!((AbstractClientPlayerEntity)this.orgEntity).func_233570_aj_() && ((AbstractClientPlayerEntity)this.orgEntity).func_70617_f_()) {
            this.currentMotion = LivingMotion.CLIMB;
            double y = ((AbstractClientPlayerEntity)this.orgEntity).field_71095_bQ - ((AbstractClientPlayerEntity)this.orgEntity).field_71096_bN;
            System.out.println(y);
            animator.baseLayer.pause = Math.abs(y) < 0.04;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).func_204231_K() && ((AbstractClientPlayerEntity)this.orgEntity).field_71095_bQ - ((AbstractClientPlayerEntity)this.orgEntity).field_71096_bN < -0.005) {
            this.currentMotion = LivingMotion.FLOATING;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).field_71095_bQ - ((AbstractClientPlayerEntity)this.orgEntity).field_71096_bN < -0.25) {
            this.currentMotion = LivingMotion.FALL;
        } else if (((AbstractClientPlayerEntity)this.orgEntity).field_70721_aZ > 0.01f) {
            this.currentMotion = ((AbstractClientPlayerEntity)this.orgEntity).func_225608_bj_() ? LivingMotion.SNEAKING : (((AbstractClientPlayerEntity)this.orgEntity).func_70051_ag() ? LivingMotion.RUNNING : LivingMotion.WALKING);
            if (((AbstractClientPlayerEntity)this.orgEntity).field_191988_bg > 0.0f) {
                animator.setReverse(false, this.currentMotion);
            } else if (((AbstractClientPlayerEntity)this.orgEntity).field_191988_bg < 0.0f) {
                animator.setReverse(true, this.currentMotion);
            }
        } else {
            animator.setReverse(false, this.currentMotion);
            this.currentMotion = ((AbstractClientPlayerEntity)this.orgEntity).func_225608_bj_() ? LivingMotion.KNEELING : LivingMotion.IDLE;
        }
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184587_cr() && ((AbstractClientPlayerEntity)this.orgEntity).func_184605_cv() > 0) {
            UseAction useAction = ((AbstractClientPlayerEntity)this.orgEntity).func_184586_b(((AbstractClientPlayerEntity)this.orgEntity).func_184600_cs()).func_77975_n();
            this.currentMixMotion = useAction == UseAction.BLOCK ? LivingMotion.BLOCKING : (useAction == UseAction.BOW ? LivingMotion.AIMING : (useAction == UseAction.CROSSBOW ? LivingMotion.RELOADING : (useAction == UseAction.SPEAR ? LivingMotion.AIMING : LivingMotion.NONE)));
        } else if (CrossbowItem.func_220012_d((ItemStack)((AbstractClientPlayerEntity)this.orgEntity).func_184614_ca())) {
            this.currentMixMotion = LivingMotion.AIMING;
        } else if (this.getClientAnimator().prevAiming()) {
            this.playReboundAnimation();
        } else {
            this.currentMixMotion = LivingMotion.NONE;
        }
    }

    @Override
    protected void updateOnClient() {
        boolean isOffHandChanged;
        this.prevYaw = this.yaw;
        this.prevBodyYaw = this.bodyYaw;
        this.bodyYaw = this.inaction ? ((AbstractClientPlayerEntity)this.orgEntity).field_70177_z : ((AbstractClientPlayerEntity)this.orgEntity).field_70760_ar;
        boolean isMainHandChanged = this.prevHeldItem.func_77973_b() != ((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.func_70448_g().func_77973_b();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand.func_77973_b() != ((ItemStack)((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.field_184439_c.get(0)).func_77973_b();
        if (isMainHandChanged || isOffHandChanged) {
            this.onHeldItemChange(this.getHeldItemCapability(Hand.MAIN_HAND), this.getHeldItemCapability(Hand.OFF_HAND));
            if (isMainHandChanged) {
                this.prevHeldItem = ((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.func_70448_g();
            }
            if (isOffHandChanged) {
                this.prevHeldItemOffHand = (ItemStack)((AbstractClientPlayerEntity)this.orgEntity).field_71071_by.field_184439_c.get(0);
            }
        }
        super.updateOnClient();
        if (((AbstractClientPlayerEntity)this.orgEntity).field_70725_aQ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
        if (this.swingArm != ((AbstractClientPlayerEntity)this.orgEntity).field_82175_bq) {
            if (!this.swingArm && this.currentMotion != LivingMotion.SLEEP) {
                this.getClientAnimator().playMixLayerAnimation(Animations.BIPED_DIG);
            } else {
                this.getClientAnimator().offMixLayer(false);
            }
            this.swingArm = ((AbstractClientPlayerEntity)this.orgEntity).field_82175_bq;
        }
    }

    public void onHeldItemChange(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.getClientAnimator().resetMixMotion();
        this.getClientAnimator().offMixLayer(false);
        this.cancelUsingItem();
    }

    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)(((AbstractClientPlayerEntity)this.orgEntity).func_175154_l().equals("slim") ? modelDB.ENTITY_BIPED_SLIM_ARM : modelDB.ENTITY_BIPED);
    }

    @Override
    public boolean shouldSkipRender() {
        return !this.isBattleMode && EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue() != false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public VisibleMatrix4f getHeadMatrix(float partialTick) {
        AbstractClientPlayerEntity entity = (AbstractClientPlayerEntity)this.getOriginalEntity();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float prvePitch = 0.0f;
        if (this.inaction || entity.func_184187_bx() != null || !((AbstractClientPlayerEntity)this.orgEntity).func_233570_aj_() && entity.func_70617_f_() || entity.func_70608_bn()) {
            yaw = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(this.prevBodyYaw, this.bodyYaw, partialTick);
            float f1 = MathUtils.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTick);
            yaw = f1 - f;
        }
        if (!((AbstractClientPlayerEntity)this.orgEntity).func_184613_cA()) {
            prvePitch = entity.field_70127_C;
            pitch = entity.field_70125_A;
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prvePitch, pitch, yaw, yaw, partialTick, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTick) {
        float rotyaw;
        float prevRotYaw;
        Object entity = this.getOriginalEntity();
        if (((AbstractClientPlayerEntity)this.orgEntity).func_204805_cN()) {
            VisibleMatrix4f mat = MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)entity.func_226277_ct_(), (float)((LivingEntity)entity).field_70137_T, (float)entity.func_226278_cu_(), (float)((LivingEntity)entity).field_70136_U, (float)entity.func_226281_cx_(), 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 1.0f, 1.0f, 1.0f);
            float yawDegree = MathUtils.interpolateRotation(((AbstractClientPlayerEntity)this.orgEntity).field_70126_B, ((AbstractClientPlayerEntity)this.orgEntity).field_70177_z, partialTick);
            float pitchDegree = MathUtils.interpolateRotation(((AbstractClientPlayerEntity)this.orgEntity).field_70127_C, ((AbstractClientPlayerEntity)this.orgEntity).field_70125_A, partialTick) + 90.0f;
            VisibleMatrix4f.rotate((float)(-Math.toRadians(yawDegree)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            VisibleMatrix4f.rotate((float)(-Math.toRadians(pitchDegree)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
            VisibleMatrix4f.rotate((float)Math.toRadians((double)((float)((AbstractClientPlayerEntity)this.orgEntity).field_70173_aa + partialTick) * -55.0), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            return mat;
        }
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184613_cA()) {
            VisibleMatrix4f mat = MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)entity.func_226277_ct_(), (float)((LivingEntity)entity).field_70137_T, (float)entity.func_226278_cu_(), (float)((LivingEntity)entity).field_70136_U, (float)entity.func_226281_cx_(), 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 1.0f, 1.0f, 1.0f);
            VisibleMatrix4f.rotate((float)(-Math.toRadians(((LivingEntity)entity).field_70761_aq)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            float f = (float)((AbstractClientPlayerEntity)this.orgEntity).func_184599_cB() + Minecraft.func_71410_x().func_184121_ak();
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            VisibleMatrix4f.rotate((float)Math.toRadians(f1 * (-90.0f - ((AbstractClientPlayerEntity)this.orgEntity).field_70125_A)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
            Vector3d vec3d = ((AbstractClientPlayerEntity)this.orgEntity).func_70676_i(Minecraft.func_71410_x().func_184121_ak());
            Vector3d vec3d1 = ((AbstractClientPlayerEntity)this.orgEntity).func_213322_ci();
            double d0 = vec3d1.field_72450_a * vec3d1.field_72450_a + vec3d1.field_72449_c * vec3d1.field_72449_c;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.field_72450_a * vec3d.field_72450_a + vec3d1.field_72449_c * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.field_72450_a * vec3d.field_72449_c - vec3d1.field_72449_c * vec3d.field_72450_a;
                VisibleMatrix4f.rotate((float)Math.toRadians((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            }
            return mat;
        }
        if (((AbstractClientPlayerEntity)this.orgEntity).func_70608_bn()) {
            BlockState blockstate = ((AbstractClientPlayerEntity)this.orgEntity).func_213339_cH();
            float yaw = 0.0f;
            if (blockstate.isBed((IBlockReader)((AbstractClientPlayerEntity)this.orgEntity).field_70170_p, ((AbstractClientPlayerEntity)this.orgEntity).func_233580_cy_(), (LivingEntity)this.orgEntity) && blockstate.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                switch ((Direction)blockstate.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
                    case EAST: {
                        yaw = 90.0f;
                        break;
                    }
                    case WEST: {
                        yaw = -90.0f;
                        break;
                    }
                    case SOUTH: {
                        yaw = 180.0f;
                        break;
                    }
                }
            }
            return MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)entity.func_226277_ct_(), (float)((LivingEntity)entity).field_70137_T, (float)entity.func_226278_cu_(), (float)((LivingEntity)entity).field_70136_U, (float)entity.func_226281_cx_(), 0.0f, 0.0f, yaw, yaw, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        Direction direction = this.getLadderDirection(((AbstractClientPlayerEntity)this.orgEntity).func_213339_cH(), ((AbstractClientPlayerEntity)this.orgEntity).field_70170_p, ((AbstractClientPlayerEntity)this.orgEntity).func_233580_cy_(), (LivingEntity)this.orgEntity);
        if (direction != Direction.UP) {
            float yaw = 0.0f;
            switch (direction) {
                case EAST: {
                    yaw = 90.0f;
                    break;
                }
                case WEST: {
                    yaw = -90.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 180.0f;
                    break;
                }
            }
            return MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)entity.func_226277_ct_(), (float)((LivingEntity)entity).field_70137_T, (float)entity.func_226278_cu_(), (float)((LivingEntity)entity).field_70136_U, (float)entity.func_226281_cx_(), 0.0f, 0.0f, yaw, yaw, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        float prevPitch = 0.0f;
        float pitch = 0.0f;
        if (((AbstractClientPlayerEntity)this.orgEntity).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((AbstractClientPlayerEntity)this.orgEntity).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            float yaw = this.inaction ? MathUtils.interpolateRotation(this.prevYaw, this.yaw, partialTick) : 0.0f;
            prevRotYaw = this.prevBodyYaw + yaw;
            rotyaw = this.bodyYaw + yaw;
        }
        if (!this.isInaction() && ((AbstractClientPlayerEntity)this.orgEntity).func_213283_Z() == Pose.SWIMMING) {
            float f4;
            float f = ((AbstractClientPlayerEntity)this.orgEntity).func_205015_b(partialTick);
            float f3 = ((AbstractClientPlayerEntity)this.orgEntity).func_70090_H() ? ((AbstractClientPlayerEntity)this.orgEntity).field_70125_A : 0.0f;
            prevPitch = f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            pitch = f4;
        }
        return MathUtils.getModelMatrixIntegrated((float)((LivingEntity)entity).field_70142_S, (float)entity.func_226277_ct_(), (float)((LivingEntity)entity).field_70137_T, (float)entity.func_226278_cu_(), (float)((LivingEntity)entity).field_70136_U, (float)entity.func_226281_cx_(), prevPitch, pitch, prevRotYaw, rotyaw, partialTick, 1.0f, 1.0f, 1.0f);
    }

    public Direction getLadderDirection(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175149_v();
        if (isSpectator || ((AbstractClientPlayerEntity)this.orgEntity).func_233570_aj_()) {
            return Direction.UP;
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            if (state.isLadder((IWorldReader)world, pos, entity)) {
                if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208149_B) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208149_B)).booleanValue()) {
                    return Direction.UP;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208151_D) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D)).booleanValue()) {
                    return Direction.SOUTH;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208154_G) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G)).booleanValue()) {
                    return Direction.EAST;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208153_F) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F)).booleanValue()) {
                    return Direction.NORTH;
                }
                if (state.func_235901_b_((Property)BlockStateProperties.field_208152_E) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E)).booleanValue()) {
                    return Direction.WEST;
                }
            }
        } else {
            AxisAlignedBB bb = entity.func_174813_aQ();
            int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
            int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
            int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
            int y2 = mY;
            while ((double)y2 < bb.field_72337_e) {
                int x2 = mX;
                while ((double)x2 < bb.field_72336_d) {
                    int z2 = mZ;
                    while ((double)z2 < bb.field_72334_f) {
                        BlockPos tmp = new BlockPos(x2, y2, z2);
                        state = world.func_180495_p(tmp);
                        if (state.isLadder((IWorldReader)world, tmp, entity)) {
                            return Direction.DOWN;
                        }
                        ++z2;
                    }
                    ++x2;
                }
                ++y2;
            }
        }
        return Direction.UP;
    }
}

