/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.events.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.input.ModKeys;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.entity.eventlistener.PlayerBasicAttackEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerMovementInputEvent;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSPlayAnimation;
import maninhouse.epicfight.network.client.CTSToggleMode;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;

@OnlyIn(value=Dist.CLIENT)
public class ControllEngine {
    private Map<KeyBinding, BiConsumer<Integer, Integer>> keyFunctionMap;
    private GLFWCursorPosCallbackI callback = (handle, x, y) -> {
        this.tracingMouseX = x;
        this.tracingMouseY = y;
    };
    private ClientPlayerEntity player;
    private ClientPlayerData playerdata;
    private KeyBindingMap keyHash;
    private double tracingMouseX;
    private double tracingMouseY;
    private int comboHoldCounter;
    private int comboCounter;
    private int mouseLeftPressCounter = 0;
    private int sneakPressCounter = 0;
    private int reservedSkill;
    private int skillReserveCounter;
    private boolean sneakPressToggle = false;
    private boolean mouseLeftPressToggle = false;
    private boolean lightPress;
    public GameSettings gameSettings;

    public ControllEngine() {
        Events.controllEngine = this;
        this.gameSettings = Minecraft.func_71410_x().field_71474_y;
        this.keyFunctionMap = new HashMap<KeyBinding, BiConsumer<Integer, Integer>>();
        this.keyFunctionMap.put(this.gameSettings.field_74312_F, this::attackKeyPressed);
        this.keyFunctionMap.put(this.gameSettings.field_186718_X, this::swapHandKeyPressed);
        this.keyFunctionMap.put(ModKeys.SWITCH_MODE, this::switchModeKeyPressed);
        this.keyFunctionMap.put(ModKeys.DODGE, this::sneakKeyPressed);
        try {
            this.keyHash = (KeyBindingMap)ObfuscationReflectionHelper.findField(KeyBinding.class, (String)"field_74514_b").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setGamePlayer(ClientPlayerData playerdata) {
        this.comboCounter = 0;
        this.mouseLeftPressCounter = 0;
        this.mouseLeftPressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.lightPress = false;
        this.player = (ClientPlayerEntity)playerdata.getOriginalEntity();
        this.playerdata = playerdata;
    }

    public boolean canPlayerMove(EntityState playerState) {
        return !playerState.isMovementLocked() || this.player.func_110317_t();
    }

    public boolean canPlayerRotate(EntityState playerState) {
        return !playerState.isCameraRotationLocked() || this.player.func_110317_t();
    }

    public boolean canPlayerBasicAttack(EntityState playerState) {
        return !this.isAirborne() && !playerState.isMovementLocked();
    }

    public boolean canPlayerDodge(EntityState playerState) {
        return !this.isAirborne() && playerState.canAct();
    }

    public boolean canPlayerExecuteSkill(EntityState playerState) {
        return !this.isAirborne() && playerState.canAct();
    }

    private boolean isAirborne() {
        return this.player.func_175149_v() || this.player.func_184613_cA() || this.playerdata.currentMotion == LivingMotion.FALL;
    }

    private void attackKeyPressed(int key, int action) {
        if (action == 1 && ClientEngine.INSTANCE.isBattleMode()) {
            this.setKeyBind(this.gameSettings.field_74312_F, false);
            while (this.gameSettings.field_74312_F.func_151468_f()) {
            }
            if (this.player.func_184605_cv() == 0 && !this.mouseLeftPressToggle) {
                this.mouseLeftPressToggle = true;
            }
        }
        if (this.player.func_184825_o(0.0f) < 0.9f) {
            while (this.gameSettings.field_74312_F.func_151468_f()) {
            }
        }
    }

    private void sneakKeyPressed(int key, int action) {
        if (action == 1) {
            if (key == this.gameSettings.field_228046_af_.getKey().func_197937_c()) {
                if (this.player.func_184187_bx() == null && ClientEngine.INSTANCE.isBattleMode() && !this.sneakPressToggle) {
                    this.sneakPressToggle = true;
                }
            } else {
                SkillContainer skill = this.playerdata.getSkill(SkillSlot.DODGE);
                if (skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.sendExecuteRequest(this.playerdata);
                }
            }
        }
    }

    private void swapHandKeyPressed(int key, int action) {
        CapabilityItem cap = this.playerdata.getHeldItemCapability(Hand.MAIN_HAND);
        if (this.playerdata.isInaction() || cap != null && !cap.canUsedInOffhand()) {
            while (this.gameSettings.field_186718_X.func_151468_f()) {
            }
            this.setKeyBind(this.gameSettings.field_186718_X, false);
        }
    }

    private void switchModeKeyPressed(int key, int action) {
        if (action == 1) {
            ClientEngine.INSTANCE.toggleActingMode();
            ModNetworkManager.sendToServer(new CTSToggleMode(ClientEngine.INSTANCE.isBattleMode()));
        }
    }

    public void tick() {
        SkillContainer skill;
        if (this.playerdata == null) {
            return;
        }
        EntityState playerState = this.playerdata.getEntityState();
        if (this.mouseLeftPressToggle) {
            if (!this.isKeyDown(this.gameSettings.field_74312_F)) {
                this.lightPress = true;
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
            } else if (this.mouseLeftPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                if (this.canPlayerExecuteSkill(playerState)) {
                    CapabilityItem itemCap = this.playerdata.getHeldItemCapability(Hand.MAIN_HAND);
                    if (itemCap != null) {
                        this.playerdata.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).sendExecuteRequest(this.playerdata);
                    }
                } else if (!this.player.func_175149_v()) {
                    this.reserveSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
                }
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
                this.resetAttackCounter();
            } else {
                this.setKeyBind(this.gameSettings.field_74312_F, false);
                ++this.mouseLeftPressCounter;
            }
        }
        if (this.lightPress) {
            if (this.canPlayerBasicAttack(playerState)) {
                this.playAttackMotion(this.player.func_184614_ca(), this.player.func_70051_ag());
                this.player.func_184821_cY();
                this.lightPress = false;
            } else if (this.player.func_175149_v() || playerState.getLevel() < 3) {
                this.lightPress = false;
            }
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!this.isKeyDown(this.gameSettings.field_228046_af_)) {
                skill = this.playerdata.getSkill(SkillSlot.DODGE);
                if (skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.sendExecuteRequest(this.playerdata);
                } else {
                    this.reserveSkill(SkillSlot.DODGE);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > (Integer)EpicFightMod.CLIENT_INGAME_CONFIG.longPressCount.getValue()) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.reservedSkill >= 0) {
            if (this.skillReserveCounter > 0) {
                skill = this.playerdata.getSkill(this.reservedSkill);
                --this.skillReserveCounter;
                if (skill.getContaining() != null && skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.sendExecuteRequest(this.playerdata);
                    this.reservedSkill = -1;
                    this.skillReserveCounter = -1;
                }
            } else {
                this.reservedSkill = -1;
                this.skillReserveCounter = -1;
            }
        }
        if (this.comboHoldCounter > 0) {
            float f = this.player.func_184825_o(0.0f);
            if (!playerState.isMovementLocked() && !playerState.isCameraRotationLocked() && f >= 1.0f) {
                --this.comboHoldCounter;
                if (this.comboHoldCounter == 0) {
                    this.resetAttackCounter();
                }
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.isKeyDown(this.gameSettings.field_151456_ac[i]) || !this.playerdata.isInaction()) continue;
            this.gameSettings.field_151456_ac[i].func_151468_f();
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            Minecraft.func_71410_x().field_71417_B.func_198029_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i());
        }
    }

    private void playAttackMotion(ItemStack holdItem, boolean dashAttack) {
        if (this.playerdata.getEventListener().activateEvents(EntityEventListener.EventType.BASIC_ATTACK_EVENT, new PlayerBasicAttackEvent(this.playerdata))) {
            return;
        }
        CapabilityItem cap = (CapabilityItem)holdItem.getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
        StaticAnimation attackMotion = null;
        if (this.player.func_184187_bx() != null) {
            if (this.player.func_110317_t() && cap != null && cap.canUseOnMount()) {
                attackMotion = cap.getMountAttackMotion().get(this.comboCounter);
                ++this.comboCounter;
                this.comboCounter %= cap.getMountAttackMotion().size();
            }
        } else {
            List<StaticAnimation> combo = cap != null ? cap.getAutoAttckMotion(this.playerdata) : CapabilityItem.getBasicAutoAttackMotion();
            int comboSize = combo.size();
            this.comboCounter = dashAttack ? comboSize - 1 : (this.comboCounter %= comboSize - 1);
            attackMotion = combo.get(this.comboCounter);
            this.comboCounter = dashAttack ? 0 : this.comboCounter + 1;
        }
        this.comboHoldCounter = 10;
        if (attackMotion != null) {
            ((Animator)this.playerdata.getAnimator()).playAnimation(attackMotion, 0.0f);
            ModNetworkManager.sendToServer(new CTSPlayAnimation(attackMotion, 0.0f, false, false));
        }
    }

    private void reserveSkill(SkillSlot slot) {
        this.reservedSkill = slot.getIndex();
        this.skillReserveCounter = 8;
    }

    public boolean isKeyDown(KeyBinding key) {
        if (key.getKey().func_197938_b() == InputMappings.Type.KEYSYM) {
            return GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key.getKey().func_197937_c()) > 0;
        }
        if (key.getKey().func_197938_b() == InputMappings.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key.getKey().func_197937_c()) > 0;
        }
        return false;
    }

    public void setKeyBind(KeyBinding key, boolean setter) {
        KeyBinding.func_197980_a((InputMappings.Input)key.getKey(), (boolean)setter);
    }

    public void resetAttackCounter() {
        this.comboCounter = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseEvent(InputEvent.MouseInputEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(event.getButton());
                for (KeyBinding keybinding : controllEngine.keyHash.lookupAll(input)) {
                    if (!controllEngine.keyFunctionMap.containsKey(keybinding)) continue;
                    ((BiConsumer)controllEngine.keyFunctionMap.get(keybinding)).accept(event.getButton(), event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void mouseScrollEvent(InputEvent.MouseScrollEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && controllEngine.playerdata != null && controllEngine.playerdata.isInaction() && Minecraft.func_71410_x().field_71462_r == null) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void keyboardEvent(InputEvent.KeyInputEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                InputMappings.Input input = InputMappings.Type.KEYSYM.func_197944_a(event.getKey());
                for (KeyBinding keybinding : controllEngine.keyHash.lookupAll(input)) {
                    if (!controllEngine.keyFunctionMap.containsKey(keybinding)) continue;
                    ((BiConsumer)controllEngine.keyFunctionMap.get(keybinding)).accept(event.getKey(), event.getAction());
                }
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(InputUpdateEvent event) {
            if (controllEngine.playerdata == null) {
                return;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityState playerState = controllEngine.playerdata.getEntityState();
            if (!controllEngine.canPlayerRotate(playerState) && controllEngine.player.func_70089_S()) {
                GLFW.glfwSetCursorPosCallback((long)minecraft.func_228018_at_().func_198092_i(), (GLFWCursorPosCallbackI)controllEngine.callback);
                minecraft.field_71417_B.field_198040_e = controllEngine.tracingMouseX;
                minecraft.field_71417_B.field_198041_f = controllEngine.tracingMouseY;
            } else {
                controllEngine.tracingMouseX = minecraft.field_71417_B.func_198024_e();
                controllEngine.tracingMouseY = minecraft.field_71417_B.func_198026_f();
                minecraft.field_71417_B.func_198029_a(Minecraft.func_71410_x().func_228018_at_().func_198092_i());
            }
            if (!controllEngine.canPlayerMove(playerState)) {
                event.getMovementInput().field_192832_b = 0.0f;
                event.getMovementInput().field_78902_a = 0.0f;
                event.getMovementInput().field_187255_c = false;
                event.getMovementInput().field_187256_d = false;
                event.getMovementInput().field_187257_e = false;
                event.getMovementInput().field_187258_f = false;
                event.getMovementInput().field_78901_c = false;
                event.getMovementInput().field_228350_h_ = false;
                ClientPlayerEntity clientPlayer = (ClientPlayerEntity)event.getPlayer();
                clientPlayer.func_70031_b(false);
                clientPlayer.field_71156_d = -1;
                controllEngine.setKeyBind(Events.controllEngine.gameSettings.field_151444_V, false);
            }
            controllEngine.playerdata.getEventListener().activateEvents(EntityEventListener.EventType.MOVEMENT_INPUT_EVENT, new PlayerMovementInputEvent(controllEngine.playerdata, event.getMovementInput()));
        }

        @SubscribeEvent
        public static void preProcessKeyBindings(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
                controllEngine.tick();
            }
        }
    }
}

