/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.events.engine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.gui.BattleModeGui;
import maninhouse.epicfight.client.gui.EntityIndicator;
import maninhouse.epicfight.client.input.ModKeys;
import maninhouse.epicfight.client.renderer.AimHelperRenderer;
import maninhouse.epicfight.client.renderer.FirstPersonRenderer;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.client.renderer.entity.ArmatureRenderer;
import maninhouse.epicfight.client.renderer.entity.CaveSpiderRenderer;
import maninhouse.epicfight.client.renderer.entity.ClientPlayerRenderer;
import maninhouse.epicfight.client.renderer.entity.CreeperRenderer;
import maninhouse.epicfight.client.renderer.entity.DrownedRenderer;
import maninhouse.epicfight.client.renderer.entity.EndermanRenderer;
import maninhouse.epicfight.client.renderer.entity.HoglinRenderer;
import maninhouse.epicfight.client.renderer.entity.IronGolemRenderer;
import maninhouse.epicfight.client.renderer.entity.RavagerRenderer;
import maninhouse.epicfight.client.renderer.entity.SimpleTextureBipedRenderer;
import maninhouse.epicfight.client.renderer.entity.SpiderRenderer;
import maninhouse.epicfight.client.renderer.entity.VexRenderer;
import maninhouse.epicfight.client.renderer.entity.ZombieVillagerRenderer;
import maninhouse.epicfight.client.renderer.item.RenderBow;
import maninhouse.epicfight.client.renderer.item.RenderCrossbow;
import maninhouse.epicfight.client.renderer.item.RenderElytra;
import maninhouse.epicfight.client.renderer.item.RenderHat;
import maninhouse.epicfight.client.renderer.item.RenderItemBase;
import maninhouse.epicfight.client.renderer.item.RenderKatana;
import maninhouse.epicfight.client.renderer.item.RenderShield;
import maninhouse.epicfight.client.renderer.item.RenderTrident;
import maninhouse.epicfight.item.ModItems;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.utils.math.Formulars;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.TridentItem;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderEngine {
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    public static final ResourceLocation NULL_TEXTURE = new ResourceLocation("epicfight", "textures/gui/null.png");
    public AimHelperRenderer aimHelper;
    public BattleModeGui guiSkillBar = new BattleModeGui();
    private Minecraft minecraft;
    private EntityRendererManager entityRendererManager;
    private VisibleMatrix4f projectionMatrix;
    private Map<EntityType<?>, ArmatureRenderer> entityRendererMap;
    private Map<Item, RenderItemBase> itemRendererMapByInstance;
    private Map<Class<? extends Item>, RenderItemBase> itemRendererMapByClass;
    private FirstPersonRenderer firstPersonRenderer;
    private boolean aiming;
    private int zoomOutTimer = 0;
    private int zoomCount;
    private int zoomMaxCount = 20;

    public RenderEngine() {
        Events.renderEngine = this;
        RenderItemBase.renderEngine = this;
        EntityIndicator.init();
        this.minecraft = Minecraft.func_71410_x();
        this.entityRendererManager = this.minecraft.func_175598_ae();
        this.entityRendererMap = new HashMap();
        this.itemRendererMapByInstance = new HashMap<Item, RenderItemBase>();
        this.itemRendererMapByClass = new HashMap<Class<? extends Item>, RenderItemBase>();
        this.projectionMatrix = new VisibleMatrix4f();
        this.firstPersonRenderer = new FirstPersonRenderer();
        this.minecraft.func_228019_au_().field_228480_b_.put(ModRenderTypes.getEnchantedArmor(), new BufferBuilder(ModRenderTypes.getEnchantedArmor().func_228662_o_()));
    }

    public void buildRenderer() {
        this.entityRendererMap.put(EntityType.field_200797_k, new CreeperRenderer());
        this.entityRendererMap.put(EntityType.field_200803_q, new EndermanRenderer());
        this.entityRendererMap.put(EntityType.field_200725_aD, new SimpleTextureBipedRenderer("textures/entity/zombie/zombie.png"));
        this.entityRendererMap.put(EntityType.field_200727_aF, new ZombieVillagerRenderer());
        this.entityRendererMap.put(EntityType.field_233592_ba_, new SimpleTextureBipedRenderer("epicfight:textures/entity/zombified_piglin.png"));
        this.entityRendererMap.put(EntityType.field_200763_C, new SimpleTextureBipedRenderer("textures/entity/zombie/husk.png"));
        this.entityRendererMap.put(EntityType.field_200741_ag, new SimpleTextureBipedRenderer("textures/entity/skeleton/skeleton.png"));
        this.entityRendererMap.put(EntityType.field_200722_aA, new SimpleTextureBipedRenderer("textures/entity/skeleton/wither_skeleton.png"));
        this.entityRendererMap.put(EntityType.field_200750_ap, new SimpleTextureBipedRenderer("textures/entity/skeleton/stray.png"));
        this.entityRendererMap.put(EntityType.field_200729_aH, new ClientPlayerRenderer());
        this.entityRendererMap.put(EntityType.field_200748_an, new SpiderRenderer());
        this.entityRendererMap.put(EntityType.field_200794_h, new CaveSpiderRenderer());
        this.entityRendererMap.put(EntityType.field_200757_aw, new IronGolemRenderer());
        this.entityRendererMap.put(EntityType.field_200758_ax, new SimpleTextureBipedRenderer("textures/entity/illager/vindicator.png"));
        this.entityRendererMap.put(EntityType.field_200806_t, new SimpleTextureBipedRenderer("textures/entity/illager/evoker.png"));
        this.entityRendererMap.put(EntityType.field_200759_ay, new SimpleTextureBipedRenderer("epicfight:textures/entity/witch.png"));
        this.entityRendererMap.put(EntityType.field_204724_o, new DrownedRenderer());
        this.entityRendererMap.put(EntityType.field_220350_aJ, new SimpleTextureBipedRenderer("textures/entity/illager/pillager.png"));
        this.entityRendererMap.put(EntityType.field_220352_aU, new RavagerRenderer());
        this.entityRendererMap.put(EntityType.field_200755_au, new VexRenderer());
        this.entityRendererMap.put(EntityType.field_233591_ai_, new SimpleTextureBipedRenderer("textures/entity/piglin/piglin.png"));
        this.entityRendererMap.put(EntityType.field_242287_aj, new SimpleTextureBipedRenderer("epicfight:textures/entity/piglin_brute.png"));
        this.entityRendererMap.put(EntityType.field_233588_G_, new HoglinRenderer("textures/entity/hoglin/hoglin.png"));
        this.entityRendererMap.put(EntityType.field_233590_aW_, new HoglinRenderer("textures/entity/hoglin/zoglin.png"));
        RenderBow bowRenderer = new RenderBow();
        RenderCrossbow crossbowRenderer = new RenderCrossbow();
        RenderElytra elytraRenderer = new RenderElytra();
        RenderHat hatRenderer = new RenderHat();
        RenderKatana katanaRenderer = new RenderKatana();
        RenderShield shieldRenderer = new RenderShield();
        RenderTrident tridentRenderer = new RenderTrident();
        this.itemRendererMapByInstance.put(Items.field_190931_a, new RenderItemBase());
        this.itemRendererMapByInstance.put(Items.field_151031_f, bowRenderer);
        this.itemRendererMapByInstance.put(Items.field_185159_cQ, shieldRenderer);
        this.itemRendererMapByInstance.put(Items.field_185160_cR, elytraRenderer);
        this.itemRendererMapByInstance.put(Items.field_196185_dy, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196151_dA, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196184_dx, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196186_dz, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196182_dv, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_196183_dw, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_221689_cG, hatRenderer);
        this.itemRendererMapByInstance.put(Items.field_222114_py, crossbowRenderer);
        this.itemRendererMapByInstance.put(Items.field_203184_eO, tridentRenderer);
        this.itemRendererMapByInstance.put((Item)ModItems.KATANA.get(), katanaRenderer);
        this.itemRendererMapByClass.put(BlockItem.class, hatRenderer);
        this.itemRendererMapByClass.put(BowItem.class, bowRenderer);
        this.itemRendererMapByClass.put(CrossbowItem.class, crossbowRenderer);
        this.itemRendererMapByClass.put(ElytraItem.class, elytraRenderer);
        this.itemRendererMapByClass.put(ShieldItem.class, shieldRenderer);
        this.itemRendererMapByClass.put(TridentItem.class, tridentRenderer);
        this.aimHelper = new AimHelperRenderer();
    }

    public RenderItemBase getItemRenderer(Item item) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(item);
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(item.getClass());
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.field_190931_a);
            }
            this.itemRendererMapByInstance.put(item, renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.getOrDefault(clazz, null);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(LivingEntity livingEntity, LivingData<?> entitydata, EntityRenderer<? extends Entity> renderer, IRenderTypeBuffer buffer, MatrixStack matStack, int packedLightIn, float partialTicks) {
        this.entityRendererMap.get(livingEntity.func_200600_R()).render(livingEntity, entitydata, renderer, buffer, matStack, packedLightIn, partialTicks);
    }

    public boolean isEntityContained(Entity entity) {
        return this.entityRendererMap.containsKey(entity.func_200600_R());
    }

    public void zoomIn() {
        this.aiming = true;
        this.zoomCount = this.zoomCount == 0 ? 1 : this.zoomCount;
        this.zoomOutTimer = 0;
    }

    public void zoomOut(int timer) {
        this.aiming = false;
        this.zoomOutTimer = timer;
    }

    private void updateCameraInfo(EntityViewRenderEvent.CameraSetup event, PointOfView pov, double partialTicks) {
        ActiveRenderInfo info = event.getInfo();
        Entity entity = this.minecraft.func_175606_aa();
        Vector3d vector = info.func_216785_c();
        double totalX = vector.func_82615_a();
        double totalY = vector.func_82617_b();
        double totalZ = vector.func_82616_c();
        if (pov == PointOfView.THIRD_PERSON_BACK && this.zoomCount > 0) {
            double d3;
            double posX = info.func_216785_c().field_72450_a;
            double posY = info.func_216785_c().field_72448_b;
            double posZ = info.func_216785_c().field_72449_c;
            double entityPosX = entity.field_70142_S + (entity.func_226277_ct_() - entity.field_70142_S) * partialTicks;
            double entityPosY = entity.field_70137_T + (entity.func_226278_cu_() - entity.field_70137_T) * partialTicks + (double)entity.func_70047_e();
            double entityPosZ = entity.field_70136_U + (entity.func_226281_cx_() - entity.field_70136_U) * partialTicks;
            float intpol = pov == PointOfView.THIRD_PERSON_BACK ? (float)this.zoomCount / (float)this.zoomMaxCount : 0.0f;
            Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * intpol, RenderEngine.AIMING_CORRECTION.y * intpol, RenderEngine.AIMING_CORRECTION.z * intpol);
            VisibleMatrix4f rotationMatrix = ClientEngine.INSTANCE.getPlayerData().getMatrix((float)partialTicks);
            Vec4f rotateVec = VisibleMatrix4f.transform(rotationMatrix, new Vec4f(interpolatedCorrection.x, interpolatedCorrection.y, interpolatedCorrection.z, 1.0f), null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                double d7;
                BlockRayTraceResult raytraceresult;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if ((raytraceresult = this.minecraft.field_71441_e.func_217299_a(new RayTraceContext(new Vector3d(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vector3d(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity))) == null || !((d7 = raytraceresult.func_216347_e().func_72438_d(new Vector3d(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        info.func_216775_b(totalX, totalY, totalZ);
        FloatBuffer fb = GLAllocation.func_74529_h((int)16);
        GL11.glGetFloatv((int)2983, (FloatBuffer)fb);
        this.projectionMatrix.load(fb.asReadOnlyBuffer());
    }

    public VisibleMatrix4f getCurrentProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
            LivingEntity livingentity = event.getEntity();
            if (renderEngine.isEntityContained((Entity)livingentity)) {
                if (livingentity instanceof ClientPlayerEntity && event.getPartialRenderTick() == 1.0f) {
                    return;
                }
                LivingData entitydata = (LivingData)livingentity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                if (entitydata != null && !entitydata.shouldSkipRender()) {
                    event.setCanceled(true);
                    renderEngine.renderEntityArmatureModel(livingentity, entitydata, (EntityRenderer<? extends Entity>)event.getRenderer(), event.getBuffers(), event.getMatrixStack(), event.getLight(), event.getPartialRenderTick());
                }
            }
            if (!Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                for (EntityIndicator entityIndicator : EntityIndicator.ENTITY_INDICATOR_RENDERERS) {
                    if (!entityIndicator.shouldDraw(event.getEntity())) continue;
                    entityIndicator.drawIndicator(event.getEntity(), event.getMatrixStack(), event.getBuffers(), event.getPartialRenderTick());
                }
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            block3: {
                ClientPlayerData playerCap;
                CapabilityItem cap;
                block4: {
                    if (event.getPlayer() == null) break block3;
                    cap = ModCapabilities.stackCapabilityGetter(event.getItemStack());
                    playerCap = (ClientPlayerData)event.getPlayer().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                    if (cap == null || ClientEngine.INSTANCE.getPlayerData() == null) break block3;
                    if (!ClientEngine.INSTANCE.inputController.isKeyDown(ModKeys.SPECIAL_ATTACK_TOOLTIP)) break block4;
                    if (cap.getSpecialAttack(ClientEngine.INSTANCE.getPlayerData()) == null) break block3;
                    event.getToolTip().clear();
                    List<ITextComponent> skilltooltip = cap.getSpecialAttack(ClientEngine.INSTANCE.getPlayerData()).getTooltipOnItem(event.getItemStack(), cap, playerCap);
                    for (ITextComponent s : skilltooltip) {
                        event.getToolTip().add(s);
                    }
                    break block3;
                }
                List tooltip = event.getToolTip();
                cap.modifyItemTooltip(event.getToolTip(), playerCap);
                for (int i = 0; i < tooltip.size(); ++i) {
                    TranslationTextComponent translationComponent;
                    ITextComponent sibling;
                    ITextComponent textComp = (ITextComponent)tooltip.get(i);
                    if (textComp.func_150253_a().size() <= 0 || !((sibling = (ITextComponent)textComp.func_150253_a().get(0)) instanceof TranslationTextComponent) || (translationComponent = (TranslationTextComponent)sibling).func_150271_j().length <= 1 || !(translationComponent.func_150271_j()[1] instanceof TranslationTextComponent) || !((TranslationTextComponent)translationComponent.func_150271_j()[1]).func_150268_i().equals(Attributes.field_233825_h_.func_233754_c_())) continue;
                    double weaponSpeed = ((ClientPlayerEntity)playerCap.getOriginalEntity()).func_110148_a(Attributes.field_233825_h_).func_111125_b();
                    for (AttributeModifier modifier : event.getItemStack().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
                        weaponSpeed += modifier.func_111164_d();
                    }
                    double attackSpeedPanelty = Formulars.getAttackSpeedPenalty(playerCap.getWeight(), weaponSpeed, playerCap);
                    tooltip.remove(i);
                    tooltip.add(i, new StringTextComponent(String.format(" %.2f ", weaponSpeed += attackSpeedPanelty)).func_230529_a_((ITextComponent)new TranslationTextComponent(Attributes.field_233825_h_.func_233754_c_())));
                }
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
            Events.renderEngine.updateCameraInfo(event, Minecraft.func_71410_x().field_71474_y.func_243230_g(), event.getRenderPartialTicks());
            if (renderEngine.zoomCount > 0) {
                if (renderEngine.zoomOutTimer > 0) {
                    renderEngine.zoomOutTimer--;
                } else {
                    renderEngine.zoomCount = renderEngine.aiming ? renderEngine.zoomCount + 1 : renderEngine.zoomCount - 1;
                }
                renderEngine.zoomCount = Math.min(renderEngine.zoomMaxCount, renderEngine.zoomCount);
            }
        }

        @SubscribeEvent
        public static void fogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        }

        @SubscribeEvent
        public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
                ClientPlayerData playerdata = ClientEngine.INSTANCE.getPlayerData();
                for (SkillContainer skillContainer : playerdata.skills) {
                    if (skillContainer.getContaining() == null) continue;
                    skillContainer.getContaining().onScreen(playerdata, sr.func_198107_o(), sr.func_198087_p());
                }
                if (playerdata != null && Minecraft.func_71382_s()) {
                    Events.renderEngine.guiSkillBar.renderGui(playerdata, event.getPartialTicks());
                }
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderHandEvent event) {
            boolean isBattleMode = ClientEngine.INSTANCE.isBattleMode();
            if (isBattleMode) {
                if (event.getHand() == Hand.MAIN_HAND) {
                    renderEngine.firstPersonRenderer.render(Minecraft.func_71410_x().field_71439_g, ClientEngine.INSTANCE.getPlayerData(), (EntityRenderer<ClientPlayerEntity>)null, event.getBuffers(), event.getMatrixStack(), event.getLight(), event.getPartialTicks());
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderWorldLastEvent event) {
            if (renderEngine.zoomCount > 0 && ((RenderEngine)Events.renderEngine).minecraft.field_71474_y.func_243230_g() == PointOfView.THIRD_PERSON_BACK) {
                Events.renderEngine.aimHelper.doRender(event.getMatrixStack(), event.getPartialTicks());
            }
        }
    }
}

