/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.gui.EntityIndicator;
import maninhouse.epicfight.client.gui.ModIngameGui;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.math.Vec2f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class BattleModeGui
extends ModIngameGui {
    private final Map<SkillSlot, Vec3f> screenPositionMap = new HashMap<SkillSlot, Vec3f>();
    private int guiSlider = 29;
    private boolean guiSliderToggle = false;
    protected FontRenderer font;
    private static final Vec2f[] vectorz = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public BattleModeGui() {
        this.screenPositionMap.put(SkillSlot.DODGE, new Vec3f(74.0f, 36.0f, 0.078f));
        this.screenPositionMap.put(SkillSlot.WEAPON_SPECIAL_ATTACK, new Vec3f(42.0f, 48.0f, 0.117f));
        this.font = Minecraft.func_71410_x().field_71466_p;
    }

    public void renderGui(ClientPlayerData playerdata, float partialTicks) {
        if (((ClientPlayerEntity)playerdata.getOriginalEntity()).func_184187_bx() != null) {
            return;
        }
        if (this.guiSlider > 28) {
            return;
        }
        if (this.guiSlider > 0) {
            this.guiSlider = this.guiSliderToggle ? (this.guiSlider -= 2) : (this.guiSlider += 2);
        }
        MainWindow sr = Minecraft.func_71410_x().func_228018_at_();
        int width = sr.func_198107_o();
        int height = sr.func_198087_p();
        boolean depthTestEnabled = GL11.glGetBoolean((int)2929);
        boolean blendEnabled = GL11.glGetBoolean((int)3042);
        if (depthTestEnabled) {
            GlStateManager.func_227731_j_();
        }
        if (!blendEnabled) {
            GlStateManager.func_227740_m_();
        }
        MatrixStack matStack = new MatrixStack();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(EntityIndicator.BATTLE_ICON);
        float maxStunArmor = playerdata.getMaxStunArmor();
        float stunArmor = playerdata.getStunArmor();
        if (maxStunArmor > 0.0f && stunArmor < maxStunArmor) {
            float ratio = stunArmor / maxStunArmor;
            matStack.func_227860_a_();
            matStack.func_227861_a_(0.0, (double)((float)this.guiSlider * 0.5f), 0.0);
            matStack.func_227862_a_(0.5f, 0.5f, 1.0f);
            GlStateManager.func_227702_d_((float)1.0f, (float)ratio, (float)0.25f, (float)1.0f);
            AbstractGui.func_238463_a_((MatrixStack)matStack, (int)((int)((float)(width - 120) * 2.0f)), (int)((int)((float)(height - 10) * 2.0f)), (float)2.0f, (float)38.0f, (int)237, (int)9, (int)255, (int)255);
            AbstractGui.func_238463_a_((MatrixStack)matStack, (int)((int)((float)(width - 120) * 2.0f)), (int)((int)((float)(height - 10) * 2.0f)), (float)2.0f, (float)47.0f, (int)((int)(237.0f * ratio)), (int)9, (int)255, (int)255);
            matStack.func_227865_b_();
        }
        for (int i = 0; i < SkillSlot.values().length; ++i) {
            SkillContainer container = playerdata.getSkill(i);
            if (container == null || container.isEmpty() || !this.screenPositionMap.containsKey((Object)container.getContaining().getSlot())) continue;
            SkillSlot slot = container.getContaining().getSlot();
            boolean creative = ((ClientPlayerEntity)playerdata.getOriginalEntity()).func_184812_l_();
            boolean fullstack = creative || container.isFull();
            float cooldownRatio = fullstack ? 1.0f : container.getCooldownRatio(partialTicks);
            float durationRatio = container.getDurationRatio(partialTicks);
            boolean isReady = container.getStack() > 0 || durationRatio > 0.0f || creative;
            int x = (int)this.screenPositionMap.get((Object)((Object)slot)).x;
            int y = (int)this.screenPositionMap.get((Object)((Object)slot)).y;
            float scale = this.screenPositionMap.get((Object)((Object)slot)).z;
            float multiplyScale = 1.0f / scale;
            matStack.func_227860_a_();
            matStack.func_227862_a_(scale, scale, 1.0f);
            matStack.func_227861_a_(0.0, (double)((float)this.guiSlider * multiplyScale), 0.0);
            Matrix4f matrix = matStack.func_227866_c_().func_227870_a_();
            if (!isReady) {
                GlStateManager.func_227702_d_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.8f);
            } else {
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (slot != SkillSlot.WEAPON_SPECIAL_ATTACK) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSkillTexture(container.getContaining()));
                this.drawTexturedModalRectFixCoord(matrix, (float)(width - x) * multiplyScale, (float)(height - y) * multiplyScale, 0, 0, 255, 255);
                if (!fullstack && !creative) {
                    matStack.func_227862_a_(multiplyScale, multiplyScale, 1.0f);
                    this.font.func_238405_a_(matStack, String.valueOf((int)(1.0f + container.getCooldownSec() * Math.max(1.0f / container.getContaining().getRegenTimePerTick(playerdata), 1.0f))), (float)width - (float)x + 8.0f, (float)height - (float)y + 8.0f, 0xFFFFFF);
                    GL11.glEnable((int)3008);
                    GlStateManager.func_227740_m_();
                }
            } else {
                int stringWidth;
                int j;
                CapabilityItem item = playerdata.getHeldItemCapability(Hand.MAIN_HAND);
                boolean isCompatibleWeapon = item != null && item.getSpecialAttack(playerdata) == container.getContaining();
                int vertexNum = 0;
                float iconSize = 32.0f;
                float iconSizeDiv = iconSize * 0.5f;
                float top = y;
                float bottom = (float)y - iconSize;
                float left = x;
                float right = (float)x - iconSize;
                float middle = (float)x - iconSizeDiv;
                float lastVertexX = 0.0f;
                float lastVertexY = 0.0f;
                float lastTexX = 0.0f;
                float lastTexY = 0.0f;
                if (cooldownRatio < 0.125f) {
                    vertexNum = 6;
                    lastTexX = cooldownRatio / 0.25f;
                    lastTexY = 0.0f;
                    lastVertexX = middle - iconSize * lastTexX;
                    lastVertexY = top;
                    lastTexX += 0.5f;
                } else if (cooldownRatio < 0.375f) {
                    vertexNum = 5;
                    lastTexX = 1.0f;
                    lastTexY = (cooldownRatio - 0.125f) / 0.25f;
                    lastVertexX = right;
                    lastVertexY = top - iconSize * lastTexY;
                } else if (cooldownRatio < 0.625f) {
                    vertexNum = 4;
                    lastTexX = (cooldownRatio - 0.375f) / 0.25f;
                    lastTexY = 1.0f;
                    lastVertexX = right + iconSize * lastTexX;
                    lastVertexY = bottom;
                    lastTexX = 1.0f - lastTexX;
                } else if (cooldownRatio < 0.875f) {
                    vertexNum = 3;
                    lastTexX = 0.0f;
                    lastTexY = (cooldownRatio - 0.625f) / 0.25f;
                    lastVertexX = left;
                    lastVertexY = bottom + iconSize * lastTexY;
                    lastTexY = 1.0f - lastTexY;
                } else {
                    vertexNum = 2;
                    lastTexX = (cooldownRatio - 0.875f) / 0.25f;
                    lastTexY = 0.0f;
                    lastVertexX = left - iconSize * lastTexX;
                    lastVertexY = top;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSkillTexture(container.getContaining()));
                if (isCompatibleWeapon) {
                    if (container.getStack() > 0) {
                        GlStateManager.func_227702_d_((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
                    } else {
                        GlStateManager.func_227702_d_((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
                    }
                } else {
                    GlStateManager.func_227702_d_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
                for (j = 0; j < vertexNum; ++j) {
                    bufferbuilder.func_227888_a_(matrix, ((float)width - (left - iconSize * BattleModeGui.vectorz[j].x)) * multiplyScale, ((float)height - (top - iconSize * BattleModeGui.vectorz[j].y)) * multiplyScale, 0.0f).func_225583_a_(BattleModeGui.vectorz[j].x, BattleModeGui.vectorz[j].y).func_181675_d();
                }
                bufferbuilder.func_227888_a_(matrix, ((float)width - lastVertexX) * multiplyScale, ((float)height - lastVertexY) * multiplyScale, 0.0f).func_225583_a_(lastTexX, lastTexY).func_181675_d();
                tessellator.func_78381_a();
                if (isCompatibleWeapon) {
                    GlStateManager.func_227702_d_((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
                } else {
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlStateManager.func_227605_A_();
                bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
                for (j = 0; j < 2; ++j) {
                    bufferbuilder.func_227888_a_(matrix, ((float)width - (left - iconSize * BattleModeGui.vectorz[j].x)) * multiplyScale, ((float)height - (top - iconSize * BattleModeGui.vectorz[j].y)) * multiplyScale, 0.0f).func_225583_a_(BattleModeGui.vectorz[j].x, BattleModeGui.vectorz[j].y).func_181675_d();
                }
                for (j = vectorz.length - 1; j >= vertexNum; --j) {
                    bufferbuilder.func_227888_a_(matrix, ((float)width - (left - iconSize * BattleModeGui.vectorz[j].x)) * multiplyScale, ((float)height - (top - iconSize * BattleModeGui.vectorz[j].y)) * multiplyScale, 0.0f).func_225583_a_(BattleModeGui.vectorz[j].x, BattleModeGui.vectorz[j].y).func_181675_d();
                }
                bufferbuilder.func_227888_a_(matrix, ((float)width - lastVertexX) * multiplyScale, ((float)height - lastVertexY) * multiplyScale, 0.0f).func_225583_a_(lastTexX, lastTexY).func_181675_d();
                bufferbuilder.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
                matStack.func_227862_a_(multiplyScale, multiplyScale, 1.0f);
                if (!fullstack) {
                    String s = String.valueOf((int)(cooldownRatio * 100.0f));
                    stringWidth = (this.font.func_78256_a(s) - 6) / 3;
                    this.font.func_238405_a_(matStack, s, (float)width - (float)x + 13.0f - (float)stringWidth, (float)height - (float)y + 13.0f, 0xFFFFFF);
                    GL11.glEnable((int)3008);
                    GlStateManager.func_227740_m_();
                } else if (container.getRemainDuration() > 0 && container.getContaining().getActivateType() != Skill.ActivateType.TOGGLE) {
                    String s = String.valueOf(container.getRemainDuration());
                    stringWidth = (this.font.func_78256_a(s) - 6) / 3;
                    this.font.func_238405_a_(matStack, s, (float)width - (float)x + 13.0f - (float)stringWidth, (float)height - (float)y + 13.0f, 0xFFFFFF);
                    GL11.glEnable((int)3008);
                    GlStateManager.func_227740_m_();
                }
                if (container.getContaining().getMaxStack() > 1) {
                    String s = String.valueOf(container.getStack());
                    stringWidth = (this.font.func_78256_a(s) - 6) / 3;
                    this.font.func_238405_a_(matStack, s, (float)width - (float)x + 25.0f - (float)stringWidth, (float)height - (float)y + 22.0f, 0xFFFFFF);
                }
            }
            matStack.func_227865_b_();
        }
        if (depthTestEnabled) {
            GlStateManager.func_227734_k_();
        }
        if (!blendEnabled) {
            GlStateManager.func_227737_l_();
        }
    }

    private ResourceLocation getSkillTexture(Skill skill) {
        ResourceLocation name = skill.getRegistryName();
        return new ResourceLocation(name.func_110624_b(), "textures/gui/skills/" + name.func_110623_a() + ".png");
    }

    public void slideUp() {
        this.guiSlider = 28;
        this.guiSliderToggle = true;
    }

    public void slideDown() {
        this.guiSlider = 1;
        this.guiSliderToggle = false;
    }
}

