/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.gui.HealthBarIndicator;
import maninhouse.epicfight.client.gui.ModIngameGui;
import maninhouse.epicfight.client.gui.TargetIndicator;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityIndicator
extends ModIngameGui {
    public static final List<EntityIndicator> ENTITY_INDICATOR_RENDERERS = Lists.newArrayList();
    public static final ResourceLocation BATTLE_ICON = new ResourceLocation("epicfight", "textures/gui/battle_icons.png");

    public static void init() {
        new TargetIndicator();
        new HealthBarIndicator();
    }

    public void drawTexturedModalRect2DPlane(Matrix4f matrix, IVertexBuilder vertexBuilder, float minX, float minY, float maxX, float maxY, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        this.drawTexturedModalRect3DPlane(matrix, vertexBuilder, minX, minY, this.func_230927_p_(), maxX, maxY, this.func_230927_p_(), minTexU, minTexV, maxTexU, maxTexV);
    }

    public void drawTexturedModalRect3DPlane(Matrix4f matrix, IVertexBuilder vertexBuilder, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float minTexU, float minTexV, float maxTexU, float maxTexV) {
        float cor = 0.00390625f;
        vertexBuilder.func_227888_a_(matrix, minX, minY, maxZ).func_225583_a_(minTexU * cor, maxTexV * cor).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, maxZ).func_225583_a_(maxTexU * cor, maxTexV * cor).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, minZ).func_225583_a_(maxTexU * cor, minTexV * cor).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, minZ).func_225583_a_(minTexU * cor, minTexV * cor).func_181675_d();
    }

    public EntityIndicator() {
        ENTITY_INDICATOR_RENDERERS.add(this);
    }

    public Matrix4f getMVMatrix(MatrixStack matStackIn, LivingEntity entityIn, float correctionX, float correctionY, float correctionZ, boolean lockRotation, boolean setupProjection, float partialTicks) {
        float posX = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.func_226277_ct_());
        float posY = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.func_226278_cu_());
        float posZ = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.func_226281_cx_());
        matStackIn.func_227860_a_();
        matStackIn.func_227861_a_((double)(-posX), (double)(-posY), (double)(-posZ));
        matStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        return this.getMVMatrix(matStackIn, posX + correctionX, posY + correctionY, posZ + correctionZ, lockRotation, setupProjection);
    }

    public Matrix4f getMVMatrix(MatrixStack matStackIn, float posX, float posY, float posZ, boolean lockRotation, boolean setupProjection) {
        VisibleMatrix4f viewMatrix = VisibleMatrix4f.importMatrix(matStackIn.func_227866_c_().func_227870_a_());
        VisibleMatrix4f finalMatrix = new VisibleMatrix4f();
        finalMatrix.translate(new Vec3f(-posX, posY, -posZ));
        matStackIn.func_227865_b_();
        if (lockRotation) {
            finalMatrix.m00 = viewMatrix.m00;
            finalMatrix.m01 = viewMatrix.m10;
            finalMatrix.m02 = viewMatrix.m20;
            finalMatrix.m10 = viewMatrix.m01;
            finalMatrix.m11 = viewMatrix.m11;
            finalMatrix.m12 = viewMatrix.m21;
            finalMatrix.m20 = viewMatrix.m02;
            finalMatrix.m21 = viewMatrix.m12;
            finalMatrix.m22 = viewMatrix.m22;
        }
        VisibleMatrix4f.mul(viewMatrix, finalMatrix, finalMatrix);
        if (setupProjection) {
            VisibleMatrix4f.mul(ClientEngine.INSTANCE.renderEngine.getCurrentProjectionMatrix(), finalMatrix, finalMatrix);
        }
        return VisibleMatrix4f.exportMatrix(finalMatrix);
    }

    public abstract void drawIndicator(LivingEntity var1, MatrixStack var2, IRenderTypeBuffer var3, float var4);

    public abstract boolean shouldDraw(LivingEntity var1);
}

