/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import maninhouse.epicfight.config.Option;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public class ColorSlider
extends AbstractSlider {
    private static final int[] COLOR_ARRAY = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    private final Option.DoubleOption colorOption;

    public ColorSlider(int x, int y, int width, int height, ITextComponent message, double defaultValue, Option.DoubleOption option) {
        super(x, y, width, height, message, defaultValue);
        this.colorOption = option;
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        RenderSystem.enableBlend();
        for (int i = 0; i < 6; ++i) {
            this.func_238468_a_(matrixStack, this.field_230690_l_ + this.field_230688_j_ * i / 6, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_ * (i + 1) / 6, this.field_230691_m_ + this.field_230689_k_, COLOR_ARRAY[i], COLOR_ARRAY[i + 1]);
        }
        this.func_230441_a_(matrixStack, minecraft, mouseX, mouseY);
        int j = this.getFGColor();
        ColorSlider.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)fontrenderer, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
    }

    protected void func_230441_a_(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(field_230687_i_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.func_230449_g_() ? 2 : 1) * 20;
        int minX = this.field_230690_l_ + (int)(this.field_230683_b_ * (double)(this.field_230688_j_ - 8));
        this.func_238474_b_(matrixStack, minX, this.field_230691_m_, 0, 46 + i, 4, 20);
        this.func_238474_b_(matrixStack, minX + 4, this.field_230691_m_, 196, 46 + i, 4, 20);
        ColorSlider.func_238467_a_((MatrixStack)matrixStack, (int)(minX + 1), (int)(this.field_230691_m_ + 1), (int)(minX + 7), (int)(this.field_230691_m_ + 19), (int)ColorSlider.toColorInteger(this.field_230683_b_));
    }

    protected void func_230979_b_() {
        this.colorOption.setValue(this.field_230683_b_);
    }

    protected void func_230972_a_() {
    }

    public static int toColorInteger(double sliderValue) {
        int packedColor = 0;
        for (int i = 0; i < 6; ++i) {
            double min = 0.16666666666666666 * (double)i;
            double max = 0.16666666666666666 * (double)(i + 1);
            if (!(sliderValue >= min) || !(sliderValue <= max)) continue;
            double lerpFactor = (sliderValue - min) / (max - min);
            int colorA = COLOR_ARRAY[i];
            int colorB = COLOR_ARRAY[i + 1];
            int f = colorA >> 24 & 0xFF;
            int f1 = colorA >> 16 & 0xFF;
            int f2 = colorA >> 8 & 0xFF;
            int f3 = colorA & 0xFF;
            int f4 = colorB >> 24 & 0xFF;
            int f5 = colorB >> 16 & 0xFF;
            int f6 = colorB >> 8 & 0xFF;
            int f7 = colorB & 0xFF;
            int r = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f, (double)f4);
            int g = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f1, (double)f5);
            int b = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f2, (double)f6);
            int a = (int)MathHelper.func_219803_d((double)lerpFactor, (double)f3, (double)f7);
            packedColor = r << 24 | g << 16 | b << 8 | a;
        }
        return packedColor;
    }

    protected void func_238468_a_(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y1, (float)this.func_230927_p_()).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x1, (float)y2, (float)this.func_230927_p_()).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, (float)this.func_230927_p_()).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y1, (float)this.func_230927_p_()).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

