/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.collada.ColladaModelLoader;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientModel
extends Model {
    private Mesh mesh;

    public ClientModel(ResourceLocation location) {
        super(location);
    }

    public ClientModel(Mesh mesh) {
        super(null);
        this.mesh = mesh;
    }

    public void loadMeshData() {
        try {
            this.mesh = ColladaModelLoader.getMeshData(this.location);
        }
        catch (IOException e) {
            System.err.println(this.location.func_110624_b() + " failed to load!");
        }
    }

    public void draw(MatrixStack matrixStackIn, IVertexBuilder builderIn, int packedLightIn, float r, float g, float b, float a, VisibleMatrix4f[] poses) {
        float[] animatedPosition = (float[])this.mesh.positionList.clone();
        float[] animatedNormal = (float[])this.mesh.noramlList.clone();
        int weightIndex = 0;
        for (int i = 0; i < this.mesh.vertexCount; ++i) {
            int k = i * 3;
            Vec4f totalPos = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vec4f totalNormal = new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
            Vec4f pos = new Vec4f(animatedPosition[k], animatedPosition[k + 1], animatedPosition[k + 2], 1.0f);
            Vec4f normal = new Vec4f(animatedNormal[k], animatedNormal[k + 1], animatedNormal[k + 2], 1.0f);
            for (int j = 0; j < this.mesh.weightCountList[i]; ++j) {
                if (weightIndex >= this.mesh.weightList.length) continue;
                float weight = this.mesh.weightList[weightIndex];
                VisibleMatrix4f pose = poses[this.mesh.jointIdList[weightIndex++]];
                Vec4f.add(VisibleMatrix4f.transform(pose, pos, null).scale(weight), totalPos, totalPos);
                Vec4f.add(VisibleMatrix4f.transform(pose, normal, null).scale(weight), totalNormal, totalNormal);
            }
            animatedPosition[k] = totalPos.x;
            animatedPosition[k + 1] = totalPos.y;
            animatedPosition[k + 2] = totalPos.z;
            animatedNormal[k] = totalNormal.x;
            animatedNormal[k + 1] = totalNormal.y;
            animatedNormal[k + 2] = totalNormal.z;
        }
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        Matrix3f matrix3f = matrixStackIn.func_227866_c_().func_227872_b_();
        for (int i = 0; i < this.mesh.indexCount; ++i) {
            int index = this.mesh.indexList[i];
            int im2 = index * 2;
            int im3 = index * 3;
            Vector4f position = new Vector4f(animatedPosition[im3], animatedPosition[im3 + 1], animatedPosition[im3 + 2], 1.0f);
            Vector3f normal = new Vector3f(animatedNormal[im3], animatedNormal[im3 + 1], animatedNormal[im3 + 2]);
            position.func_229372_a_(matrix4f);
            normal.func_229188_a_(matrix3f);
            builderIn.func_225588_a_(position.func_195910_a(), position.func_195913_b(), position.func_195914_c(), r, g, b, a, this.mesh.textureList[im2], this.mesh.textureList[im2 + 1], OverlayTexture.field_229196_a_, packedLightIn, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        }
    }
}

