/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.model.custom;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.client.model.ClientModel;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.collada.VertexData;
import maninhouse.epicfight.utils.math.Vec2f;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class CustomModelBakery {
    static int indexCount = 0;
    static final ModelPart HEAD = new SimplePart(9);
    static final ModelPart LEFT_FEET = new SimplePart(5);
    static final ModelPart RIGHT_FEET = new SimplePart(2);
    static final ModelPart LEFT_ARM = new Limb(16, 17, 19, 19.0f, false);
    static final ModelPart RIGHT_ARM = new Limb(11, 12, 14, 19.0f, false);
    static final ModelPart LEFT_LEG = new Limb(4, 5, 6, 6.0f, true);
    static final ModelPart RIGHT_LEG = new Limb(1, 2, 3, 6.0f, true);
    static final ModelPart CHEST = new Chest();

    public static ClientModel bakeBipedCustomArmorModel(BipedModel<?> model, ArmorItem armorItem, EquipmentSlotType equipmentSlot) {
        ArrayList allBoxes = Lists.newArrayList();
        model.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_78116_c);
        model.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178720_f);
        model.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_78115_e);
        model.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178723_h);
        model.field_178724_i.field_78809_i = true;
        model.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178724_i);
        model.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178721_j);
        model.field_178722_k.field_78809_i = true;
        model.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178722_k);
        switch (equipmentSlot) {
            case HEAD: {
                allBoxes.add(new ModelPartBind(HEAD, model.field_78116_c));
                allBoxes.add(new ModelPartBind(HEAD, model.field_178720_f));
                break;
            }
            case CHEST: {
                allBoxes.add(new ModelPartBind(CHEST, model.field_78115_e));
                allBoxes.add(new ModelPartBind(RIGHT_ARM, model.field_178723_h));
                allBoxes.add(new ModelPartBind(LEFT_ARM, model.field_178724_i));
                break;
            }
            case LEGS: {
                allBoxes.add(new ModelPartBind(CHEST, model.field_78115_e));
                allBoxes.add(new ModelPartBind(LEFT_LEG, model.field_178722_k));
                allBoxes.add(new ModelPartBind(RIGHT_LEG, model.field_178721_j));
                break;
            }
            case FEET: {
                allBoxes.add(new ModelPartBind(LEFT_FEET, model.field_178722_k));
                allBoxes.add(new ModelPartBind(RIGHT_FEET, model.field_178721_j));
                break;
            }
            default: {
                return null;
            }
        }
        ClientModel customModel = new ClientModel(CustomModelBakery.bakeMeshFromCubes(allBoxes));
        return customModel;
    }

    private static Mesh bakeMeshFromCubes(List<ModelPartBind> cubes) {
        ArrayList vertices = Lists.newArrayList();
        ArrayList indices = Lists.newArrayList();
        MatrixStack matrixStack = new MatrixStack();
        indexCount = 0;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, -24.0, 0.0);
        for (ModelPartBind modelPart : cubes) {
            CustomModelBakery.bake(matrixStack, modelPart.partedBaker, modelPart.modelRenderer, vertices, indices);
        }
        return VertexData.loadVertexInformation(vertices, ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0])), true);
    }

    private static void bake(MatrixStack matrixStack, ModelPart part, ModelRenderer renderer, List<VertexData> vertices, List<Integer> indices) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)renderer.field_78800_c, (double)renderer.field_78797_d, (double)renderer.field_78798_e);
        if (renderer.field_78808_h != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(renderer.field_78808_h));
        }
        if (renderer.field_78796_g != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(renderer.field_78796_g));
        }
        if (renderer.field_78795_f != 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(renderer.field_78795_f));
        }
        for (ModelRenderer.ModelBox cube : renderer.field_78804_l) {
            part.bakeCube(matrixStack, cube, vertices, indices);
        }
        for (ModelRenderer childRenderer : renderer.field_78805_m) {
            CustomModelBakery.bake(matrixStack, part, childRenderer, vertices, indices);
        }
        matrixStack.func_227865_b_();
    }

    static void resetRotation(ModelRenderer modelRenderer) {
        modelRenderer.field_78795_f = 0.0f;
        modelRenderer.field_78796_g = 0.0f;
        modelRenderer.field_78808_h = 0.0f;
    }

    static Direction getDirectionFromVector(Vector3f directionVec) {
        for (Direction direction : Direction.values()) {
            Vector3f direcVec = new Vector3f(Float.compare(directionVec.func_195899_a(), -0.0f) == 0 ? 0.0f : directionVec.func_195899_a(), directionVec.func_195900_b(), directionVec.func_195902_c());
            if (!direcVec.equals((Object)direction.func_229386_k_())) continue;
            return direction;
        }
        return null;
    }

    static ModelRenderer.PositionTextureVertex getTranslatedVertex(ModelRenderer.PositionTextureVertex original, Matrix4f matrix) {
        Vector4f translatedPosition = new Vector4f(original.field_78243_a);
        translatedPosition.func_229372_a_(matrix);
        return new ModelRenderer.PositionTextureVertex(translatedPosition.func_195910_a(), translatedPosition.func_195913_b(), translatedPosition.func_195914_c(), original.field_78241_b, original.field_78242_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TexturedJointQuad {
        public final PositionTextureJointVertex[] animatedVertexPositions;
        public final Vector3f normal;

        public TexturedJointQuad(PositionTextureJointVertex[] positionsIn, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            this.normal = directionIn.func_229386_k_();
        }

        public TexturedJointQuad(PositionTextureJointVertex[] positionsIn, float cor, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new PositionTextureJointVertex(positionsIn[0].func_78240_a(positionsIn[0].field_78241_b, positionsIn[0].field_78242_c + cor), positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new PositionTextureJointVertex(positionsIn[1].func_78240_a(positionsIn[1].field_78241_b, positionsIn[1].field_78242_c + cor), positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new PositionTextureJointVertex(positionsIn[2].func_78240_a(positionsIn[2].field_78241_b, positionsIn[2].field_78242_c - cor), positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new PositionTextureJointVertex(positionsIn[3].func_78240_a(positionsIn[3].field_78241_b, positionsIn[3].field_78242_c - cor), positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = directionIn.func_229386_k_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PositionTextureJointVertex
    extends ModelRenderer.PositionTextureVertex {
        final Vector3i jointId;
        final Vector3f weight;

        public PositionTextureJointVertex(ModelRenderer.PositionTextureVertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public PositionTextureJointVertex(ModelRenderer.PositionTextureVertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vector3i(jointId1, jointId2, jointId3), new Vector3f(weight1, weight2, weight3));
        }

        public PositionTextureJointVertex(ModelRenderer.PositionTextureVertex posTexVertx, Vector3i ids, Vector3f weights) {
            super(posTexVertx.field_78243_a.func_195899_a(), posTexVertx.field_78243_a.func_195900_b(), posTexVertx.field_78243_a.func_195902_c(), posTexVertx.field_78241_b, posTexVertx.field_78242_c);
            this.jointId = ids;
            this.weight = weights;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Limb
    extends ModelPart {
        final int upperJointId;
        final int lowerJointId;
        final int middleJointId;
        final float cutY;
        final boolean frontOrBack;

        public Limb(int upperJointId, int lowerJointId, int middleJointId, float cutY, boolean frontOrBack) {
            this.upperJointId = upperJointId;
            this.lowerJointId = lowerJointId;
            this.middleJointId = middleJointId;
            this.cutY = cutY;
            this.frontOrBack = frontOrBack;
        }

        @Override
        public void bakeCube(MatrixStack matrixStack, ModelRenderer.ModelBox cube, List<VertexData> vertices, List<Integer> indices) {
            ArrayList quads = Lists.newArrayList();
            for (ModelRenderer.TexturedQuad quad : cube.field_78254_i) {
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                ModelRenderer.PositionTextureVertex pos0 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[0], matrix);
                ModelRenderer.PositionTextureVertex pos1 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[1], matrix);
                ModelRenderer.PositionTextureVertex pos2 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[2], matrix);
                ModelRenderer.PositionTextureVertex pos3 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[3], matrix);
                Direction direction = CustomModelBakery.getDirectionFromVector(quad.field_228312_b_);
                if (pos1.field_78243_a.func_195900_b() > this.cutY != pos2.field_78243_a.func_195900_b() > this.cutY) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = pos2.field_78243_a.func_195900_b() - pos1.field_78243_a.func_195900_b();
                    float textureV = pos1.field_78242_c + (pos2.field_78242_c - pos1.field_78242_c) * ((this.cutY - pos1.field_78243_a.func_195900_b()) / distance);
                    ModelRenderer.PositionTextureVertex pos4 = new ModelRenderer.PositionTextureVertex(pos0.field_78243_a.func_195899_a(), this.cutY, pos0.field_78243_a.func_195902_c(), pos0.field_78241_b, textureV);
                    ModelRenderer.PositionTextureVertex pos5 = new ModelRenderer.PositionTextureVertex(pos1.field_78243_a.func_195899_a(), this.cutY, pos1.field_78243_a.func_195902_c(), pos1.field_78241_b, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJointId;
                        lowerId = this.upperJointId;
                    } else {
                        upperId = this.upperJointId;
                        lowerId = this.lowerJointId;
                    }
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, upperId), new PositionTextureJointVertex(pos1, upperId), new PositionTextureJointVertex(pos5, upperId), new PositionTextureJointVertex(pos4, upperId)}, direction));
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, lowerId), new PositionTextureJointVertex(pos5, lowerId), new PositionTextureJointVertex(pos2, lowerId), new PositionTextureJointVertex(pos3, lowerId)}, direction));
                    boolean bl = hasSameZ = pos4.field_78243_a.func_195902_c() < 0.0f == pos5.field_78243_a.func_195902_c() < 0.0f;
                    boolean bl2 = hasSameZ && pos4.field_78243_a.func_195902_c() < 0.0f == this.frontOrBack ? true : (isFront = false);
                    if (isFront) {
                        quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, this.middleJointId), new PositionTextureJointVertex(pos5, this.middleJointId), new PositionTextureJointVertex(pos5, this.upperJointId), new PositionTextureJointVertex(pos4, this.upperJointId)}, 0.001f, direction));
                        quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, this.lowerJointId), new PositionTextureJointVertex(pos5, this.lowerJointId), new PositionTextureJointVertex(pos5, this.middleJointId), new PositionTextureJointVertex(pos4, this.middleJointId)}, 0.001f, direction));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.field_78243_a.func_195902_c() > 0.0f;
                    int firstJoint = this.lowerJointId;
                    int secondJoint = this.lowerJointId;
                    int thirdJoint = startFront ? this.upperJointId : this.middleJointId;
                    int fourthJoint = startFront ? this.middleJointId : this.upperJointId;
                    int fifthJoint = this.upperJointId;
                    int sixthJoint = this.upperJointId;
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, firstJoint), new PositionTextureJointVertex(pos5, secondJoint), new PositionTextureJointVertex(pos5, thirdJoint), new PositionTextureJointVertex(pos4, fourthJoint)}, 0.001f, direction));
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, fourthJoint), new PositionTextureJointVertex(pos5, thirdJoint), new PositionTextureJointVertex(pos5, fifthJoint), new PositionTextureJointVertex(pos4, sixthJoint)}, 0.001f, direction));
                    continue;
                }
                int jointId = pos0.field_78243_a.func_195900_b() > this.cutY ? this.upperJointId : this.lowerJointId;
                quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, jointId), new PositionTextureJointVertex(pos1, jointId), new PositionTextureJointVertex(pos2, jointId), new PositionTextureJointVertex(pos3, jointId)}, direction));
            }
            for (TexturedJointQuad quad : quads) {
                Vector3f norm = quad.normal.func_229195_e_();
                norm.func_229188_a_(matrixStack.func_227866_c_().func_227872_b_());
                for (PositionTextureJointVertex vertex : quad.animatedVertexPositions) {
                    Vector4f pos = new Vector4f(vertex.field_78243_a);
                    vertices.add(new VertexData().setPosition(new Vec3f(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()).scale(0.0625f)).setNormal(new Vec3f(norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c())).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(vertex.jointId.func_177958_n(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                indices.add(indexCount);
                indices.add(indexCount + 1);
                indices.add(indexCount + 3);
                indices.add(indexCount + 3);
                indices.add(indexCount + 1);
                indices.add(indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Chest
    extends ModelPart {
        final float cutX = 0.0f;
        final WeightPair[] cutYList = new WeightPair[]{new WeightPair(13.6666f, 0.254f, 0.746f), new WeightPair(15.8333f, 0.254f, 0.746f), new WeightPair(18.0f, 0.5f, 0.5f), new WeightPair(20.1666f, 0.744f, 0.256f), new WeightPair(22.3333f, 0.77f, 0.23f)};

        Chest() {
        }

        @Override
        public void bakeCube(MatrixStack matrixStack, ModelRenderer.ModelBox cube, List<VertexData> vertices, List<Integer> indices) {
            ArrayList seperatedX = Lists.newArrayList();
            ArrayList seperatedXY = Lists.newArrayList();
            for (ModelRenderer.TexturedQuad quad : cube.field_78254_i) {
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                ModelRenderer.PositionTextureVertex pos0 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[0], matrix);
                ModelRenderer.PositionTextureVertex pos1 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[1], matrix);
                ModelRenderer.PositionTextureVertex pos2 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[2], matrix);
                ModelRenderer.PositionTextureVertex pos3 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[3], matrix);
                Direction direction = CustomModelBakery.getDirectionFromVector(quad.field_228312_b_);
                WeightPair pos0Weight = this.getMatchingWeightPair(pos0.field_78243_a.func_195900_b());
                WeightPair pos1Weight = this.getMatchingWeightPair(pos1.field_78243_a.func_195900_b());
                WeightPair pos2Weight = this.getMatchingWeightPair(pos2.field_78243_a.func_195900_b());
                WeightPair pos3Weight = this.getMatchingWeightPair(pos3.field_78243_a.func_195900_b());
                if (pos1.field_78243_a.func_195899_a() > this.cutX != pos2.field_78243_a.func_195899_a() > this.cutX) {
                    float distance = pos2.field_78243_a.func_195899_a() - pos1.field_78243_a.func_195899_a();
                    float textureU = pos1.field_78241_b + (pos2.field_78241_b - pos1.field_78241_b) * ((this.cutX - pos1.field_78243_a.func_195899_a()) / distance);
                    ModelRenderer.PositionTextureVertex pos4 = new ModelRenderer.PositionTextureVertex(pos0.field_78243_a.func_195899_a(), this.cutX, pos0.field_78243_a.func_195902_c(), textureU, pos0.field_78242_c);
                    ModelRenderer.PositionTextureVertex pos5 = new ModelRenderer.PositionTextureVertex(pos1.field_78243_a.func_195899_a(), this.cutX, pos1.field_78243_a.func_195902_c(), textureU, pos1.field_78242_c);
                    seperatedX.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos4, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos5, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos3, 8, 7, 0, pos3Weight.weightLower, pos3Weight.weightUpper, 0.0f)}, direction));
                    seperatedX.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos1, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos2, 8, 7, 0, pos2Weight.weightLower, pos2Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos5, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f)}, direction));
                    continue;
                }
                seperatedX.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos1, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos2, 8, 7, 0, pos2Weight.weightLower, pos2Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos3, 8, 7, 0, pos3Weight.weightLower, pos3Weight.weightUpper, 0.0f)}, direction));
            }
            for (TexturedJointQuad quad : seperatedX) {
                boolean upsideDown = quad.animatedVertexPositions[1].field_78243_a.func_195900_b() > quad.animatedVertexPositions[2].field_78243_a.func_195900_b();
                PositionTextureJointVertex pos0 = upsideDown ? quad.animatedVertexPositions[2] : quad.animatedVertexPositions[0];
                PositionTextureJointVertex pos1 = upsideDown ? quad.animatedVertexPositions[3] : quad.animatedVertexPositions[1];
                PositionTextureJointVertex pos2 = upsideDown ? quad.animatedVertexPositions[0] : quad.animatedVertexPositions[2];
                PositionTextureJointVertex pos3 = upsideDown ? quad.animatedVertexPositions[1] : quad.animatedVertexPositions[3];
                Direction direction = CustomModelBakery.getDirectionFromVector(quad.normal);
                List<WeightPair> weightPairList = this.getMatchingWeightPairs(pos1.field_78243_a.func_195900_b(), pos2.field_78243_a.func_195900_b());
                ArrayList addedVertexList = Lists.newArrayList();
                addedVertexList.add(pos0);
                addedVertexList.add(pos1);
                if (weightPairList.size() > 0) {
                    for (WeightPair weightPair : weightPairList) {
                        float distance = pos2.field_78243_a.func_195900_b() - pos1.field_78243_a.func_195900_b();
                        float textureV = pos1.field_78242_c + (pos2.field_78242_c - pos1.field_78242_c) * ((weightPair.cutY - pos1.field_78243_a.func_195900_b()) / distance);
                        ModelRenderer.PositionTextureVertex pos4 = new ModelRenderer.PositionTextureVertex(pos0.field_78243_a.func_195899_a(), weightPair.cutY, pos0.field_78243_a.func_195902_c(), pos0.field_78241_b, textureV);
                        ModelRenderer.PositionTextureVertex pos5 = new ModelRenderer.PositionTextureVertex(pos1.field_78243_a.func_195899_a(), weightPair.cutY, pos1.field_78243_a.func_195902_c(), pos1.field_78241_b, textureV);
                        addedVertexList.add(new PositionTextureJointVertex(pos4, 8, 7, 0, weightPair.weightLower, weightPair.weightUpper, 0.0f));
                        addedVertexList.add(new PositionTextureJointVertex(pos5, 8, 7, 0, weightPair.weightLower, weightPair.weightUpper, 0.0f));
                    }
                }
                addedVertexList.add(pos3);
                addedVertexList.add(pos2);
                for (int i = 0; i < (addedVertexList.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    PositionTextureJointVertex p0 = (PositionTextureJointVertex)((Object)addedVertexList.get(start));
                    PositionTextureJointVertex p1 = (PositionTextureJointVertex)((Object)addedVertexList.get(start + 1));
                    PositionTextureJointVertex p2 = (PositionTextureJointVertex)((Object)addedVertexList.get(start + 3));
                    PositionTextureJointVertex p3 = (PositionTextureJointVertex)((Object)addedVertexList.get(start + 2));
                    seperatedXY.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(p0, 8, 7, 0, p0.weight.func_195899_a(), p0.weight.func_195900_b(), 0.0f), new PositionTextureJointVertex(p1, 8, 7, 0, p1.weight.func_195899_a(), p1.weight.func_195900_b(), 0.0f), new PositionTextureJointVertex(p2, 8, 7, 0, p2.weight.func_195899_a(), p2.weight.func_195900_b(), 0.0f), new PositionTextureJointVertex(p3, 8, 7, 0, p3.weight.func_195899_a(), p3.weight.func_195900_b(), 0.0f)}, direction));
                }
            }
            for (TexturedJointQuad quad : seperatedXY) {
                Vector3f norm = quad.normal.func_229195_e_();
                norm.func_229188_a_(matrixStack.func_227866_c_().func_227872_b_());
                for (PositionTextureJointVertex vertex : quad.animatedVertexPositions) {
                    int count;
                    Vector4f pos = new Vector4f(vertex.field_78243_a);
                    float weight1 = vertex.weight.func_195899_a();
                    float weight2 = vertex.weight.func_195900_b();
                    int joint1 = vertex.jointId.func_177958_n();
                    int joint2 = vertex.jointId.func_177956_o();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new VertexData().setPosition(new Vec3f(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()).scale(0.0625f)).setNormal(new Vec3f(norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c())).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                indices.add(indexCount);
                indices.add(indexCount + 1);
                indices.add(indexCount + 3);
                indices.add(indexCount + 3);
                indices.add(indexCount + 1);
                indices.add(indexCount + 2);
                indexCount += 4;
            }
        }

        WeightPair getMatchingWeightPair(float y) {
            if (y < this.cutYList[0].cutY) {
                return new WeightPair(y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < this.cutYList.length; ++i) {
            }
            if (index > 0) {
                WeightPair pair = this.cutYList[index];
                return new WeightPair(y, pair.weightLower, pair.weightUpper);
            }
            return new WeightPair(y, 1.0f, 0.0f);
        }

        List<WeightPair> getMatchingWeightPairs(float minY, float maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (WeightPair pair : this.cutYList) {
                if (!(pair.cutY > minY) || !(maxY >= pair.cutY)) continue;
                cutYs.add(pair);
            }
            return cutYs;
        }

        static class WeightPair {
            final float cutY;
            final float weightLower;
            final float weightUpper;

            public WeightPair(float cutY, float weightLower, float weightUpper) {
                this.cutY = cutY;
                this.weightLower = weightLower;
                this.weightUpper = weightUpper;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimplePart
    extends ModelPart {
        final int jointId;

        public SimplePart(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(MatrixStack matrixStack, ModelRenderer.ModelBox cube, List<VertexData> vertices, List<Integer> indices) {
            for (ModelRenderer.TexturedQuad quad : cube.field_78254_i) {
                Vector3f norm = quad.field_228312_b_.func_229195_e_();
                norm.func_229188_a_(matrixStack.func_227866_c_().func_227872_b_());
                for (ModelRenderer.PositionTextureVertex vertex : quad.field_78239_a) {
                    Vector4f pos = new Vector4f(vertex.field_78243_a);
                    pos.func_229372_a_(matrixStack.func_227866_c_().func_227870_a_());
                    vertices.add(new VertexData().setPosition(new Vec3f(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c()).scale(0.0625f)).setNormal(new Vec3f(norm.func_195899_a(), norm.func_195900_b(), norm.func_195902_c())).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                indices.add(indexCount);
                indices.add(indexCount + 1);
                indices.add(indexCount + 3);
                indices.add(indexCount + 3);
                indices.add(indexCount + 1);
                indices.add(indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class ModelPart {
        ModelPart() {
        }

        public abstract void bakeCube(MatrixStack var1, ModelRenderer.ModelBox var2, List<VertexData> var3, List<Integer> var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelPartBind {
        ModelRenderer modelRenderer;
        ModelPart partedBaker;

        public ModelPartBind(ModelPart partedBaker, ModelRenderer modelRenderer) {
            this.partedBaker = partedBaker;
            this.modelRenderer = modelRenderer;
        }
    }
}

