/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.client.particle.ParticleRenderTypes;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HierarchicalParticle
extends SpriteTexturedParticle {
    private LivingData<?> entitydata;
    private int jointKey;

    protected HierarchicalParticle(ClientWorld worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        Entity e = worldIn.func_73045_a((int)Double.doubleToLongBits(xSpeedIn));
        this.entitydata = (LivingData)e.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        this.jointKey = (int)Double.doubleToLongBits(ySpeedIn);
    }

    public void func_189213_a() {
        if (this.field_187133_m) {
            this.entitydata = null;
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo entityIn, float partialTicks) {
        this.entitydata.getClientAnimator().setPoseToModel(partialTicks);
        Joint joint = this.entitydata.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointById(this.jointKey);
        VisibleMatrix4f jointTransform = VisibleMatrix4f.mul(joint.getAnimatedTransform(), this.entitydata.getModelMatrix(partialTicks), null);
        this.field_187126_f = jointTransform.m30;
        this.field_187127_g = jointTransform.m31;
        this.field_187128_h = jointTransform.m32;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        super.func_225606_a_(buffer, entityIn, partialTicks);
    }

    public IParticleRenderType func_217558_b() {
        return ParticleRenderTypes.DISABLE_LIGHTMAP_PARTICLE;
    }
}

