/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.animation.types.ActionAnimation;
import maninhouse.epicfight.animation.types.AimingAnimation;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.model.ClientModel;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.client.renderer.entity.ArmatureRenderer;
import maninhouse.epicfight.client.renderer.layer.HeldItemLayer;
import maninhouse.epicfight.client.renderer.layer.WearableItemLayer;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class FirstPersonRenderer
extends ArmatureRenderer<ClientPlayerEntity, ClientPlayerData> {
    public FirstPersonRenderer() {
        this.layers.add(new HeldItemLayer());
        this.layers.add(new WearableItemLayer(EquipmentSlotType.CHEST));
        this.layers.add(new WearableItemLayer(EquipmentSlotType.LEGS));
        this.layers.add(new WearableItemLayer(EquipmentSlotType.FEET));
    }

    @Override
    public void render(ClientPlayerEntity entityIn, ClientPlayerData entitydata, EntityRenderer<ClientPlayerEntity> renderer, IRenderTypeBuffer buffer, MatrixStack matStackIn, int packedLightIn, float partialTicks) {
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d projView = renderInfo.func_216785_c();
        double x = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_()) - projView.func_82615_a();
        double y = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_()) - projView.func_82617_b();
        double z = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_()) - projView.func_82616_c();
        ClientModel model = entitydata.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        armature.initializeTransform();
        entitydata.getClientAnimator().setPoseToModel(partialTicks);
        VisibleMatrix4f[] poses = armature.getJointTransforms();
        matStackIn.func_227860_a_();
        Vec4f headPos = new Vec4f(0.0f, entityIn.func_70047_e(), 0.0f, 1.0f);
        VisibleMatrix4f.transform(poses[9], headPos, headPos);
        float pitch = renderInfo.func_216777_e();
        DynamicAnimation base = entitydata.getClientAnimator().getPlayer().getPlay();
        DynamicAnimation mix = entitydata.getClientAnimator().mixLayer.animationPlayer.getPlay();
        boolean flag1 = base instanceof ActionAnimation;
        boolean flag2 = mix instanceof AimingAnimation;
        float zCoord = flag1 ? 0.0f : poses[0].m32;
        float posZ = Math.min(headPos.z - zCoord, 0.0f);
        if (headPos.z > poses[0].m32) {
            posZ += poses[0].m32 - headPos.z;
        }
        if (!flag2) {
            matStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        }
        float interpolation = pitch > 0.0f ? pitch / 90.0f : 0.0f;
        matStackIn.func_227861_a_(x, y - 0.1 - 0.2 * (flag2 ? 0.8 : (double)interpolation), z + 0.1 + 0.7 * (flag2 ? 0.0 : (double)interpolation) - (double)posZ);
        ClientModels.LOGICAL_CLIENT.ENTITY_BIPED_FIRST_PERSON.draw(matStackIn, buffer.getBuffer(ModRenderTypes.getAnimatedModel(((ClientPlayerEntity)entitydata.getOriginalEntity()).func_110306_p())), packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, poses);
        if (!entityIn.func_175149_v()) {
            this.renderLayer(entitydata, entityIn, poses, buffer, matStackIn, packedLightIn, partialTicks);
        }
        matStackIn.func_227865_b_();
    }

    @Override
    protected ResourceLocation getEntityTexture(ClientPlayerEntity entityIn) {
        return entityIn.func_110306_p();
    }
}

