/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.client.model.ClientModel;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.client.renderer.layer.Layer;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public abstract class ArmatureRenderer<E extends LivingEntity, T extends LivingData<E>> {
    protected List<Layer<E, T>> layers = Lists.newArrayList();
    protected static Method canRenderName = ObfuscationReflectionHelper.findMethod(EntityRenderer.class, (String)"func_177070_b", (Class[])new Class[]{Entity.class});
    protected static Method renderName = ObfuscationReflectionHelper.findMethod(EntityRenderer.class, (String)"func_225629_a_", (Class[])new Class[]{Entity.class, ITextComponent.class, MatrixStack.class, IRenderTypeBuffer.class, Integer.TYPE});

    public void render(E entityIn, T entitydata, EntityRenderer<E> renderer, IRenderTypeBuffer buffer, MatrixStack matStack, int packedLightIn, float partialTicks) {
        try {
            RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent(entityIn, entityIn.func_145748_c_(), renderer, matStack, buffer, packedLightIn, partialTicks);
            MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
            if ((((Boolean)canRenderName.invoke(renderer, entityIn)).booleanValue() || renderNameplateEvent.getResult() == Event.Result.ALLOW) && renderNameplateEvent.getResult() != Event.Result.DENY) {
                renderName.invoke(renderer, entityIn, renderNameplateEvent.getContent(), matStack, buffer, packedLightIn);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean flag = this.isVisible(entityIn);
        boolean flag1 = !flag && !entityIn.func_98034_c((PlayerEntity)mc.field_71439_g);
        boolean flag2 = mc.func_238206_b_(entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitydata, flag, flag1, flag2);
        ClientModel model = ((LivingData)entitydata).getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        armature.initializeTransform();
        matStack.func_227860_a_();
        this.applyRotations(matStack, armature, entityIn, entitydata, partialTicks);
        ((LivingData)entitydata).getClientAnimator().setPoseToModel(partialTicks);
        VisibleMatrix4f[] poses = armature.getJointTransforms();
        if (renderType != null) {
            AnimatorClient animator;
            AnimationPlayer player;
            IVertexBuilder builder = buffer.getBuffer(renderType);
            model.draw(matStack, builder, packedLightIn, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f, poses);
            if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && (player = (animator = ((LivingData)entitydata).getClientAnimator()).getPlayer()).getPlay() instanceof AttackAnimation) {
                AttackAnimation attackAnimation = (AttackAnimation)player.getPlay();
                float prevElapsedTime = player.getPrevElapsedTime();
                float elapsedTime = player.getElapsedTime();
                attackAnimation.getCollider((LivingData<?>)entitydata, elapsedTime).draw(matStack, buffer, (LivingData<?>)entitydata, attackAnimation, prevElapsedTime, elapsedTime, partialTicks);
            }
        }
        if (!entityIn.func_175149_v()) {
            this.renderLayer(entitydata, entityIn, poses, buffer, matStack, packedLightIn, partialTicks);
        }
        matStack.func_227865_b_();
    }

    public RenderType getRenderType(E entityIn, T entitydata, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        ResourceLocation resourcelocation = this.getEntityTexture(entityIn);
        if (isVisibleToPlayer) {
            return ModRenderTypes.getItemEntityTranslucentCull(resourcelocation);
        }
        if (isVisible) {
            return this.getCommonRenderType(resourcelocation);
        }
        return isGlowing ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }

    protected abstract ResourceLocation getEntityTexture(E var1);

    protected void renderLayer(T entitydata, E entityIn, VisibleMatrix4f[] poses, IRenderTypeBuffer buffer, MatrixStack matrixStackIn, int packedLightIn, float partialTicks) {
        for (Layer<E, T> layer : this.layers) {
            layer.renderLayer(entitydata, entityIn, matrixStackIn, buffer, packedLightIn, poses, partialTicks);
        }
    }

    protected boolean isVisible(E entityIn) {
        return !entityIn.func_82150_aj();
    }

    protected RenderType getCommonRenderType(ResourceLocation resourcelocation) {
        return ModRenderTypes.getAnimatedModel(resourcelocation);
    }

    protected void transformJoint(int jointId, Armature modelArmature, VisibleMatrix4f mat) {
        Joint joint = modelArmature.findJointById(jointId);
        VisibleMatrix4f.mul(joint.getAnimatedTransform(), mat, joint.getAnimatedTransform());
    }

    protected void applyRotations(MatrixStack matStack, Armature armature, E entityIn, T entitydata, float partialTicks) {
        VisibleMatrix4f transpose = ((LivingData)entitydata).getModelMatrix(partialTicks).transpose();
        matStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        MathUtils.rotateStack(matStack, transpose);
        MathUtils.scaleStack(matStack, transpose);
    }
}

