/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.events.engine.RenderEngine;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemBase {
    protected VisibleMatrix4f correctionMatrix = new VisibleMatrix4f();
    protected static final VisibleMatrix4f BACK_COORECTION = new VisibleMatrix4f();
    public static RenderEngine renderEngine;

    public RenderItemBase() {
        VisibleMatrix4f.rotate((float)Math.toRadians(-80.0), new Vec3f(1.0f, 0.0f, 0.0f), this.correctionMatrix, this.correctionMatrix);
        VisibleMatrix4f.translate(new Vec3f(0.0f, 0.1f, 0.0f), this.correctionMatrix, this.correctionMatrix);
    }

    public void renderItemInHand(ItemStack stack, LivingData<?> itemHolder, Hand hand, IRenderTypeBuffer buffer, MatrixStack matrixStackIn, int packedLight) {
        VisibleMatrix4f modelMatrix = this.getCorrectionMatrix(stack, itemHolder, hand);
        String heldingHand = hand == Hand.MAIN_HAND ? "Tool_R" : "Tool_L";
        VisibleMatrix4f jointTransform = itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointByName(heldingHand).getAnimatedTransform();
        VisibleMatrix4f.mul(jointTransform, modelMatrix, modelMatrix);
        VisibleMatrix4f transpose = VisibleMatrix4f.transpose(modelMatrix, null);
        MathUtils.translateStack(matrixStackIn, modelMatrix);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(itemHolder.getOriginalEntity(), stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, matrixStackIn, buffer, packedLight);
        GlStateManager.func_227734_k_();
    }

    public void renderItemBack(ItemStack stack, LivingData<?> itemHolder, IRenderTypeBuffer buffer, MatrixStack viewMatrixStack, int packedLight) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f(BACK_COORECTION);
        VisibleMatrix4f.mul(itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointById(0).getAnimatedTransform(), modelMatrix, modelMatrix);
        VisibleMatrix4f transpose = VisibleMatrix4f.transpose(modelMatrix, null);
        MathUtils.translateStack(viewMatrixStack, modelMatrix);
        MathUtils.rotateStack(viewMatrixStack, transpose);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.field_229196_a_, viewMatrixStack, buffer);
    }

    public void renderItemOnHead(ItemStack stack, LivingData<?> itemHolder, IRenderTypeBuffer buffer, MatrixStack viewMatrixStack, int packedLight, float partialTicks) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f();
        VisibleMatrix4f.translate(new Vec3f(0.0f, 0.2f, 0.0f), modelMatrix, modelMatrix);
        VisibleMatrix4f.mul(itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointById(9).getAnimatedTransform(), modelMatrix, modelMatrix);
        VisibleMatrix4f.scale(new Vec3f(0.6f, 0.6f, 0.6f), modelMatrix, modelMatrix);
        VisibleMatrix4f transpose = VisibleMatrix4f.transpose(modelMatrix, null);
        MathUtils.translateStack(viewMatrixStack, modelMatrix);
        MathUtils.rotateStack(viewMatrixStack, transpose);
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(itemHolder.getOriginalEntity(), stack, ItemCameraTransforms.TransformType.HEAD, false, viewMatrixStack, buffer, packedLight);
    }

    public VisibleMatrix4f getCorrectionMatrix(ItemStack stack, LivingData<?> itemHolder, Hand hand) {
        return new VisibleMatrix4f(this.correctionMatrix);
    }

    static {
        VisibleMatrix4f.translate(new Vec3f(0.5f, 1.0f, 0.1f), BACK_COORECTION, BACK_COORECTION);
        VisibleMatrix4f.rotate((float)Math.toRadians(130.0), new Vec3f(0.0f, 0.0f, 1.0f), BACK_COORECTION, BACK_COORECTION);
        VisibleMatrix4f.rotate((float)Math.toRadians(100.0), new Vec3f(0.0f, 1.0f, 0.0f), BACK_COORECTION, BACK_COORECTION);
    }
}

