/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.client.renderer.item.RenderItemBase;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderItemMirror
extends RenderItemBase {
    protected VisibleMatrix4f leftHandCorrectionMatrix;

    @Override
    public void renderItemInHand(ItemStack stack, LivingData<?> itemHolder, Hand hand, IRenderTypeBuffer buffer, MatrixStack matrixStackIn, int packedLight) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f(hand == Hand.OFF_HAND ? this.leftHandCorrectionMatrix : this.correctionMatrix);
        String heldingHand = hand == Hand.MAIN_HAND ? "Tool_R" : "Tool_L";
        VisibleMatrix4f.mul(itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointByName(heldingHand).getAnimatedTransform(), modelMatrix, modelMatrix);
        VisibleMatrix4f transpose = VisibleMatrix4f.transpose(modelMatrix, null);
        matrixStackIn.func_227860_a_();
        MathUtils.translateStack(matrixStackIn, modelMatrix);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, packedLight, OverlayTexture.field_229196_a_, matrixStackIn, buffer);
        matrixStackIn.func_227865_b_();
    }
}

