/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.layer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import maninhouse.epicfight.capabilities.entity.mob.IronGolemData;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.client.renderer.layer.Layer;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GolemCrackLayer
extends Layer<IronGolemEntity, IronGolemData> {
    private static final Map<IronGolemEntity.Cracks, ResourceLocation> CRACK_MAP = ImmutableMap.of((Object)IronGolemEntity.Cracks.LOW, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_low.png"), (Object)IronGolemEntity.Cracks.MEDIUM, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_medium.png"), (Object)IronGolemEntity.Cracks.HIGH, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_high.png"));

    @Override
    public void renderLayer(IronGolemData entitydata, IronGolemEntity entityGolem, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, VisibleMatrix4f[] poses, float partialTicks) {
        IronGolemEntity.Cracks crack = entityGolem.func_226512_l_();
        if (crack != IronGolemEntity.Cracks.NONE) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(ModRenderTypes.getEntityCutoutNoCull(CRACK_MAP.get(crack)));
            entitydata.getEntityModel(ClientModels.LOGICAL_CLIENT).draw(matrixStackIn, ivertexbuilder, packedLightIn, 1.0f, 1.0f, 1.0f, 1.0f, poses);
        }
    }
}

