/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.renderer.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.ArmorCapability;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.model.ClientModel;
import maninhouse.epicfight.client.model.custom.CustomModelBakery;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.client.renderer.layer.Layer;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class WearableItemLayer<E extends LivingEntity, T extends LivingData<E>>
extends Layer<E, T> {
    private static final Map<ResourceLocation, ClientModel> ARMOR_MODEL_MAP = new HashMap<ResourceLocation, ClientModel>();
    private static final Map<BipedModel<?>, ClientModel> ARMOR_MODEL_MAP_BY_MODEL = new HashMap();
    private final EquipmentSlotType slot;

    public WearableItemLayer(EquipmentSlotType slotType) {
        this.slot = slotType;
    }

    private void renderArmor(MatrixStack matStack, IRenderTypeBuffer buf, int packedLightIn, boolean hasEffect, ClientModel model, float r, float g, float b, ResourceLocation armorResource, VisibleMatrix4f[] poses) {
        IVertexBuilder ivertexbuilder = ModRenderTypes.getArmorVertexBuilder(buf, ModRenderTypes.getAnimatedArmorModel(armorResource), hasEffect);
        model.draw(matStack, ivertexbuilder, packedLightIn, r, g, b, 1.0f, poses);
    }

    @Override
    public void renderLayer(T entitydata, E entityliving, MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int packedLightIn, VisibleMatrix4f[] poses, float partialTicks) {
        ItemStack stack = entityliving.func_184582_a(this.slot);
        Item item = stack.func_77973_b();
        matrixStackIn.func_227860_a_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)stack.func_77973_b();
            if (this.slot != armorItem.func_185083_B_()) {
                matrixStackIn.func_227865_b_();
                return;
            }
            if (this.slot == EquipmentSlotType.HEAD && entityliving instanceof ZombieVillagerEntity) {
                matrixStackIn.func_227861_a_(0.0, 0.1, 0.0);
            }
            ClientModel model = this.getArmorModel(entityliving, armorItem, stack);
            boolean hasEffect = stack.func_77962_s();
            if (armorItem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armorItem).func_200886_f(stack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(matrixStackIn, buffer, packedLightIn, hasEffect, model, r, g, b, this.getArmorTexture(stack, (Entity)entityliving, this.slot, null), poses);
                this.renderArmor(matrixStackIn, buffer, packedLightIn, hasEffect, model, 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, this.slot, "overlay"), poses);
            } else {
                this.renderArmor(matrixStackIn, buffer, packedLightIn, hasEffect, model, 1.0f, 1.0f, 1.0f, this.getArmorTexture(stack, (Entity)entityliving, this.slot, null), poses);
            }
        } else if (item != Items.field_190931_a) {
            ClientEngine.INSTANCE.renderEngine.getItemRenderer(stack.func_77973_b()).renderItemOnHead(stack, (LivingData<?>)entitydata, buffer, matrixStackIn, packedLightIn, partialTicks);
        }
        matrixStackIn.func_227865_b_();
    }

    private ClientModel getArmorModel(E entityliving, ArmorItem armorItem, ItemStack stack) {
        ClientModel model;
        EquipmentSlotType slot;
        ResourceLocation registryName = armorItem.getRegistryName();
        if (ARMOR_MODEL_MAP.containsKey(registryName)) {
            return ARMOR_MODEL_MAP.get(registryName);
        }
        BipedModel originalModel = new BipedModel(0.5f);
        LivingRenderer entityRenderer = (LivingRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a(entityliving);
        for (LayerRenderer layer : entityRenderer.field_177097_h) {
            if (!(layer instanceof BipedArmorLayer)) continue;
            originalModel = ((BipedArmorLayer)layer).func_241736_a_(this.slot);
        }
        BipedModel customModel = armorItem.getArmorModel(entityliving, stack, this.slot, originalModel);
        EquipmentSlotType equipmentSlotType = slot = armorItem.func_185083_B_() != null ? armorItem.func_185083_B_() : this.slot;
        if (customModel == null) {
            ArmorCapability cap = (ArmorCapability)stack.getCapability(ModCapabilities.CAPABILITY_ITEM, null).orElse(null);
            ClientModel model2 = cap == null ? ArmorCapability.getBipedArmorModel(slot) : cap.getArmorModel(slot);
            ARMOR_MODEL_MAP.put(registryName, model2);
            return model2;
        }
        if (ARMOR_MODEL_MAP_BY_MODEL.containsKey(customModel)) {
            model = ARMOR_MODEL_MAP_BY_MODEL.get(customModel);
        } else {
            EpicFightMod.LOGGER.info("baked new model for " + registryName);
            model = CustomModelBakery.bakeBipedCustomArmorModel(customModel, armorItem, slot);
        }
        ARMOR_MODEL_MAP.put(registryName, model);
        return model;
    }

    private ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = (ResourceLocation)BipedArmorLayer.field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            BipedArmorLayer.field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

