/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.collada;

import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.collada.xml.XmlNode;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;

public class JointDataExtractor {
    private static final VisibleMatrix4f CORRECTION = new VisibleMatrix4f().rotate((float)Math.toRadians(-90.0), new Vec3f(1.0f, 0.0f, 0.0f));
    private int jointNumber = 1;
    private XmlNode skeleton;
    private Map<String, Integer> rawJointMap;
    private Map<Integer, Joint> joints = new HashMap<Integer, Joint>();

    public JointDataExtractor(XmlNode skeleton, Map<String, Integer> rawJointMap) {
        this.skeleton = skeleton;
        this.rawJointMap = rawJointMap;
    }

    public Joint extractSkeletonData() {
        XmlNode rootNode = this.skeleton.getChild("node");
        Joint root = this.getRootJoint(rootNode);
        this.bindJointData(root, rootNode.getChildren("node"));
        return root;
    }

    private void bindJointData(Joint root, List<XmlNode> nodes) {
        for (XmlNode node : nodes) {
            Joint joint = this.getJoint(node);
            root.addSubJoint(joint);
            this.bindJointData(joint, node.getChildren("node"));
        }
    }

    private Joint getRootJoint(XmlNode node) {
        String name = node.getAttribute("sid");
        String[] matrixData = node.getChild("matrix").getData().split(" ");
        VisibleMatrix4f jointTransform = this.convertStringToMatrix(matrixData);
        VisibleMatrix4f.mul(CORRECTION, jointTransform, jointTransform);
        Joint joint = new Joint(name, this.rawJointMap.get(name), jointTransform);
        this.joints.put(joint.getId(), joint);
        return joint;
    }

    private Joint getJoint(XmlNode node) {
        ++this.jointNumber;
        String name = node.getAttribute("sid");
        String[] matrixData = node.getChild("matrix").getData().split(" ");
        VisibleMatrix4f jointTransform = this.convertStringToMatrix(matrixData);
        Joint joint = new Joint(name, this.rawJointMap.get(name), jointTransform);
        this.joints.put(joint.getId(), joint);
        return joint;
    }

    private VisibleMatrix4f convertStringToMatrix(String[] data) {
        float[] mat4 = new float[16];
        for (int i = 0; i < 16; ++i) {
            mat4[i] = Float.parseFloat(data[i]);
        }
        FloatBuffer floatbuffer = FloatBuffer.allocate(16);
        floatbuffer.put(mat4);
        floatbuffer.flip();
        VisibleMatrix4f transform = new VisibleMatrix4f();
        transform.load(floatbuffer);
        transform.transpose();
        return transform;
    }

    public Map<Integer, Joint> getJointTable() {
        return this.joints;
    }

    public int getJointNumber() {
        return this.jointNumber;
    }
}

