/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.collada;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.client.model.Mesh;
import maninhouse.epicfight.utils.math.Vec2f;
import maninhouse.epicfight.utils.math.Vec3f;
import org.apache.commons.lang3.ArrayUtils;

public class VertexData {
    private Vec3f position;
    private Vec3f normal;
    private Vec2f textureCoordinate;
    private Vec3f effectiveJointIDs;
    private Vec3f effectiveJointWeights;
    private int effectiveJointNumber;

    public VertexData() {
        this.position = null;
        this.normal = null;
        this.textureCoordinate = null;
    }

    public VertexData(VertexData vertex) {
        this.position = vertex.position;
        this.effectiveJointIDs = vertex.effectiveJointIDs;
        this.effectiveJointWeights = vertex.effectiveJointWeights;
        this.effectiveJointNumber = vertex.effectiveJointNumber;
    }

    public VertexData setPosition(Vec3f position) {
        this.position = position;
        return this;
    }

    public VertexData setNormal(Vec3f vector) {
        this.normal = vector;
        return this;
    }

    public VertexData setTextureCoordinate(Vec2f vector) {
        this.textureCoordinate = vector;
        return this;
    }

    public VertexData setEffectiveJointIDs(Vec3f effectiveJointIDs) {
        this.effectiveJointIDs = effectiveJointIDs;
        return this;
    }

    public VertexData setEffectiveJointWeights(Vec3f effectiveJointWeights) {
        this.effectiveJointWeights = effectiveJointWeights;
        return this;
    }

    public VertexData setEffectiveJointNumber(int count) {
        this.effectiveJointNumber = count;
        return this;
    }

    public State compareTextureCoordinateAndNormal(Vec3f normal, Vec2f textureCoord) {
        if (this.textureCoordinate == null) {
            return State.EMPTY;
        }
        if (this.textureCoordinate.equals(textureCoord) && this.normal.equals(normal)) {
            return State.EQUAL;
        }
        return State.DIFFERENT;
    }

    public static Mesh loadVertexInformation(List<VertexData> vertices, int[] indices, boolean animated) {
        ArrayList positions = Lists.newArrayList();
        ArrayList normals = Lists.newArrayList();
        ArrayList texCoords = Lists.newArrayList();
        ArrayList jointIndices = Lists.newArrayList();
        ArrayList jointWeights = Lists.newArrayList();
        ArrayList effectJointCount = Lists.newArrayList();
        for (int i = 0; i < vertices.size(); ++i) {
            VertexData vertex = vertices.get(i);
            Vec3f position = vertex.position;
            Vec3f normal = vertex.normal;
            Vec2f texCoord = vertex.textureCoordinate;
            positions.add(Float.valueOf(position.x));
            positions.add(Float.valueOf(position.y));
            positions.add(Float.valueOf(position.z));
            normals.add(Float.valueOf(normal.x));
            normals.add(Float.valueOf(normal.y));
            normals.add(Float.valueOf(normal.z));
            texCoords.add(Float.valueOf(texCoord.x));
            texCoords.add(Float.valueOf(texCoord.y));
            if (!animated) continue;
            Vec3f effectIDs = vertex.effectiveJointIDs;
            Vec3f weights = vertex.effectiveJointWeights;
            int count = Math.min(vertex.effectiveJointNumber, 3);
            effectJointCount.add(count);
            block6: for (int j = 0; j < count; ++j) {
                switch (j) {
                    case 0: {
                        jointIndices.add((int)effectIDs.x);
                        jointWeights.add(Float.valueOf(weights.x));
                        continue block6;
                    }
                    case 1: {
                        jointIndices.add((int)effectIDs.y);
                        jointWeights.add(Float.valueOf(weights.y));
                        continue block6;
                    }
                    case 2: {
                        jointIndices.add((int)effectIDs.z);
                        jointWeights.add(Float.valueOf(weights.z));
                        continue block6;
                    }
                }
            }
        }
        float[] positionList = ArrayUtils.toPrimitive((Float[])positions.toArray(new Float[0]));
        float[] normalList = ArrayUtils.toPrimitive((Float[])normals.toArray(new Float[0]));
        float[] texCoordList = ArrayUtils.toPrimitive((Float[])texCoords.toArray(new Float[0]));
        int[] jointIndexList = ArrayUtils.toPrimitive((Integer[])jointIndices.toArray(new Integer[0]));
        float[] jointWeightList = ArrayUtils.toPrimitive((Float[])jointWeights.toArray(new Float[0]));
        int[] jointCountList = ArrayUtils.toPrimitive((Integer[])effectJointCount.toArray(new Integer[0]));
        return new Mesh(positionList, normalList, texCoordList, jointIndexList, jointWeightList, indices, jointCountList, positionList.length / 3, indices.length);
    }

    public static enum State {
        EMPTY,
        EQUAL,
        DIFFERENT;

    }
}

