/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.config;

import com.electronwill.nightconfig.core.AbstractCommentedConfig;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.BowCapability;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.CrossbowCapability;
import maninhouse.epicfight.capabilities.item.KnuckleCapability;
import maninhouse.epicfight.capabilities.item.ModWeaponCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.item.Item;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ForgeConfigSpec;

public class CapabilityConfig {
    public static final List<CustomWeaponConfig> CUSTOM_WEAPON_LISTS = Lists.newArrayList();
    public static final List<CustomArmorConfig> CUSTOM_ARMOR_LISTS = Lists.newArrayList();

    public static void init(ForgeConfigSpec.Builder config, Map<String, Object> dynamicConfigMap) {
        String armorKey;
        String weaponKey = "custom_weaponry";
        if (dynamicConfigMap.get(weaponKey) != null) {
            LinkedList entries = new LinkedList(((AbstractCommentedConfig)dynamicConfigMap.get(weaponKey)).valueMap().entrySet());
            Collections.sort(entries, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
            for (Map.Entry entry : entries) {
                ForgeConfigSpec.ConfigValue hitAtOnceTwohand;
                ForgeConfigSpec.ConfigValue armorIgnoranceTwohand;
                ForgeConfigSpec.ConfigValue impactTwohand;
                ForgeConfigSpec.ConfigValue hitAtOnceOnehand;
                ForgeConfigSpec.ConfigValue armorIgnoranceOnehand;
                ForgeConfigSpec.ConfigValue impactOnehand;
                ForgeConfigSpec.ConfigValue configValue = config.define(String.format("%s.%s.registry_name", weaponKey, entry.getKey()), (Object)"broken_item");
                ForgeConfigSpec.EnumValue weaponType = config.defineEnum(String.format("%s.%s.weapon_type", weaponKey, entry.getKey()), (Enum)WeaponType.SWORD);
                boolean containOnehand = ((AbstractCommentedConfig)entry.getValue()).contains("onehand");
                boolean containTwohand = ((AbstractCommentedConfig)entry.getValue()).contains("twohand");
                if (!containOnehand && !containTwohand) {
                    impactOnehand = config.define(String.format("%s.%s.impact", weaponKey, entry.getKey()), (Object)0.5);
                    armorIgnoranceOnehand = config.define(String.format("%s.%s.armor_ignorance", weaponKey, entry.getKey()), (Object)0.0);
                    hitAtOnceOnehand = config.define(String.format("%s.%s.hit_at_once", weaponKey, entry.getKey()), (Object)1);
                    impactTwohand = config.define(String.format("%s.%s.impact", weaponKey, entry.getKey()), (Object)0.5);
                    armorIgnoranceTwohand = config.define(String.format("%s.%s.armor_ignorance", weaponKey, entry.getKey()), (Object)0.0);
                    hitAtOnceTwohand = config.define(String.format("%s.%s.hit_at_once", weaponKey, entry.getKey()), (Object)1);
                } else {
                    impactOnehand = config.define(String.format("%s.%s.onehand.impact", weaponKey, entry.getKey()), (Object)0.5);
                    armorIgnoranceOnehand = config.define(String.format("%s.%s.onehand.armor_ignorance", weaponKey, entry.getKey()), (Object)0.0);
                    hitAtOnceOnehand = config.define(String.format("%s.%s.onehand.hit_at_once", weaponKey, entry.getKey()), (Object)1);
                    impactTwohand = config.define(String.format("%s.%s.twohand.impact", weaponKey, entry.getKey()), (Object)0.5);
                    armorIgnoranceTwohand = config.define(String.format("%s.%s.twohand.armor_ignorance", weaponKey, entry.getKey()), (Object)0.0);
                    hitAtOnceTwohand = config.define(String.format("%s.%s.twohand.hit_at_once", weaponKey, entry.getKey()), (Object)1);
                }
                if (((String)entry.getKey()).equals("sample")) continue;
                CUSTOM_WEAPON_LISTS.add(new CustomWeaponConfig((ForgeConfigSpec.ConfigValue<String>)configValue, (ForgeConfigSpec.ConfigValue<WeaponType>)weaponType, (ForgeConfigSpec.ConfigValue<Double>)impactOnehand, (ForgeConfigSpec.ConfigValue<Double>)armorIgnoranceOnehand, (ForgeConfigSpec.ConfigValue<Integer>)hitAtOnceOnehand, (ForgeConfigSpec.ConfigValue<Double>)impactTwohand, (ForgeConfigSpec.ConfigValue<Double>)armorIgnoranceTwohand, (ForgeConfigSpec.ConfigValue<Integer>)hitAtOnceTwohand));
            }
        }
        if (dynamicConfigMap.get(armorKey = "custom_armor") != null) {
            LinkedList entries = new LinkedList(((AbstractCommentedConfig)dynamicConfigMap.get(armorKey)).valueMap().entrySet());
            Collections.sort(entries, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
            for (Map.Entry entry : entries) {
                ForgeConfigSpec.ConfigValue registryName = config.define(String.format("%s.%s.registry_name", armorKey, entry.getKey()), (Object)"broken_item");
                ForgeConfigSpec.ConfigValue weight = config.define(String.format("%s.%s.weight", armorKey, entry.getKey()), (Object)0.0);
                ForgeConfigSpec.ConfigValue stunArmor = config.define(String.format("%s.%s.stun_armor", armorKey, entry.getKey()), (Object)0.0);
                if (((String)entry.getKey()).equals("sample")) continue;
                CUSTOM_ARMOR_LISTS.add(new CustomArmorConfig((ForgeConfigSpec.ConfigValue<String>)registryName, (ForgeConfigSpec.ConfigValue<Double>)stunArmor, (ForgeConfigSpec.ConfigValue<Double>)weight));
            }
        }
    }

    public static enum WeaponType {
        AXE(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.AXE, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.tools, CapabilityItem.HeldOption.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.GUILLOTINE_AXE);
            return cap;
        }),
        FIST(item -> new KnuckleCapability()),
        HOE(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.HOE, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.tools, CapabilityItem.HeldOption.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.TOOL_AUTO_1, Animations.TOOL_AUTO_2, Animations.TOOL_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            return cap;
        }),
        PICKAXE(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.PICKAXE, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.tools, CapabilityItem.HeldOption.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            return cap;
        }),
        SHOVEL(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.SHOVEL, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLUNT_HIT, Colliders.tools, CapabilityItem.HeldOption.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            return cap;
        }),
        SWORD(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.SWORD, playerdata -> {
                CapabilityItem itemCap = playerdata.getHeldItemCapability(Hand.OFF_HAND);
                if (itemCap != null && itemCap.getWeaponCategory() == CapabilityItem.WeaponCategory.SWORD) {
                    return CapabilityItem.WieldStyle.TWO_HAND;
                }
                return CapabilityItem.WieldStyle.ONE_HAND;
            }, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.sword, CapabilityItem.HeldOption.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.SWORD_AUTO_1, Animations.SWORD_AUTO_2, Animations.SWORD_AUTO_3, Animations.SWORD_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.SWORD_DUAL_AUTO_1, Animations.SWORD_DUAL_AUTO_2, Animations.SWORD_DUAL_AUTO_3, Animations.SWORD_DUAL_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.SWEEPING_EDGE);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.DANCING_EDGE);
            return cap;
        }),
        SPEAR(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.SPEAR, playerdata -> playerdata.getOriginalEntity().func_184592_cb().func_190926_b() ? CapabilityItem.WieldStyle.TWO_HAND : CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.spear, CapabilityItem.HeldOption.MAINHAND_ONLY);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.SPEAR_ONEHAND_AUTO, Animations.SPEAR_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.SPEAR_TWOHAND_AUTO_1, Animations.SPEAR_TWOHAND_AUTO_2, Animations.SPEAR_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SPEAR_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.HEARTPIERCER);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.SLAUGHTER_STANCE);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.ONE_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_HELDING_WEAPON);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_HELDING_WEAPON);
            return cap;
        }),
        GREATSWORD(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.GREATSWORD, playerdata -> CapabilityItem.WieldStyle.TWO_HAND, null, Sounds.WHOOSH_BIG, Sounds.BLADE_HIT, Colliders.greatSword, CapabilityItem.HeldOption.TWO_HANDED);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.GREATSWORD_AUTO_1, Animations.GREATSWORD_AUTO_2, Animations.GREATSWORD_DASH);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.GIANT_WHIRLWIND);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.IDLE, Animations.BIPED_IDLE_MASSIVE_HELD);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.WALKING, Animations.BIPED_WALK_MASSIVE_HELD);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.JUMPING, Animations.BIPED_JUMP_MASSIVE_HELD);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
            return cap;
        }),
        TACHI(item -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.TACHI, playerdata -> CapabilityItem.WieldStyle.TWO_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.katana, CapabilityItem.HeldOption.TWO_HANDED);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.LONGSWORD_AUTO_1, Animations.LONGSWORD_AUTO_2, Animations.LONGSWORD_AUTO_3, Animations.TACHI_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.LETHAL_SLICING);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.IDLE, Animations.BIPED_IDLE_TACHI);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.WALKING, Animations.BIPED_WALK_TACHI);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_TACHI);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_TACHI);
            cap.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.JUMPING, Animations.BIPED_JUMP_TACHI);
            return cap;
        }),
        KNUCKLE(item -> new KnuckleCapability()),
        LONGSWORD(item -> {
            ModWeaponCapability weaponCapability = new ModWeaponCapability(CapabilityItem.WeaponCategory.LONGSWORD, playerdata -> {
                if (playerdata instanceof PlayerData && ((PlayerData)playerdata).getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).getRemainDuration() > 0) {
                    return CapabilityItem.WieldStyle.LIECHTENHAUER;
                }
                return CapabilityItem.WieldStyle.TWO_HAND;
            }, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.longsword, CapabilityItem.HeldOption.TWO_HANDED);
            weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.LONGSWORD_AUTO_1, Animations.LONGSWORD_AUTO_2, Animations.LONGSWORD_AUTO_3, Animations.LONGSWORD_DASH);
            weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.LIECHTENHAUER, Animations.LONGSWORD_AUTO_1, Animations.LONGSWORD_AUTO_2, Animations.LONGSWORD_AUTO_3, Animations.LONGSWORD_DASH);
            weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.LIECHTENAUER);
            weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.LIECHTENHAUER, Skills.LIECHTENAUER);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.IDLE, Animations.BIPED_IDLE_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.WALKING, Animations.BIPED_WALK_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.JUMPING, Animations.BIPED_JUMP_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.IDLE, Animations.BIPED_IDLE_LONGSWORD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.WALKING, Animations.BIPED_WALK_LONGSWORD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
            weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.JUMPING, Animations.BIPED_JUMP_LONGSWORD);
            return weaponCapability;
        }),
        DAGGER(item -> {
            ModWeaponCapability weaponCapability = new ModWeaponCapability(CapabilityItem.WeaponCategory.DAGGER, playerdata -> {
                CapabilityItem heldItem = playerdata.getHeldItemCapability(Hand.OFF_HAND);
                if (heldItem != null && heldItem.getWeaponCategory() == CapabilityItem.WeaponCategory.DAGGER) {
                    return CapabilityItem.WieldStyle.TWO_HAND;
                }
                return CapabilityItem.WieldStyle.ONE_HAND;
            }, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.dagger, CapabilityItem.HeldOption.GENERAL);
            weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.DAGGER_AUTO_1, Animations.DAGGER_AUTO_2, Animations.DAGGER_AUTO_3, Animations.SWORD_DASH);
            weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.DAGGER_DUAL_AUTO_1, Animations.DAGGER_DUAL_AUTO_2, Animations.DAGGER_DUAL_AUTO_3, Animations.DAGGER_DUAL_AUTO_4, Animations.DAGGER_DUAL_DASH);
            weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.EVISCERATE);
            weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.BLADE_RUSH);
            return weaponCapability;
        }),
        BOW(item -> {
            BowCapability cap = new BowCapability((Item)item);
            return cap;
        }),
        CROSSBOW(item -> {
            CrossbowCapability cap = new CrossbowCapability((Item)item);
            return cap;
        });

        Function<Item, CapabilityItem> capabilitySupplier;

        private WeaponType(Function<Item, CapabilityItem> capabilitySupplier) {
            this.capabilitySupplier = capabilitySupplier;
        }

        public CapabilityItem get(Item item) {
            return this.capabilitySupplier.apply(item);
        }
    }

    public static class CustomWeaponConfig {
        private ForgeConfigSpec.ConfigValue<String> registryName;
        private ForgeConfigSpec.ConfigValue<WeaponType> weaponType;
        private ForgeConfigSpec.ConfigValue<Double> impactOnehand;
        private ForgeConfigSpec.ConfigValue<Double> armorIgnoranceOnehand;
        private ForgeConfigSpec.ConfigValue<Integer> hitAtOnceOnehand;
        private ForgeConfigSpec.ConfigValue<Double> impactTwohand;
        private ForgeConfigSpec.ConfigValue<Double> armorIgnoranceTwohand;
        private ForgeConfigSpec.ConfigValue<Integer> hitAtOnceTwohand;

        public CustomWeaponConfig(ForgeConfigSpec.ConfigValue<String> registryName, ForgeConfigSpec.ConfigValue<WeaponType> weaponType, ForgeConfigSpec.ConfigValue<Double> impactOnehand, ForgeConfigSpec.ConfigValue<Double> armorIgnoranceOnehand, ForgeConfigSpec.ConfigValue<Integer> hitAtOnceOnehand, ForgeConfigSpec.ConfigValue<Double> impactTwohand, ForgeConfigSpec.ConfigValue<Double> armorIgnoranceTwohand, ForgeConfigSpec.ConfigValue<Integer> hitAtOnceTwohand) {
            this.registryName = registryName;
            this.weaponType = weaponType;
            this.impactOnehand = impactOnehand;
            this.armorIgnoranceOnehand = armorIgnoranceOnehand;
            this.hitAtOnceOnehand = hitAtOnceOnehand;
            this.impactTwohand = impactTwohand;
            this.armorIgnoranceTwohand = armorIgnoranceTwohand;
            this.hitAtOnceTwohand = hitAtOnceTwohand;
        }

        public String getRegistryName() {
            return (String)this.registryName.get();
        }

        public WeaponType getWeaponType() {
            return (WeaponType)((Object)this.weaponType.get());
        }

        public Double getImpactOnehand() {
            return (Double)this.impactOnehand.get();
        }

        public Double getArmorIgnoranceOnehand() {
            return (Double)this.armorIgnoranceOnehand.get();
        }

        public Integer getMaxStrikesOnehand() {
            return (Integer)this.hitAtOnceOnehand.get();
        }

        public Double getImpactTwohand() {
            return (Double)this.impactTwohand.get();
        }

        public Double getArmorIgnoranceTwohand() {
            return (Double)this.armorIgnoranceTwohand.get();
        }

        public Integer getMaxStrikesTwohand() {
            return (Integer)this.hitAtOnceTwohand.get();
        }
    }

    public static class CustomArmorConfig {
        private ForgeConfigSpec.ConfigValue<String> registryName;
        private ForgeConfigSpec.ConfigValue<Double> stunArmor;
        private ForgeConfigSpec.ConfigValue<Double> weight;

        public CustomArmorConfig(ForgeConfigSpec.ConfigValue<String> registryName, ForgeConfigSpec.ConfigValue<Double> stunArmor, ForgeConfigSpec.ConfigValue<Double> weight) {
            this.registryName = registryName;
            this.stunArmor = stunArmor;
            this.weight = weight;
        }

        public String getRegistryName() {
            return (String)this.registryName.get();
        }

        public Double getStunArmor() {
            return (Double)this.stunArmor.get();
        }

        public Double getWeight() {
            return (Double)this.weight.get();
        }
    }
}

