/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import maninhouse.epicfight.config.CapabilityConfig;
import maninhouse.epicfight.config.IngameConfig;
import maninhouse.epicfight.main.EpicFightMod;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigManager {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final IngameConfig INGAME_CONFIG;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
        EpicFightMod.LOGGER.info("Load Configuration File");
    }

    static {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(FMLPaths.CONFIGDIR.get().resolve("epicfight.toml").toString())).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        ForgeConfigSpec.Builder client = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        INGAME_CONFIG = new IngameConfig(client);
        String weaponKey = "custom_weaponry";
        if (file.valueMap().get(weaponKey) == null) {
            server.define(String.format("%s.%s.registry_name", weaponKey, "sample"), (Object)"epicfight:registryname");
            server.defineEnum(String.format("%s.%s.weapon_type", weaponKey, "sample"), (Enum)CapabilityConfig.WeaponType.SWORD);
            server.define(String.format("%s.%s.impact", weaponKey, "sample"), (Object)0.5);
            server.define(String.format("%s.%s.armor_ignorance", weaponKey, "sample"), (Object)0.0);
            server.define(String.format("%s.%s.hit_at_once", weaponKey, "sample"), (Object)1);
        }
        String armorKey = "custom_armor";
        if (file.valueMap().get(armorKey) == null) {
            server.define(String.format("%s.%s.registry_name", armorKey, "sample"), (Object)"epicfight:registryname");
            server.define(String.format("%s.%s.stunArmor", armorKey, "sample"), (Object)0.0);
            server.define(String.format("%s.%s.weight", armorKey, "sample"), (Object)0.0);
        }
        CapabilityConfig.init(server, file.valueMap());
        CLIENT_CONFIG = client.build();
        COMMON_CONFIG = server.build();
    }
}

