/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai.attribute;

import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"epicfight");
    public static final RegistryObject<Attribute> MAX_STUN_ARMOR = ATTRIBUTES.register("stun_armor", () -> new RangedAttribute("attribute.name.epicfight.stun_armor", 0.0, 0.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> WEIGHT = ATTRIBUTES.register("weight", () -> new RangedAttribute("attribute.name.epicfight.weight", 0.0, 0.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> MAX_STRIKES = ATTRIBUTES.register("max_strikes", () -> new RangedAttribute("attribute.name.epicfight.max_strikes", 1.0, 1.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> ARMOR_NEGATION = ATTRIBUTES.register("armor_negation", () -> new RangedAttribute("attribute.name.epicfight.armor_negation", 0.0, 0.0, 100.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> IMPACT = ATTRIBUTES.register("impact", () -> new RangedAttribute("attribute.name.epicfight.impact", 0.0, 0.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> OFFHAND_ATTACK_DAMAGE = ATTRIBUTES.register("offhand_attack_damage", () -> new RangedAttribute("offhand attack damage", 1.0, 0.0, 2048.0));
    public static final RegistryObject<Attribute> OFFHAND_ATTACK_SPEED = ATTRIBUTES.register("offhand_attack_speed", () -> new RangedAttribute("offhand attack speed", 4.0, 0.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> OFFHAND_MAX_STRIKES = ATTRIBUTES.register("offhand_max_strikes", () -> new RangedAttribute("attribute.name.epicfight.offhand_max_strikes", 1.0, 1.0, 1024.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> OFFHAND_ARMOR_NEGATION = ATTRIBUTES.register("offhand_armor_negation", () -> new RangedAttribute("attribute.name.epicfight.offhand_armor_negation", 0.0, 0.0, 100.0).func_233753_a_(true));
    public static final RegistryObject<Attribute> OFFHAND_IMPACT = ATTRIBUTES.register("offhand_impact", () -> new RangedAttribute("attribute.name.epicfight.offhand_impact", 0.0, 0.0, 1024.0).func_233753_a_(true));
    public static final UUID ARMOR_NEGATION_MODIFIER = UUID.fromString("b0a7436e-5734-11eb-ae93-0242ac130002");
    public static final UUID MAX_STRIKE_MODIFIER = UUID.fromString("b0a745b2-5734-11eb-ae93-0242ac130002");
    public static final UUID IMPACT_MODIFIER = UUID.fromString("b0a746ac-5734-11eb-ae93-0242ac130002");
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public static void modifyAttributeMap(EntityAttributeModificationEvent event) {
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200794_h, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200797_k, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200806_t, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200757_aw, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_220350_aJ, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_220352_aU, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200748_an, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200755_au, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200758_ax, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_200759_ay, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_233588_G_, event);
        ModAttributes.general((EntityType<? extends LivingEntity>)EntityType.field_233590_aW_, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_204724_o, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200803_q, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200763_C, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_233591_ai_, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_242287_aj, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200741_ag, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200750_ap, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200722_aA, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200725_aD, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_200727_aF, event);
        ModAttributes.withStunArmor((EntityType<? extends LivingEntity>)EntityType.field_233592_ba_, event);
        ModAttributes.player((EntityType<? extends PlayerEntity>)EntityType.field_200729_aH, event);
    }

    private static void general(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
        event.add(entityType, (Attribute)WEIGHT.get());
        event.add(entityType, (Attribute)ARMOR_NEGATION.get());
        event.add(entityType, (Attribute)IMPACT.get());
        event.add(entityType, (Attribute)MAX_STRIKES.get());
    }

    private static void withStunArmor(EntityType<? extends LivingEntity> entityType, EntityAttributeModificationEvent event) {
        ModAttributes.general(entityType, event);
        event.add(entityType, (Attribute)MAX_STUN_ARMOR.get());
    }

    private static void player(EntityType<? extends PlayerEntity> entityType, EntityAttributeModificationEvent event) {
        ModAttributes.withStunArmor(entityType, event);
        event.add(entityType, (Attribute)OFFHAND_ATTACK_DAMAGE.get());
        event.add(entityType, (Attribute)OFFHAND_ATTACK_SPEED.get());
        event.add(entityType, (Attribute)OFFHAND_MAX_STRIKES.get());
        event.add(entityType, (Attribute)OFFHAND_ARMOR_NEGATION.get());
        event.add(entityType, (Attribute)OFFHAND_IMPACT.get());
    }

    public static AttributeModifier getArmorNegationModifier(double value) {
        return new AttributeModifier(ARMOR_NEGATION_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getMaxStrikesModifier(int value) {
        return new AttributeModifier(MAX_STRIKE_MODIFIER, "epicfight:weapon_modifier", (double)value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getImpactModifier(double value) {
        return new AttributeModifier(IMPACT_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getAttackDamageModifier(double value) {
        return new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier getAttackSpeedModifier(double value) {
        return new AttributeModifier(ATTACK_SPEED_MODIFIER, "epicfight:weapon_modifier", value, AttributeModifier.Operation.ADDITION);
    }
}

