/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ShootableItem;
import net.minecraft.world.server.ServerWorld;

public class AttackWithPatternTask
extends Task<MobEntity> {
    private final List<AttackAnimation> patternList;
    private final MobData<?> entitydata;
    private final double minRangeSquare;
    private final double maxRangeSquare;
    private int patternCounter;

    public AttackWithPatternTask(MobData<?> entitydata, List<AttackAnimation> patternList, double minRange, double maxRange) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.patternList = patternList;
        this.entitydata = entitydata;
        this.minRangeSquare = minRange * minRange;
        this.maxRangeSquare = maxRange * maxRange;
        this.patternCounter = 0;
    }

    protected boolean shouldExecute(ServerWorld worldIn, MobEntity owner) {
        LivingEntity target = this.getAttackTarget(owner);
        return !this.heldRangeWeapon(owner) && BrainUtil.func_233876_c_((LivingEntity)owner, (LivingEntity)target) && this.isTargetInRanged(owner, target) && !this.entitydata.isInaction();
    }

    private boolean isTargetInRanged(MobEntity owner, LivingEntity target) {
        double distance = owner.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        return this.minRangeSquare <= distance && distance <= this.maxRangeSquare;
    }

    protected void startExecuting(ServerWorld worldIn, MobEntity entityIn, long gameTimeIn) {
        LivingEntity livingentity = this.getAttackTarget(entityIn);
        BrainUtil.func_220625_c((LivingEntity)entityIn, (LivingEntity)livingentity);
        this.entitydata.playAnimationSynchronize(this.patternList.get(this.patternCounter++), 0.0f);
        this.patternCounter %= this.patternList.size();
    }

    private boolean heldRangeWeapon(MobEntity mob) {
        return mob.func_233634_a_(item -> item instanceof ShootableItem && mob.func_230280_a_((ShootableItem)item));
    }

    private LivingEntity getAttackTarget(MobEntity mob) {
        return (LivingEntity)mob.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
    }
}

