/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.world.server.ServerWorld;

public class CrossBowAttackTask<E extends MobEntity>
extends Task<E> {
    private int cooldown;
    private Status status = Status.UNCHARGED;

    public CrossBowAttackTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), 1200);
    }

    protected boolean shouldExecute(ServerWorld worldIn, E owner) {
        LivingEntity livingentity = CrossBowAttackTask.getAttackTarget(owner);
        return owner.func_233631_a_(Items.field_222114_py) && BrainUtil.func_233876_c_(owner, (LivingEntity)livingentity) && BrainUtil.func_233869_a_(owner, (LivingEntity)livingentity, (int)0);
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        return entityIn.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_) && this.shouldExecute(worldIn, entityIn);
    }

    protected void updateTask(ServerWorld worldIn, E owner, long gameTime) {
        LivingEntity livingentity = CrossBowAttackTask.getAttackTarget(owner);
        this.setLookTargetMemory((MobEntity)owner, livingentity);
        this.func_233888_a_(owner, livingentity);
    }

    protected void resetTask(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        if (entityIn.func_184587_cr()) {
            entityIn.func_184602_cy();
        }
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(-1, entityIn.func_145782_y(), 0.0f, false), entityIn);
        if (entityIn.func_233631_a_(Items.field_222114_py)) {
            ((ICrossbowUser)entityIn).func_213671_a(false);
            CrossbowItem.func_220011_a((ItemStack)entityIn.func_184607_cu(), (boolean)false);
        }
    }

    private void func_233888_a_(E taskOwner, LivingEntity target) {
        if (this.status == Status.UNCHARGED) {
            taskOwner.func_184598_c(ProjectileHelper.func_221274_a(taskOwner, (Item)Items.field_222114_py));
            this.status = Status.CHARGING;
            ((ICrossbowUser)taskOwner).func_213671_a(true);
        } else if (this.status == Status.CHARGING) {
            ItemStack itemstack;
            int i;
            if (!taskOwner.func_184587_cr()) {
                this.status = Status.UNCHARGED;
            }
            if ((i = taskOwner.func_184612_cw()) == 7) {
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(Animations.BIPED_CROSSBOW_RELOAD.getId(), taskOwner.func_145782_y(), 0.0f, true), taskOwner);
            }
            if (i >= CrossbowItem.func_220026_e((ItemStack)(itemstack = taskOwner.func_184607_cu()))) {
                taskOwner.func_184597_cx();
                this.status = Status.CHARGED;
                this.cooldown = 20 + taskOwner.func_70681_au().nextInt(20);
                ((ICrossbowUser)taskOwner).func_213671_a(false);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(Animations.BIPED_CROSSBOW_AIM.getId(), taskOwner.func_145782_y(), 0.0f, true), taskOwner);
            }
        } else if (this.status == Status.CHARGED) {
            --this.cooldown;
            if (this.cooldown == 0) {
                this.status = Status.READY_TO_ATTACK;
            }
        } else if (this.status == Status.READY_TO_ATTACK) {
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(Animations.BIPED_CROSSBOW_SHOT.getId(), taskOwner.func_145782_y(), 0.0f, true), taskOwner);
            ((IRangedAttackMob)taskOwner).func_82196_d(target, 1.0f);
            ItemStack itemstack1 = taskOwner.func_184586_b(ProjectileHelper.func_221274_a(taskOwner, (Item)Items.field_222114_py));
            CrossbowItem.func_220011_a((ItemStack)itemstack1, (boolean)false);
            this.status = Status.UNCHARGED;
        }
    }

    private void setLookTargetMemory(MobEntity p_233889_1_, LivingEntity p_233889_2_) {
        p_233889_1_.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)p_233889_2_, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity p_233887_0_) {
        return (LivingEntity)p_233887_0_.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
    }

    static enum Status {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

