/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.entity.eventlistener;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.UUID;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.entity.eventlistener.EventTrigger;
import maninhouse.epicfight.entity.eventlistener.PlayerActionEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerAttackEndEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerBasicAttackEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerDealtDamageEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerHitEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerMovementInputEvent;

public class EntityEventListener {
    private Multimap<EventType<? extends PlayerEvent<?>>, EventTrigger<? extends PlayerEvent<?>>> map;
    private boolean side;

    public EntityEventListener(PlayerData<?> player) {
        this.side = player.isRemote();
        this.map = HashMultimap.create();
    }

    public <T extends PlayerEvent<?>> void addEventListener(EventType<T> eventType, UUID uuid, Function<T, Boolean> function) {
        this.map.put(eventType, EventTrigger.makeEvent(eventType, uuid, function));
    }

    public <T extends PlayerEvent<?>> void removeListener(EventType<T> event, UUID functionUUID) {
        Collection c = this.map.get(event);
        EventTrigger wantToRemove = null;
        for (EventTrigger e : c) {
            if (!e.is(functionUUID)) continue;
            wantToRemove = e;
            break;
        }
        if (wantToRemove != null) {
            c.remove(wantToRemove);
        }
    }

    public <T extends PlayerEvent<?>> boolean activateEvents(EventType<T> eventType, T event) {
        boolean cancel = false;
        for (EventTrigger eventTrigger : this.map.get(eventType)) {
            if (eventType.side != this.side) continue;
            cancel |= eventTrigger.trigger(event);
        }
        return cancel;
    }

    public static class EventType<T extends PlayerEvent<?>> {
        public static final EventType<PlayerActionEvent> ACTION_EVENT = new EventType(false);
        public static final EventType<PlayerDealtDamageEvent> DEALT_DAMAGE_EVENT = new EventType(false);
        public static final EventType<PlayerAttackEndEvent> ATTACK_ANIMATION_END_EVENT = new EventType(false);
        public static final EventType<PlayerHitEvent> HIT_EVENT = new EventType(false);
        public static final EventType<PlayerBasicAttackEvent> BASIC_ATTACK_EVENT = new EventType(true);
        public static final EventType<PlayerMovementInputEvent> MOVEMENT_INPUT_EVENT = new EventType(true);
        boolean side;

        EventType(boolean isRemote) {
            this.side = isRemote;
        }
    }
}

