/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.events;

import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCGameruleChange;
import maninhouse.epicfight.world.ModGamerules;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="epicfight")
public class PlayerEvents {
    @SubscribeEvent
    public static void arrowLooseEvent(ArrowLooseEvent event) {
    }

    @SubscribeEvent
    public static void itemUseStartEvent(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            PlayerData playerdata = (PlayerData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
            CapabilityItem itemCap = playerdata.getHeldItemCapability(Hand.MAIN_HAND);
            if (playerdata.isInaction()) {
                event.setCanceled(true);
            } else if (event.getItem() == player.func_184592_cb() && itemCap != null && itemCap.isTwoHanded()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        PlayerData playerdata = (PlayerData)event.getOriginal().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (playerdata.getOriginalEntity() != null) {
            playerdata.discard();
        }
    }

    @SubscribeEvent
    public static void changeDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        ServerPlayerData playerData = (ServerPlayerData)player.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        playerData.modifiLivingMotions(playerData.getHeldItemCapability(Hand.MAIN_HAND));
    }

    @SubscribeEvent
    public static void itemUseStopEvent(LivingEntityUseItemEvent.Stop event) {
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof ClientPlayerEntity) {
            ClientEngine.INSTANCE.renderEngine.zoomOut(0);
        }
    }

    @SubscribeEvent
    public static void itemUseTickEvent(LivingEntityUseItemEvent.Tick event) {
        PlayerData playerdata;
        if (event.getEntity() instanceof PlayerEntity && event.getItem().func_77973_b() instanceof BowItem && (playerdata = (PlayerData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)).isInaction()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attackEntityEvent(AttackEntityEvent event) {
        boolean isLivingTarget;
        boolean bl = isLivingTarget = event.getTarget() instanceof LivingEntity ? ((LivingEntity)event.getTarget()).func_190631_cK() : false;
        if (!event.getEntity().field_70170_p.func_82736_K().func_223586_b(ModGamerules.DO_VANILLA_ATTACK) && isLivingTarget) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ModNetworkManager.sendToPlayer(new STCGameruleChange(STCGameruleChange.Gamerules.HAS_FALL_ANIMATION, event.getEntity().field_70170_p.func_82736_K().func_223586_b(ModGamerules.HAS_FALL_ANIMATION)), (ServerPlayerEntity)event.getPlayer());
        ModNetworkManager.sendToPlayer(new STCGameruleChange(STCGameruleChange.Gamerules.SPEED_PENALTY_PERCENT, event.getEntity().field_70170_p.func_82736_K().func_223592_c(ModGamerules.SPEED_PENALTY_PERCENT)), (ServerPlayerEntity)event.getPlayer());
    }
}

