/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.gamedata;

import java.util.HashMap;
import java.util.Map;
import maninhouse.epicfight.animation.property.Property;
import maninhouse.epicfight.animation.types.AAAnimation;
import maninhouse.epicfight.animation.types.AADashAnimation;
import maninhouse.epicfight.animation.types.ActionAnimation;
import maninhouse.epicfight.animation.types.AimingAnimation;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.animation.types.DodgingAnimation;
import maninhouse.epicfight.animation.types.HitAnimation;
import maninhouse.epicfight.animation.types.ImmovableAnimation;
import maninhouse.epicfight.animation.types.MirrorAnimation;
import maninhouse.epicfight.animation.types.MountAttackAnimation;
import maninhouse.epicfight.animation.types.MovementAnimation;
import maninhouse.epicfight.animation.types.ReboundAnimation;
import maninhouse.epicfight.animation.types.SpecialAttackAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.animation.types.VariableHitAnimation;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.utils.game.AttackResult;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.ValueCorrector;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;

public final class Animations {
    public static final Map<Integer, StaticAnimation> animationTable = new HashMap<Integer, StaticAnimation>();
    public static StaticAnimation DUMMY_ANIMATION = new StaticAnimation();
    public static StaticAnimation BIPED_IDLE;
    public static StaticAnimation BIPED_WALK;
    public static StaticAnimation BIPED_RUN;
    public static StaticAnimation BIPED_SNEAK;
    public static StaticAnimation BIPED_SWIM;
    public static StaticAnimation BIPED_FLOAT;
    public static StaticAnimation BIPED_KNEEL;
    public static StaticAnimation BIPED_FALL;
    public static StaticAnimation BIPED_FLYING;
    public static StaticAnimation BIPED_MOUNT;
    public static StaticAnimation BIPED_JUMP;
    public static StaticAnimation BIPED_DEATH;
    public static StaticAnimation BIPED_DIG;
    public static StaticAnimation BIPED_RUN_HELDING_WEAPON;
    public static StaticAnimation BIPED_IDLE_MASSIVE_HELD;
    public static StaticAnimation BIPED_WALK_MASSIVE_HELD;
    public static StaticAnimation BIPED_RUN_MASSIVE_HELD;
    public static StaticAnimation BIPED_JUMP_MASSIVE_HELD;
    public static StaticAnimation BIPED_KNEEL_MASSIVE_HELD;
    public static StaticAnimation BIPED_SNEAK_MASSIVE_HELD;
    public static StaticAnimation BIPED_IDLE_SHEATHING;
    public static StaticAnimation BIPED_WALK_SHEATHING;
    public static StaticAnimation BIPED_RUN_SHEATHING;
    public static StaticAnimation BIPED_JUMP_SHEATHING;
    public static StaticAnimation BIPED_KNEEL_SHEATHING;
    public static StaticAnimation BIPED_SNEAK_SHEATHING;
    public static StaticAnimation BIPED_IDLE_UNSHEATHING;
    public static StaticAnimation BIPED_WALK_UNSHEATHING;
    public static StaticAnimation BIPED_RUN_UNSHEATHING;
    public static StaticAnimation BIPED_IDLE_LONGSWORD;
    public static StaticAnimation BIPED_WALK_LONGSWORD;
    public static StaticAnimation BIPED_JUMP_LONGSWORD;
    public static StaticAnimation BIPED_KATANA_SCRAP;
    public static StaticAnimation BIPED_IDLE_CROSSBOW;
    public static StaticAnimation BIPED_WALK_CROSSBOW;
    public static StaticAnimation BIPED_CLIMBING;
    public static StaticAnimation BIPED_SLEEPING;
    public static StaticAnimation BIPED_BOW_AIM;
    public static StaticAnimation BIPED_BOW_REBOUND;
    public static StaticAnimation BIPED_CROSSBOW_AIM;
    public static StaticAnimation BIPED_CROSSBOW_SHOT;
    public static StaticAnimation BIPED_CROSSBOW_RELOAD;
    public static StaticAnimation BIPED_JAVELIN_AIM;
    public static StaticAnimation BIPED_JAVELIN_REBOUND;
    public static StaticAnimation BIPED_HIT_SHORT;
    public static StaticAnimation BIPED_HIT_LONG;
    public static StaticAnimation BIPED_HIT_ON_MOUNT;
    public static StaticAnimation BIPED_LAND_DAMAGE;
    public static StaticAnimation BIPED_BLOCK;
    public static StaticAnimation BIPED_ROLL_FORWARD;
    public static StaticAnimation BIPED_ROLL_BACKWARD;
    public static StaticAnimation BIPED_ARMED_MOB_ATTACK1;
    public static StaticAnimation BIPED_ARMED_MOB_ATTACK2;
    public static StaticAnimation BIPED_MOB_THROW;
    public static StaticAnimation BIPED_IDLE_TACHI;
    public static StaticAnimation BIPED_WALK_TACHI;
    public static StaticAnimation BIPED_RUN_TACHI;
    public static StaticAnimation BIPED_SNEAK_TACHI;
    public static StaticAnimation BIPED_JUMP_TACHI;
    public static StaticAnimation CREEPER_IDLE;
    public static StaticAnimation CREEPER_WALK;
    public static StaticAnimation CREEPER_HIT_LONG;
    public static StaticAnimation CREEPER_HIT_SHORT;
    public static StaticAnimation CREEPER_DEATH;
    public static StaticAnimation ENDERMAN_IDLE;
    public static StaticAnimation ENDERMAN_WALK;
    public static StaticAnimation ENDERMAN_DEATH;
    public static StaticAnimation ENDERMAN_HIT_SHORT;
    public static StaticAnimation ENDERMAN_HIT_LONG;
    public static StaticAnimation ENDERMAN_HIT_RAGE;
    public static StaticAnimation ENDERMAN_ATTACK1;
    public static StaticAnimation ENDERMAN_ATTACK2;
    public static StaticAnimation ENDERMAN_RUSH;
    public static StaticAnimation ENDERMAN_RAGE_IDLE;
    public static StaticAnimation ENDERMAN_RAGE_WALK;
    public static StaticAnimation ENDERMAN_GRASP;
    public static StaticAnimation ENDERMAN_TP_KICK1;
    public static StaticAnimation ENDERMAN_TP_KICK2;
    public static StaticAnimation ENDERMAN_KNEE;
    public static StaticAnimation ENDERMAN_KICK1;
    public static StaticAnimation ENDERMAN_KICK2;
    public static StaticAnimation ENDERMAN_KICK_COMBO;
    public static StaticAnimation ENDERMAN_TP_EMERGENCE;
    public static StaticAnimation SPIDER_IDLE;
    public static StaticAnimation SPIDER_CRAWL;
    public static StaticAnimation SPIDER_DEATH;
    public static StaticAnimation SPIDER_HIT;
    public static StaticAnimation SPIDER_ATTACK;
    public static StaticAnimation SPIDER_JUMP_ATTACK;
    public static StaticAnimation GOLEM_IDLE;
    public static StaticAnimation GOLEM_WALK;
    public static StaticAnimation GOLEM_DEATH;
    public static StaticAnimation GOLEM_ATTACK1;
    public static StaticAnimation GOLEM_ATTACK2;
    public static StaticAnimation GOLEM_ATTACK3;
    public static StaticAnimation GOLEM_ATTACK4;
    public static StaticAnimation HOGLIN_IDLE;
    public static StaticAnimation HOGLIN_WALK;
    public static StaticAnimation HOGLIN_DEATH;
    public static StaticAnimation HOGLIN_ATTACK;
    public static StaticAnimation ILLAGER_IDLE;
    public static StaticAnimation ILLAGER_WALK;
    public static StaticAnimation VINDICATOR_IDLE_AGGRESSIVE;
    public static StaticAnimation VINDICATOR_CHASE;
    public static StaticAnimation VINDICATOR_SWING_AXE1;
    public static StaticAnimation VINDICATOR_SWING_AXE2;
    public static StaticAnimation VINDICATOR_SWING_AXE3;
    public static StaticAnimation EVOKER_CAST_SPELL;
    public static StaticAnimation PIGLIN_IDLE;
    public static StaticAnimation PIGLIN_WALK;
    public static StaticAnimation PIGLIN_IDLE_ZOMBIE;
    public static StaticAnimation PIGLIN_WALK_ZOMBIE;
    public static StaticAnimation PIGLIN_CHASE_ZOMBIE;
    public static StaticAnimation PIGLIN_CELEBRATE1;
    public static StaticAnimation PIGLIN_CELEBRATE2;
    public static StaticAnimation PIGLIN_CELEBRATE3;
    public static StaticAnimation PIGLIN_ADMIRE;
    public static StaticAnimation PIGLIN_DEATH;
    public static StaticAnimation RAVAGER_IDLE;
    public static StaticAnimation RAVAGER_WALK;
    public static StaticAnimation RAVAGER_DEATH;
    public static StaticAnimation RAVAGER_STUN;
    public static StaticAnimation RAVAGER_ATTACK1;
    public static StaticAnimation RAVAGER_ATTACK2;
    public static StaticAnimation RAVAGER_ATTACK3;
    public static StaticAnimation VEX_IDLE;
    public static StaticAnimation VEX_FLIPPING;
    public static StaticAnimation VEX_DEATH;
    public static StaticAnimation VEX_HIT;
    public static StaticAnimation VEX_CHARGING;
    public static StaticAnimation WITCH_DRINKING;
    public static StaticAnimation WITHER_SKELETON_IDLE;
    public static StaticAnimation WITHER_SKELETON_WALK;
    public static StaticAnimation WITHER_SKELETON_CHASE;
    public static StaticAnimation WITHER_SKELETON_ATTACK1;
    public static StaticAnimation WITHER_SKELETON_ATTACK2;
    public static StaticAnimation WITHER_SKELETON_ATTACK3;
    public static StaticAnimation ZOMBIE_IDLE;
    public static StaticAnimation ZOMBIE_WALK;
    public static StaticAnimation ZOMBIE_CHASE;
    public static StaticAnimation ZOMBIE_ATTACK1;
    public static StaticAnimation ZOMBIE_ATTACK2;
    public static StaticAnimation ZOMBIE_ATTACK3;
    public static StaticAnimation AXE_AUTO1;
    public static StaticAnimation AXE_AUTO2;
    public static StaticAnimation AXE_DASH;
    public static StaticAnimation FIST_AUTO_1;
    public static StaticAnimation FIST_AUTO_2;
    public static StaticAnimation FIST_AUTO_3;
    public static StaticAnimation FIST_DASH;
    public static StaticAnimation SPEAR_ONEHAND_AUTO;
    public static StaticAnimation SPEAR_TWOHAND_AUTO_1;
    public static StaticAnimation SPEAR_TWOHAND_AUTO_2;
    public static StaticAnimation SPEAR_DASH;
    public static StaticAnimation SPEAR_MOUNT_ATTACK;
    public static StaticAnimation SWORD_AUTO_1;
    public static StaticAnimation SWORD_AUTO_2;
    public static StaticAnimation SWORD_AUTO_3;
    public static StaticAnimation SWORD_DASH;
    public static StaticAnimation SWORD_DUAL_AUTO_1;
    public static StaticAnimation SWORD_DUAL_AUTO_2;
    public static StaticAnimation SWORD_DUAL_AUTO_3;
    public static StaticAnimation SWORD_DUAL_DASH;
    public static StaticAnimation LONGSWORD_AUTO_1;
    public static StaticAnimation LONGSWORD_AUTO_2;
    public static StaticAnimation LONGSWORD_AUTO_3;
    public static StaticAnimation LONGSWORD_DASH;
    public static StaticAnimation LONGSWORD_GUARD;
    public static StaticAnimation TACHI_DASH;
    public static StaticAnimation TOOL_AUTO_1;
    public static StaticAnimation TOOL_AUTO_2;
    public static StaticAnimation TOOL_DASH;
    public static StaticAnimation KATANA_AUTO_1;
    public static StaticAnimation KATANA_AUTO_2;
    public static StaticAnimation KATANA_AUTO_3;
    public static StaticAnimation KATANA_SHEATHING_AUTO;
    public static StaticAnimation KATANA_SHEATHING_DASH;
    public static StaticAnimation SWORD_MOUNT_ATTACK;
    public static StaticAnimation GREATSWORD_AUTO_1;
    public static StaticAnimation GREATSWORD_AUTO_2;
    public static StaticAnimation GREATSWORD_DASH;
    public static StaticAnimation DAGGER_AUTO_1;
    public static StaticAnimation DAGGER_AUTO_2;
    public static StaticAnimation DAGGER_AUTO_3;
    public static StaticAnimation DAGGER_DUAL_AUTO_1;
    public static StaticAnimation DAGGER_DUAL_AUTO_2;
    public static StaticAnimation DAGGER_DUAL_AUTO_3;
    public static StaticAnimation DAGGER_DUAL_AUTO_4;
    public static StaticAnimation DAGGER_DUAL_DASH;
    public static StaticAnimation GUILLOTINE_AXE;
    public static StaticAnimation SWEEPING_EDGE;
    public static StaticAnimation DANCING_EDGE;
    public static StaticAnimation SPEAR_THRUST;
    public static StaticAnimation SPEAR_SLASH;
    public static StaticAnimation GIANT_WHIRLWIND;
    public static StaticAnimation FATAL_DRAW;
    public static StaticAnimation FATAL_DRAW_DASH;
    public static StaticAnimation LETHAL_SLICING;
    public static StaticAnimation LETHAL_SLICING_ONCE;
    public static StaticAnimation LETHAL_SLICING_TWICE;
    public static StaticAnimation RELENTLESS_COMBO;
    public static StaticAnimation EVISCERATE_FIRST;
    public static StaticAnimation EVISCERATE_SECOND;
    public static StaticAnimation BLADE_RUSH_FIRST;
    public static StaticAnimation BLADE_RUSH_SECOND;
    public static StaticAnimation BLADE_RUSH_THIRD;
    public static StaticAnimation BLADE_RUSH_FINISHER;
    public static int BASIC_ATTACK_MIN;
    public static int BASIC_ATTACK_MAX;

    public static StaticAnimation findAnimationDataById(int id) {
        return animationTable.get(id);
    }

    public static void registerAnimations(Dist dist) {
        Models modeldata = dist == Dist.CLIENT ? ClientModels.LOGICAL_CLIENT : Models.LOGICAL_SERVER;
        Armature biped = ((Model)modeldata.ENTITY_BIPED).getArmature();
        Armature crepper = ((Model)modeldata.ENTITY_CREEPER).getArmature();
        Armature enderman = ((Model)modeldata.ENTITY_ENDERMAN).getArmature();
        Armature spider = ((Model)modeldata.ENTITY_SPIDER).getArmature();
        Armature hoglin = ((Model)modeldata.ENTITY_HOGLIN).getArmature();
        Armature iron_golem = ((Model)modeldata.ENTITY_GOLEM).getArmature();
        Armature piglin = ((Model)modeldata.ENTITY_PIGLIN).getArmature();
        Armature ravager = ((Model)modeldata.ENTITY_RAVAGER).getArmature();
        Armature vex = ((Model)modeldata.ENTITY_VEX).getArmature();
        BIPED_IDLE = new StaticAnimation(0, true, "biped/living/idle.dae").bindOnlyClient(biped, dist);
        BIPED_WALK = new MovementAnimation(1, true, "biped/living/walk.dae").bindOnlyClient(biped, dist);
        BIPED_FLYING = new StaticAnimation(2, true, "biped/living/fly.dae").bindOnlyClient(biped, dist);
        BIPED_IDLE_CROSSBOW = new StaticAnimation(3, true, "biped/living/idle_crossbow.dae").bindOnlyClient(biped, dist);
        BIPED_WALK_CROSSBOW = new MovementAnimation(4, true, "biped/living/walk_crossbow.dae").bindOnlyClient(biped, dist);
        BIPED_RUN = new MovementAnimation(5, true, "biped/living/run.dae").bindOnlyClient(biped, dist);
        BIPED_SNEAK = new MovementAnimation(7, true, "biped/living/sneak.dae").bindOnlyClient(biped, dist);
        BIPED_SWIM = new MovementAnimation(8, true, "biped/living/swim.dae").bindOnlyClient(biped, dist);
        BIPED_FLOAT = new StaticAnimation(9, true, "biped/living/float.dae").bindOnlyClient(biped, dist);
        BIPED_KNEEL = new StaticAnimation(10, true, "biped/living/kneel.dae").bindOnlyClient(biped, dist);
        BIPED_FALL = new StaticAnimation(11, false, "biped/living/fall.dae").bindOnlyClient(biped, dist);
        BIPED_MOUNT = new StaticAnimation(12, true, "biped/living/mount.dae").bindOnlyClient(biped, dist);
        BIPED_DIG = new StaticAnimation(15, 0.11f, true, "biped/living/dig.dae").bindOnlyClient(biped, dist);
        BIPED_BOW_AIM = new AimingAnimation(16, 0.16f, false, "biped/combat/bow_aim_mid.dae", "biped/combat/bow_aim_up.dae", "biped/combat/bow_aim_down.dae").bindOnlyClient(biped, dist);
        BIPED_BOW_REBOUND = new ReboundAnimation(17, 0.04f, false, "biped/combat/bow_shot_mid.dae", "biped/combat/bow_shot_up.dae", "biped/combat/bow_shot_down.dae").bindOnlyClient(biped, dist);
        BIPED_CROSSBOW_AIM = new AimingAnimation(18, 0.16f, false, "biped/combat/crossbow_aim_mid.dae", "biped/combat/crossbow_aim_up.dae", "biped/combat/crossbow_aim_down.dae").bindOnlyClient(biped, dist);
        BIPED_CROSSBOW_SHOT = new ReboundAnimation(19, 0.16f, false, "biped/combat/crossbow_shot_mid.dae", "biped/combat/crossbow_shot_up.dae", "biped/combat/crossbow_shot_down.dae").bindOnlyClient(biped, dist);
        BIPED_CROSSBOW_RELOAD = new StaticAnimation(20, 0.16f, false, "biped/combat/crossbow_reload.dae").bindOnlyClient(biped, dist);
        BIPED_JUMP = new StaticAnimation(21, 0.083f, false, "biped/living/jump.dae").bindOnlyClient(biped, dist);
        BIPED_RUN_HELDING_WEAPON = new MovementAnimation(22, true, "biped/living/run_helding_weapon.dae").bindOnlyClient(biped, dist);
        BIPED_BLOCK = new MirrorAnimation(23, 0.25f, true, "biped/combat/block.dae", "biped/combat/block_mirror.dae").bindOnlyClient(biped, dist);
        BIPED_IDLE_MASSIVE_HELD = new StaticAnimation(24, true, "biped/living/idle_massiveheld.dae").bindOnlyClient(biped, dist);
        BIPED_WALK_MASSIVE_HELD = new MovementAnimation(25, true, "biped/living/walk_massiveheld.dae").bindOnlyClient(biped, dist);
        BIPED_RUN_MASSIVE_HELD = new MovementAnimation(26, true, "biped/living/run_massiveheld.dae").bindOnlyClient(biped, dist);
        BIPED_IDLE_SHEATHING = new StaticAnimation(27, true, "biped/living/idle_sheath.dae").bindOnlyClient(biped, dist);
        BIPED_WALK_SHEATHING = new MovementAnimation(28, true, "biped/living/walk_sheath.dae").bindOnlyClient(biped, dist);
        BIPED_RUN_SHEATHING = new MovementAnimation(29, true, "biped/living/run_sheath.dae").bindOnlyClient(biped, dist);
        BIPED_IDLE_UNSHEATHING = new StaticAnimation(30, true, "biped/living/idle_unsheath.dae").bindOnlyClient(biped, dist);
        BIPED_WALK_UNSHEATHING = new MovementAnimation(31, true, "biped/living/walk_unsheath.dae").bindOnlyClient(biped, dist);
        BIPED_RUN_UNSHEATHING = new MovementAnimation(32, true, "biped/living/run_unsheath.dae").bindOnlyClient(biped, dist);
        BIPED_KATANA_SCRAP = new StaticAnimation(33, false, "biped/living/katana_scrap.dae").registerSound(0.15f, Sounds.SWORD_IN, true).bindOnlyClient(biped, dist);
        BIPED_JUMP_SHEATHING = new StaticAnimation(34, 0.083f, false, "biped/living/jump_sheath.dae").bindOnlyClient(biped, dist);
        BIPED_JUMP_MASSIVE_HELD = new StaticAnimation(35, 0.083f, false, "biped/living/jump_massiveheld.dae").bindOnlyClient(biped, dist);
        BIPED_KNEEL_SHEATHING = new StaticAnimation(36, true, "biped/living/kneel_sheath.dae").bindOnlyClient(biped, dist);
        BIPED_KNEEL_MASSIVE_HELD = new StaticAnimation(37, true, "biped/living/kneel_massiveheld.dae").bindOnlyClient(biped, dist);
        BIPED_SNEAK_SHEATHING = new MovementAnimation(38, true, "biped/living/sneak_sheath.dae").bindOnlyClient(biped, dist);
        BIPED_SNEAK_MASSIVE_HELD = new MovementAnimation(39, true, "biped/living/sneak_massiveheld.dae").bindOnlyClient(biped, dist);
        BIPED_IDLE_TACHI = new StaticAnimation(40, true, "biped/living/idle_tachi.dae").bindOnlyClient(biped, dist);
        BIPED_WALK_TACHI = new MovementAnimation(41, true, "biped/living/walk_tachi.dae").bindOnlyClient(biped, dist);
        BIPED_RUN_TACHI = new MovementAnimation(42, true, "biped/living/run_tachi.dae").bindOnlyClient(biped, dist);
        BIPED_SNEAK_TACHI = new MovementAnimation(43, true, "biped/living/sneak_tachi.dae").bindOnlyClient(biped, dist);
        BIPED_JUMP_TACHI = new StaticAnimation(44, 0.083f, false, "biped/living/jump_tachi.dae").bindOnlyClient(biped, dist);
        BIPED_IDLE_LONGSWORD = new StaticAnimation(45, true, "biped/living/idle_longsword.dae").bindOnlyClient(biped, dist);
        BIPED_WALK_LONGSWORD = new MovementAnimation(46, true, "biped/living/walk_longsword.dae").bindOnlyClient(biped, dist);
        BIPED_JUMP_LONGSWORD = new StaticAnimation(47, 0.083f, false, "biped/living/jump_longsword.dae").bindOnlyClient(biped, dist);
        BIPED_CLIMBING = new StaticAnimation(48, 0.16f, true, "biped/living/climb.dae").bindOnlyClient(biped, dist);
        BIPED_SLEEPING = new StaticAnimation(49, 0.16f, true, "biped/living/sleep.dae").bindOnlyClient(biped, dist);
        BIPED_JAVELIN_AIM = new AimingAnimation(98, 0.16f, false, "biped/combat/javelin_aim_mid.dae", "biped/combat/javelin_aim_up.dae", "biped/combat/javelin_aim_down.dae").bindOnlyClient(biped, dist);
        BIPED_JAVELIN_REBOUND = new ReboundAnimation(99, 0.08f, false, "biped/combat/javelin_throw_mid.dae", "biped/combat/javelin_throw_up.dae", "biped/combat/javelin_throw_down.dae").bindOnlyClient(biped, dist);
        ZOMBIE_IDLE = new StaticAnimation(100, true, "zombie/idle.dae").bindOnlyClient(biped, dist);
        ZOMBIE_WALK = new MovementAnimation(102, true, "zombie/walk.dae").bindOnlyClient(biped, dist);
        ZOMBIE_CHASE = new MovementAnimation(103, true, "zombie/chase.dae").bindOnlyClient(biped, dist);
        CREEPER_IDLE = new StaticAnimation(300, 0.16f, true, "creeper/idle.dae").bindOnlyClient(crepper, dist);
        CREEPER_WALK = new MovementAnimation(301, 0.16f, true, "creeper/walk.dae").bindOnlyClient(crepper, dist);
        ENDERMAN_IDLE = new StaticAnimation(400, true, "enderman/idle.dae").bindOnlyClient(enderman, dist);
        ENDERMAN_WALK = new MovementAnimation(401, true, "enderman/walk.dae").bindOnlyClient(enderman, dist);
        ENDERMAN_RUSH = new StaticAnimation(403, false, "enderman/rush.dae").bindOnlyClient(enderman, dist);
        ENDERMAN_RAGE_IDLE = new StaticAnimation(404, true, "enderman/rage_idle.dae").bindOnlyClient(enderman, dist);
        ENDERMAN_RAGE_WALK = new MovementAnimation(405, true, "enderman/rage_walk.dae").bindOnlyClient(enderman, dist);
        WITHER_SKELETON_IDLE = new StaticAnimation(500, true, "skeleton/wither_skeleton_idle.dae").bindOnlyClient(biped, dist);
        WITHER_SKELETON_WALK = new MovementAnimation(501, true, "skeleton/wither_skeleton_walk.dae").bindOnlyClient(biped, dist);
        WITHER_SKELETON_CHASE = new MovementAnimation(502, 0.36f, true, "skeleton/wither_skeleton_chase.dae").bindOnlyClient(biped, dist);
        SPIDER_IDLE = new StaticAnimation(600, true, "spider/idle.dae").bindOnlyClient(spider, dist);
        SPIDER_CRAWL = new MovementAnimation(601, true, "spider/crawl.dae").bindOnlyClient(spider, dist);
        GOLEM_IDLE = new StaticAnimation(700, true, "iron_golem/idle.dae").bindOnlyClient(iron_golem, dist);
        GOLEM_WALK = new MovementAnimation(701, true, "iron_golem/walk.dae").bindOnlyClient(iron_golem, dist);
        HOGLIN_IDLE = new StaticAnimation(750, 0.16f, true, "hoglin/idle.dae").bindOnlyClient(hoglin, dist);
        HOGLIN_WALK = new MovementAnimation(751, 0.16f, true, "hoglin/walk.dae").bindOnlyClient(hoglin, dist);
        ILLAGER_IDLE = new StaticAnimation(800, 0.16f, true, "illager/idle.dae").bindOnlyClient(biped, dist);
        ILLAGER_WALK = new MovementAnimation(801, 0.16f, true, "illager/walk.dae").bindOnlyClient(biped, dist);
        VINDICATOR_IDLE_AGGRESSIVE = new StaticAnimation(802, true, "illager/idle_aggressive.dae").bindOnlyClient(biped, dist);
        VINDICATOR_CHASE = new MovementAnimation(803, true, "illager/chase.dae").bindOnlyClient(biped, dist);
        EVOKER_CAST_SPELL = new StaticAnimation(804, 0.16f, true, "illager/spellcast.dae").bindOnlyClient(biped, dist);
        RAVAGER_IDLE = new StaticAnimation(900, 0.16f, true, "ravager/idle.dae").bindOnlyClient(ravager, dist);
        RAVAGER_WALK = new StaticAnimation(901, 0.16f, true, "ravager/walk.dae").bindOnlyClient(ravager, dist);
        VEX_IDLE = new StaticAnimation(902, 0.16f, true, "vex/idle.dae").bindOnlyClient(vex, dist);
        VEX_FLIPPING = new StaticAnimation(903, 0.05f, true, "vex/flip.dae").bindOnlyClient(vex, dist);
        PIGLIN_IDLE = new StaticAnimation(1000, 0.16f, true, "piglin/idle.dae").bindOnlyClient(piglin, dist);
        PIGLIN_WALK = new StaticAnimation(1001, 0.16f, true, "piglin/walk.dae").bindOnlyClient(piglin, dist);
        PIGLIN_IDLE_ZOMBIE = new StaticAnimation(1002, 0.16f, true, "piglin/idle_zombie.dae").bindOnlyClient(piglin, dist);
        PIGLIN_WALK_ZOMBIE = new StaticAnimation(1003, 0.16f, true, "piglin/walk_zombie.dae").bindOnlyClient(piglin, dist);
        PIGLIN_CHASE_ZOMBIE = new StaticAnimation(1004, 0.16f, true, "piglin/chase_zombie.dae").bindOnlyClient(piglin, dist);
        PIGLIN_CELEBRATE1 = new StaticAnimation(1005, 0.16f, true, "piglin/celebrate1.dae").bindOnlyClient(piglin, dist);
        PIGLIN_CELEBRATE2 = new StaticAnimation(1006, 0.16f, true, "piglin/celebrate2.dae").bindOnlyClient(piglin, dist);
        PIGLIN_CELEBRATE3 = new StaticAnimation(1007, 0.16f, true, "piglin/celebrate3.dae").bindOnlyClient(piglin, dist);
        PIGLIN_ADMIRE = new StaticAnimation(1008, 0.16f, true, "piglin/admire.dae").bindOnlyClient(piglin, dist);
        BIPED_LAND_DAMAGE = new HitAnimation(1997, 0.08f, "biped/living/land_damage.dae").bindFull(biped);
        BIPED_ROLL_FORWARD = new DodgingAnimation(1998, 0.09f, false, "biped/combat/roll_forward.dae", 0.6f, 0.5f).bindFull(biped);
        BIPED_ROLL_BACKWARD = new DodgingAnimation(1999, 0.09f, false, "biped/combat/roll_backward.dae", 0.6f, 0.5f).bindFull(biped);
        BASIC_ATTACK_MIN = 2000;
        FIST_AUTO_1 = new AAAnimation(2001, 0.08f, 0.0f, 0.1f, 0.15f, Hand.OFF_HAND, null, "111313", "biped/combat/fist_auto1.dae").addProperty(Property.PhaseProperty.PARTICLE, Particles.HIT_BLUNT).bindFull(biped);
        FIST_AUTO_2 = new AAAnimation(2002, 0.08f, 0.0f, 0.1f, 0.15f, null, "111213", "biped/combat/fist_auto2.dae").addProperty(Property.PhaseProperty.PARTICLE, Particles.HIT_BLUNT).bindFull(biped);
        FIST_AUTO_3 = new AAAnimation(2003, 0.08f, 0.0f, 0.1f, 0.5f, Hand.OFF_HAND, null, "111313", "biped/combat/fist_auto3.dae").addProperty(Property.PhaseProperty.PARTICLE, Particles.HIT_BLUNT).bindFull(biped);
        FIST_DASH = new AADashAnimation(2004, 0.06f, 0.05f, 0.15f, 0.3f, 0.7f, null, "213", "biped/combat/fist_dash.dae").addProperty(Property.PhaseProperty.PARTICLE, Particles.HIT_BLUNT).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        SWORD_AUTO_1 = new AAAnimation(2005, 0.13f, 0.0f, 0.11f, 0.3f, null, "111213", "biped/combat/sword_auto1.dae").bindFull(biped);
        SWORD_AUTO_2 = new AAAnimation(2006, 0.13f, 0.0f, 0.11f, 0.3f, null, "111213", "biped/combat/sword_auto2.dae").bindFull(biped);
        SWORD_AUTO_3 = new AAAnimation(2007, 0.13f, 0.05f, 0.16f, 0.6f, null, "111213", "biped/combat/sword_auto3.dae").bindFull(biped);
        SWORD_DASH = new AADashAnimation(2008, 0.12f, 0.1f, 0.25f, 0.4f, 0.65f, null, "111213", "biped/combat/sword_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        GREATSWORD_AUTO_1 = new AAAnimation(2009, 0.41f, 0.4f, 0.6f, 0.94f, null, "111213", "biped/combat/greatsword_auto1.dae").bindFull(biped);
        GREATSWORD_AUTO_2 = new AAAnimation(2010, 0.2f, 0.55f, 0.75f, 1.05f, null, "111213", "biped/combat/greatsword_auto2.dae").bindFull(biped);
        GREATSWORD_DASH = new AADashAnimation(2011, 0.11f, 0.4f, 0.65f, 0.8f, 1.2f, null, "111213", "biped/combat/greatsword_dash.dae", false).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        SPEAR_ONEHAND_AUTO = new AAAnimation(2012, 0.16f, 0.1f, 0.2f, 0.45f, null, "111213", "biped/combat/spear_onehand_auto.dae").bindFull(biped);
        SPEAR_TWOHAND_AUTO_1 = new AAAnimation(2013, 0.25f, 0.05f, 0.15f, 0.45f, null, "111213", "biped/combat/spear_twohand_auto1.dae").bindFull(biped);
        SPEAR_TWOHAND_AUTO_2 = new AAAnimation(2014, 0.25f, 0.05f, 0.15f, 0.45f, null, "111213", "biped/combat/spear_twohand_auto2.dae").bindFull(biped);
        SPEAR_DASH = new AADashAnimation(2015, 0.16f, 0.05f, 0.2f, 0.3f, 0.7f, null, "111213", "biped/combat/spear_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        TOOL_AUTO_1 = new AAAnimation(2016, 0.13f, 0.05f, 0.15f, 0.3f, null, "111213", "biped/combat/sword_auto3.dae").bindFull(biped);
        TOOL_AUTO_2 = new AAAnimation(2017, 0.13f, 0.05f, 0.15f, 0.6f, null, "111213", "biped/combat/sword_auto4.dae").bindFull(biped);
        TOOL_DASH = new AADashAnimation(2018, 0.16f, 0.08f, 0.15f, 0.25f, 0.58f, null, "111213", "biped/combat/tool_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getAdder(1.0f)).bindFull(biped);
        AXE_DASH = new AADashAnimation(2019, 0.25f, 0.08f, 0.4f, 0.46f, 0.9f, null, "111213", "biped/combat/axe_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        SWORD_DUAL_AUTO_1 = new AAAnimation(2020, 0.16f, 0.0f, 0.11f, 0.2f, null, "111213", "biped/combat/sword_dual_auto1.dae").bindFull(biped);
        SWORD_DUAL_AUTO_2 = new AAAnimation(2021, 0.13f, 0.0f, 0.1f, 0.1f, Hand.OFF_HAND, null, "111313", "biped/combat/sword_dual_auto2.dae").bindFull(biped);
        SWORD_DUAL_AUTO_3 = new AAAnimation(2022, 0.18f, 0.0f, 0.25f, 0.35f, 0.64f, Colliders.dualSwordDash, "", "biped/combat/sword_dual_auto3.dae").bindFull(biped);
        SWORD_DUAL_DASH = new AADashAnimation(2023, 0.16f, 0.05f, 0.05f, 0.3f, 0.75f, Colliders.dualSwordDash, "", "biped/combat/sword_dual_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        KATANA_AUTO_1 = new AAAnimation(2024, 0.06f, 0.05f, 0.15f, 0.2f, null, "111213", "biped/combat/katana_auto1.dae").bindFull(biped);
        KATANA_AUTO_2 = new AAAnimation(2025, 0.16f, 0.0f, 0.1f, 0.2f, null, "111213", "biped/combat/katana_auto2.dae").bindFull(biped);
        KATANA_AUTO_3 = new AAAnimation(2026, 0.06f, 0.1f, 0.25f, 0.59f, null, "111213", "biped/combat/katana_auto3.dae").bindFull(biped);
        KATANA_SHEATHING_AUTO = new AAAnimation(2027, 0.06f, 0.0f, 0.06f, 0.65f, Colliders.fatal_draw, "", "biped/combat/katana_reinforce_auto.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(30.0f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(1.5f)).addProperty(Property.PhaseProperty.SWING_SOUND, Sounds.WHOOSH_SHARP).bindFull(biped);
        KATANA_SHEATHING_DASH = new AAAnimation(2028, 0.06f, 0.05f, 0.11f, 0.65f, null, "111213", "biped/combat/katana_reinforce_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(30.0f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(1.5f)).addProperty(Property.PhaseProperty.SWING_SOUND, Sounds.WHOOSH_SHARP).bindFull(biped);
        AXE_AUTO1 = new AAAnimation(2029, 0.16f, 0.25f, 0.35f, 0.7f, null, "111213", "biped/combat/axe_auto1.dae").bindFull(biped);
        AXE_AUTO2 = new AAAnimation(2030, 0.16f, 0.25f, 0.35f, 0.85f, null, "111213", "biped/combat/axe_auto2.dae").bindFull(biped);
        LONGSWORD_AUTO_1 = new AAAnimation(2031, 0.1f, 0.2f, 0.3f, 0.45f, null, "111213", "biped/combat/longsword_auto1.dae").bindFull(biped);
        LONGSWORD_AUTO_2 = new AAAnimation(2032, 0.15f, 0.1f, 0.21f, 0.45f, null, "111213", "biped/combat/longsword_auto2.dae").bindFull(biped);
        LONGSWORD_AUTO_3 = new AAAnimation(2033, 0.15f, 0.05f, 0.16f, 0.8f, null, "111213", "biped/combat/longsword_auto3.dae").bindFull(biped);
        LONGSWORD_DASH = new AADashAnimation(2034, 0.15f, 0.1f, 0.3f, 0.5f, 0.7f, null, "111213", "biped/combat/longsword_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        TACHI_DASH = new AADashAnimation(2035, 0.15f, 0.1f, 0.2f, 0.45f, 0.7f, null, "111213", "biped/combat/tachi_dash.dae", false).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        DAGGER_AUTO_1 = new AAAnimation(2036, 0.08f, 0.05f, 0.15f, 0.3f, null, "111213", "biped/combat/dagger_auto1.dae").bindFull(biped);
        DAGGER_AUTO_2 = new AAAnimation(2037, 0.08f, 0.0f, 0.1f, 0.2f, null, "111213", "biped/combat/dagger_auto2.dae").bindFull(biped);
        DAGGER_AUTO_3 = new AAAnimation(2038, 0.08f, 0.15f, 0.26f, 0.5f, null, "111213", "biped/combat/dagger_auto3.dae").bindFull(biped);
        DAGGER_DUAL_AUTO_1 = new AAAnimation(2039, 0.08f, 0.05f, 0.16f, 0.25f, null, "111213", "biped/combat/dagger_dual_auto1.dae").bindFull(biped);
        DAGGER_DUAL_AUTO_2 = new AAAnimation(2040, 0.08f, 0.0f, 0.11f, 0.16f, Hand.OFF_HAND, null, "111313", "biped/combat/dagger_dual_auto2.dae").bindFull(biped);
        DAGGER_DUAL_AUTO_3 = new AAAnimation(2041, 0.08f, 0.0f, 0.11f, 0.2f, null, "111213", "biped/combat/dagger_dual_auto3.dae").bindFull(biped);
        DAGGER_DUAL_AUTO_4 = new AAAnimation(2042, 0.13f, 0.1f, 0.21f, 0.4f, Colliders.dualDaggerDash, "", "biped/combat/dagger_dual_auto4.dae").bindFull(biped);
        DAGGER_DUAL_DASH = new AADashAnimation(2043, 0.1f, 0.1f, 0.25f, 0.3f, 0.65f, Colliders.dualDaggerDash, "", "biped/combat/dagger_dual_dash.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        BASIC_ATTACK_MAX = 2044;
        SWORD_MOUNT_ATTACK = new MountAttackAnimation(2099, 0.16f, 0.1f, 0.2f, 0.25f, 0.7f, null, "111213", "biped/combat/sword_mount_attack.dae").bindFull(biped);
        SPEAR_MOUNT_ATTACK = new MountAttackAnimation(2245, 0.16f, 0.38f, 0.38f, 0.45f, 0.8f, null, "111213", "biped/combat/spear_mount_attack.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        BIPED_ARMED_MOB_ATTACK1 = new AttackAnimation(2900, 0.08f, 0.45f, 0.55f, 0.65f, 0.95f, false, null, "111213", "biped/combat/armed_mob_attack1.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        BIPED_ARMED_MOB_ATTACK2 = new AttackAnimation(2901, 0.08f, 0.45f, 0.55f, 0.65f, 0.95f, false, null, "111213", "biped/combat/armed_mob_attack2.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        BIPED_MOB_THROW = new AttackAnimation(2902, 0.11f, 1.0f, 0.0f, 0.0f, 0.0f, false, null, "", "biped/combat/javelin_throw_mid.dae").bindFull(biped);
        LONGSWORD_GUARD = new HitAnimation(2999, 0.05f, "biped/combat/longsword_guard.dae").bindFull(biped);
        BIPED_HIT_SHORT = new VariableHitAnimation(3000, 0.05f, "biped/combat/hit_short.dae").bindFull(biped);
        BIPED_HIT_LONG = new HitAnimation(3001, 0.08f, "biped/combat/hit_long.dae").bindFull(biped);
        BIPED_HIT_ON_MOUNT = new HitAnimation(3002, 0.08f, "biped/combat/hit_on_mount.dae").bindFull(biped);
        BIPED_DEATH = new HitAnimation(3003, 0.16f, "biped/living/death.dae").bindFull(biped);
        CREEPER_HIT_SHORT = new VariableHitAnimation(3400, 0.05f, "creeper/hit_short.dae").bindFull(crepper);
        CREEPER_HIT_LONG = new HitAnimation(3401, 0.08f, "creeper/hit_long.dae").bindFull(crepper);
        CREEPER_DEATH = new HitAnimation(3402, 0.16f, "creeper/death.dae").bindFull(crepper);
        ENDERMAN_HIT_SHORT = new VariableHitAnimation(3004, 0.05f, "enderman/hit_short.dae").bindFull(enderman);
        ENDERMAN_HIT_LONG = new HitAnimation(3005, 0.08f, "enderman/hit_long.dae").bindFull(enderman);
        ENDERMAN_HIT_RAGE = new DodgingAnimation(3006, 0.16f, 0.0f, false, "enderman/convert_rampage.dae", -1.0f, -1.0f).bindFull(enderman);
        ENDERMAN_TP_KICK1 = new AttackAnimation(3007, 0.06f, 0.15f, 0.3f, 0.4f, 1.0f, false, Colliders.endermanStick, "11", "enderman/tp_kick1.dae").bindFull(enderman);
        ENDERMAN_TP_KICK2 = new AttackAnimation(3008, 0.16f, 0.15f, 0.25f, 0.45f, 1.0f, false, Colliders.endermanStick, "11", "enderman/tp_kick2.dae").bindFull(enderman);
        ENDERMAN_KICK1 = new AttackAnimation(3009, 0.16f, 0.66f, 0.7f, 0.81f, 1.6f, false, Colliders.endermanStick, "12", "enderman/rush_kick.dae").addProperty(Property.PhaseProperty.IMPACT, ValueCorrector.getSetter(4.0f)).bindFull(enderman);
        ENDERMAN_KICK2 = new AttackAnimation(3010, 0.16f, 0.8f, 0.8f, 0.9f, 1.3f, false, Colliders.endermanStick, "11", "enderman/flying_kick.dae").bindFull(enderman);
        ENDERMAN_KNEE = new AttackAnimation(3011, 0.16f, 0.25f, 0.25f, 0.31f, 1.0f, false, Colliders.endermanStick, "12", "enderman/knee.dae").addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).bindFull(enderman);
        ENDERMAN_KICK_COMBO = new AttackAnimation(3012, 0.1f, false, "enderman/kick_double.dae", new AttackAnimation.Phase(0.15f, 0.15f, 0.21f, 0.46f, "11", Colliders.endermanStick), new AttackAnimation.Phase(0.75f, 0.75f, 0.81f, 1.6f, "12", Colliders.endermanStick)).bindFull(enderman);
        ENDERMAN_GRASP = new AttackAnimation(3015, 0.06f, 0.5f, 0.45f, 1.0f, 1.0f, false, Colliders.endermanStick, "111213", "enderman/grasp.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(enderman);
        ENDERMAN_DEATH = new HitAnimation(3016, 0.16f, "enderman/death.dae").bindFull(enderman);
        ENDERMAN_TP_EMERGENCE = new ImmovableAnimation(3017, 0.05f, "enderman/teleport_emergence.dae").bindFull(enderman);
        SPIDER_ATTACK = new AttackAnimation(3100, 0.16f, 0.31f, 0.31f, 0.36f, 0.44f, false, Colliders.spiderRaid, "1", "spider/attack.dae").bindFull(spider);
        SPIDER_JUMP_ATTACK = new AttackAnimation(3101, 0.16f, 0.25f, 0.25f, 0.41f, 0.8f, true, Colliders.spiderRaid, "1", "spider/jump_attack.dae").bindFull(spider);
        SPIDER_HIT = new VariableHitAnimation(3102, 0.08f, "spider/hit.dae").bindFull(spider);
        SPIDER_DEATH = new HitAnimation(3103, 0.16f, "spider/death.dae").bindFull(spider);
        GOLEM_ATTACK1 = new AttackAnimation(3200, 0.2f, 0.1f, 0.15f, 0.25f, 0.9f, false, Colliders.headbutt, "11", "iron_golem/attack1.dae").bindFull(iron_golem);
        GOLEM_ATTACK2 = new AttackAnimation(3201, 0.34f, 0.1f, 0.4f, 0.6f, 1.15f, false, Colliders.golemSmashDown, "11121", "iron_golem/attack2.dae").bindFull(iron_golem);
        GOLEM_ATTACK3 = new AttackAnimation(3202, 0.16f, 0.4f, 0.4f, 0.5f, 0.9f, false, Colliders.golemSwingArm, "11131", "iron_golem/attack3.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(iron_golem);
        GOLEM_ATTACK4 = new AttackAnimation(3203, 0.16f, 0.4f, 0.4f, 0.5f, 0.9f, false, Colliders.golemSwingArm, "11121", "iron_golem/attack4.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(iron_golem);
        GOLEM_DEATH = new HitAnimation(3204, 0.11f, "iron_golem/death.dae").bindFull(iron_golem);
        VINDICATOR_SWING_AXE1 = new AttackAnimation(3300, 0.2f, 0.25f, 0.35f, 0.46f, 0.71f, false, Colliders.tools, "111213", "illager/swing_axe1.dae").bindFull(biped);
        VINDICATOR_SWING_AXE2 = new AttackAnimation(3301, 0.2f, 0.25f, 0.35f, 0.46f, 0.71f, false, Colliders.tools, "111213", "illager/swing_axe2.dae").bindFull(biped);
        VINDICATOR_SWING_AXE3 = new AttackAnimation(3302, 0.05f, 0.5f, 0.62f, 0.75f, 1.0f, true, Colliders.tools, "111213", "illager/swing_axe3.dae").bindFull(biped);
        PIGLIN_DEATH = new HitAnimation(6000, 0.16f, "piglin/death.dae").bindFull(piglin);
        HOGLIN_DEATH = new HitAnimation(6050, 0.16f, "hoglin/death.dae").bindFull(hoglin);
        HOGLIN_ATTACK = new AttackAnimation(6052, 0.16f, 0.25f, 0.25f, 0.45f, 1.0f, false, Colliders.golemSwingArm, "1", "hoglin/attack.dae").bindFull(hoglin);
        RAVAGER_DEATH = new HitAnimation(3600, 0.11f, "ravager/death.dae").bindFull(ravager);
        RAVAGER_STUN = new ActionAnimation(3601, 0.16f, true, false, "ravager/groggy.dae").bindFull(ravager);
        RAVAGER_ATTACK1 = new AttackAnimation(3602, 0.16f, 0.2f, 0.4f, 0.5f, 0.55f, false, Colliders.headbutt_ravager, "131", "ravager/attack1.dae").bindFull(ravager);
        RAVAGER_ATTACK2 = new AttackAnimation(3603, 0.16f, 0.2f, 0.4f, 0.5f, 1.3f, false, Colliders.headbutt_ravager, "131", "ravager/attack2.dae").bindFull(ravager);
        RAVAGER_ATTACK3 = new AttackAnimation(3604, 0.16f, 0.0f, 1.1f, 1.16f, 1.6f, false, Colliders.headbutt_ravager, "131", "ravager/attack3.dae").bindFull(ravager);
        VEX_HIT = new VariableHitAnimation(3308, 0.048f, "vex/hit.dae").bindFull(vex);
        VEX_DEATH = new HitAnimation(3309, 0.16f, "vex/death.dae").bindFull(vex);
        VEX_CHARGING = new AttackAnimation(3310, 0.11f, 0.3f, 0.3f, 0.5f, 1.2f, true, Colliders.sword, "", "vex/charge.dae").bindFull(vex);
        WITCH_DRINKING = new StaticAnimation(3306, 0.16f, false, "witch/drink.dae").bindFull(biped);
        WITHER_SKELETON_ATTACK1 = new AttackAnimation(3500, 0.16f, 0.2f, 0.3f, 0.41f, 0.7f, false, Colliders.sword, "111213", "skeleton/wither_skeleton_attack1.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        WITHER_SKELETON_ATTACK2 = new AttackAnimation(3501, 0.16f, 0.25f, 0.25f, 0.36f, 0.7f, false, Colliders.sword, "111213", "skeleton/wither_skeleton_attack2.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        WITHER_SKELETON_ATTACK3 = new AttackAnimation(3502, 0.16f, 0.25f, 0.25f, 0.36f, 0.7f, false, Colliders.sword, "111213", "skeleton/wither_skeleton_attack3.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        ZOMBIE_ATTACK1 = new AttackAnimation(4000, 0.1f, 0.3f, 0.35f, 0.55f, 0.85f, false, Colliders.fist, "111213", "zombie/attack1.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        ZOMBIE_ATTACK2 = new AttackAnimation(4001, 0.1f, 0.3f, 0.33f, 0.55f, 0.85f, false, Colliders.fist, "111313", "zombie/attack2.dae").addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        ZOMBIE_ATTACK3 = new AttackAnimation(4002, 0.1f, 0.5f, 0.5f, 0.6f, 1.15f, false, Colliders.headbutt, "113", "zombie/attack3.dae").bindFull(biped);
        SWEEPING_EDGE = new SpecialAttackAnimation(4111, 0.11f, 0.1f, 0.45f, 0.6f, 0.85f, false, null, "111213", "biped/skill/sweeping_edge.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        DANCING_EDGE = new SpecialAttackAnimation(4112, 0.25f, true, "biped/skill/dancing_edge.dae", new AttackAnimation.Phase(0.2f, 0.2f, 0.31f, 0.31f, "111213", null), new AttackAnimation.Phase(0.5f, 0.5f, 0.61f, 0.61f, Hand.OFF_HAND, "111313", null), new AttackAnimation.Phase(0.75f, 0.75f, 0.85f, 1.15f, "111213", null)).bindFull(biped);
        GUILLOTINE_AXE = new SpecialAttackAnimation(5000, 0.08f, 0.2f, 0.5f, 0.65f, 1.0f, true, null, "111213", "biped/skill/axe_special.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        SPEAR_THRUST = new SpecialAttackAnimation(5001, 0.11f, false, "biped/skill/spear_thrust.dae", new AttackAnimation.Phase(0.3f, 0.3f, 0.36f, 0.51f, "111213", null), new AttackAnimation.Phase(0.51f, 0.51f, 0.56f, 0.73f, "111213", null), new AttackAnimation.Phase(0.73f, 0.73f, 0.78f, 1.05f, "111213", null)).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        SPEAR_SLASH = new SpecialAttackAnimation(5002, 0.1f, false, "biped/skill/spear_slash.dae", new AttackAnimation.Phase(0.2f, 0.2f, 0.41f, 0.5f, "111213", null), new AttackAnimation.Phase(0.5f, 0.75f, 0.95f, 1.25f, "111213", null)).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).bindFull(biped);
        GIANT_WHIRLWIND = new SpecialAttackAnimation(5003, 0.41f, false, "biped/skill/giant_whirlwind.dae", new AttackAnimation.Phase(0.3f, 0.35f, 0.55f, 0.85f, "111213", null), new AttackAnimation.Phase(0.95f, 1.05f, 1.2f, 1.35f, "111213", null), new AttackAnimation.Phase(1.65f, 1.75f, 1.95f, 2.5f, "111213", null)).addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true)).addProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(true)).bindFull(biped);
        FATAL_DRAW = new SpecialAttackAnimation(5004, 0.15f, 0.0f, 0.7f, 0.81f, 1.0f, false, Colliders.fatal_draw, "", "biped/skill/fatal_draw.dae").addProperty(Property.PhaseProperty.SWING_SOUND, Sounds.WHOOSH_SHARP).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).registerSound(0.05f, Sounds.SWORD_IN, false).bindFull(biped);
        FATAL_DRAW_DASH = new SpecialAttackAnimation(5005, 0.15f, 0.43f, 0.85f, 0.91f, 1.4f, false, Colliders.fatal_draw_dash, "", "biped/skill/fatal_draw_dash.dae").addProperty(Property.PhaseProperty.SWING_SOUND, Sounds.WHOOSH_SHARP).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(true)).registerSound(0.05f, Sounds.SWORD_IN, false).bindFull(biped);
        LETHAL_SLICING = new SpecialAttackAnimation(5006, 0.15f, 0.0f, 0.0f, 0.1f, 0.38f, false, Colliders.narrow_front, "", "biped/skill/lethal_slicing_start.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        LETHAL_SLICING_ONCE = new SpecialAttackAnimation(5007, 0.016f, 0.0f, 0.0f, 0.1f, 0.6f, false, Colliders.fatal_draw, "", "biped/skill/lethal_slicing_once.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        LETHAL_SLICING_TWICE = new SpecialAttackAnimation(5008, 0.016f, false, "biped/skill/lethal_slicing_twice.dae", new AttackAnimation.Phase(0.0f, 0.0f, 0.1f, 0.15f, "", Colliders.fatal_draw), new AttackAnimation.Phase(0.15f, 0.15f, 0.25f, 0.6f, "", Colliders.fatal_draw)).addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        RELENTLESS_COMBO = new SpecialAttackAnimation(5009, 0.05f, false, "biped/skill/relentless_combo.dae", new AttackAnimation.Phase(0.016f, 0.016f, 0.066f, 0.133f, Hand.OFF_HAND, "", Colliders.narrow_front), new AttackAnimation.Phase(0.133f, 0.133f, 0.183f, 0.25f, "", Colliders.narrow_front), new AttackAnimation.Phase(0.25f, 0.25f, 0.3f, 0.366f, Hand.OFF_HAND, "", Colliders.narrow_front), new AttackAnimation.Phase(0.366f, 0.366f, 0.416f, 0.483f, "", Colliders.narrow_front), new AttackAnimation.Phase(0.483f, 0.483f, 0.533f, 0.6f, Hand.OFF_HAND, "", Colliders.narrow_front), new AttackAnimation.Phase(0.6f, 0.6f, 0.65f, 0.716f, "", Colliders.narrow_front), new AttackAnimation.Phase(0.716f, 0.716f, 0.766f, 0.833f, Hand.OFF_HAND, "", Colliders.narrow_front), new AttackAnimation.Phase(0.833f, 0.833f, 0.883f, 1.1f, "", Colliders.narrow_front)).bindFull(biped);
        EVISCERATE_FIRST = new SpecialAttackAnimation(5010, 0.08f, 0.05f, 0.05f, 0.15f, 0.45f, true, null, "111213", "biped/skill/eviscerate_first.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).bindFull(biped);
        EVISCERATE_SECOND = new SpecialAttackAnimation(5011, 0.15f, -0.1f, -0.1f, 0.0f, 0.4f, true, null, "111213", "biped/skill/eviscerate_second.dae").addProperty(Property.AnimationProperty.LOCK_ROTATION, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.HIT_SOUND, Sounds.EVISCERATE).addProperty(Property.PhaseProperty.PARTICLE, Particles.EVISCERATE_SKILL).bindFull(biped);
        BLADE_RUSH_FIRST = new SpecialAttackAnimation(5012, 0.1f, 0.0f, 0.0f, 0.06f, 0.3f, true, Colliders.blade_rush, "", "biped/skill/blade_rush_first.dae").addProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.TARGET_PRIORITY, AttackResult.Priority.TARGET).bindFull(biped);
        BLADE_RUSH_SECOND = new SpecialAttackAnimation(5013, 0.1f, 0.0f, 0.0f, 0.06f, 0.3f, true, Colliders.blade_rush, "", "biped/skill/blade_rush_second.dae").addProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.TARGET_PRIORITY, AttackResult.Priority.TARGET).bindFull(biped);
        BLADE_RUSH_THIRD = new SpecialAttackAnimation(5014, 0.1f, 0.0f, 0.0f, 0.06f, 0.3f, true, Colliders.blade_rush, "", "biped/skill/blade_rush_third.dae").addProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.TARGET_PRIORITY, AttackResult.Priority.TARGET).bindFull(biped);
        BLADE_RUSH_FINISHER = new SpecialAttackAnimation(5015, 0.15f, 0.0f, 0.1f, 0.16f, 0.65f, true, Colliders.blade_rush, "", "biped/skill/blade_rush_finisher.dae").addProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(true)).addProperty(Property.PhaseProperty.TARGET_PRIORITY, AttackResult.Priority.TARGET).bindFull(biped);
        MobAttackPatterns.setVariousMobAttackPatterns();
    }
}

