/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.gamedata;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import maninhouse.epicfight.animation.property.Property;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.skill.BladeRushSkill;
import maninhouse.epicfight.skill.DodgeSkill;
import maninhouse.epicfight.skill.EviscerateSkill;
import maninhouse.epicfight.skill.FatalDrawSkill;
import maninhouse.epicfight.skill.KatanaPassive;
import maninhouse.epicfight.skill.LethalSlicingSkill;
import maninhouse.epicfight.skill.LiechtenauerSkill;
import maninhouse.epicfight.skill.SimpleSpecialAttackSkill;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.ExtraDamageCalculator;
import maninhouse.epicfight.utils.math.ValueCorrector;
import net.minecraft.util.ResourceLocation;

public class Skills {
    public static final Map<ResourceLocation, Skill> MODIFIABLE_SKILLS = new HashMap<ResourceLocation, Skill>();
    public static Skill ROLL;
    public static Skill GUILLOTINE_AXE;
    public static Skill SWEEPING_EDGE;
    public static Skill DANCING_EDGE;
    public static Skill SLAUGHTER_STANCE;
    public static Skill HEARTPIERCER;
    public static Skill GIANT_WHIRLWIND;
    public static Skill FATAL_DRAW;
    public static Skill KATANA_GIMMICK;
    public static Skill LETHAL_SLICING;
    public static Skill RELENTLESS_COMBO;
    public static Skill LIECHTENAUER;
    public static Skill EVISCERATE;
    public static Skill BLADE_RUSH;

    public static void init() {
        ROLL = Skills.makeSkill("roll", skillName -> new DodgeSkill(SkillSlot.DODGE, 2.0f, (String)skillName, Animations.BIPED_ROLL_FORWARD, Animations.BIPED_ROLL_BACKWARD), true);
        SWEEPING_EDGE = Skills.makeSkill("sweeping_edge", skillName -> new SimpleSpecialAttackSkill(30.0f, (String)skillName, Animations.SWEEPING_EDGE).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getAdder(1.0f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(1.0f)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(20.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation(), false);
        DANCING_EDGE = Skills.makeSkill("dancing_edge", skillName -> new SimpleSpecialAttackSkill(30.0f, (String)skillName, Animations.DANCING_EDGE).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getAdder(1.0f)).addProperty(Property.PhaseProperty.IMPACT, ValueCorrector.getAdder(0.5f)).registerPropertiesToAnimation(), false);
        GUILLOTINE_AXE = Skills.makeSkill("guillotine_axe", skillName -> new SimpleSpecialAttackSkill(20.0f, (String)skillName, Animations.GUILLOTINE_AXE).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(1.0f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(1.5f)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(20.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation(), false);
        SLAUGHTER_STANCE = Skills.makeSkill("slaughter_stance", skillName -> new SimpleSpecialAttackSkill(40.0f, (String)skillName, Animations.SPEAR_SLASH).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getAdder(4.0f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(0.25f)).registerPropertiesToAnimation(), false);
        HEARTPIERCER = Skills.makeSkill("heartpiercer", skillName -> new SimpleSpecialAttackSkill(40.0f, (String)skillName, Animations.SPEAR_THRUST).newPropertyLine().addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(10.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).registerPropertiesToAnimation(), false);
        GIANT_WHIRLWIND = Skills.makeSkill("giant_whirlwind", skillName -> new SimpleSpecialAttackSkill(60.0f, (String)skillName, Animations.GIANT_WHIRLWIND).newPropertyLine(), false);
        FATAL_DRAW = Skills.makeSkill("fatal_draw", skillName -> new FatalDrawSkill((String)skillName).newPropertyLine().addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(1.0f)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(50.0f)).addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getAdder(6.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).registerPropertiesToAnimation(), false);
        KATANA_GIMMICK = new KatanaPassive();
        LETHAL_SLICING = Skills.makeSkill("lethal_slicing", skillName -> new LethalSlicingSkill(35.0f, (String)skillName).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(2.0f)).addProperty(Property.PhaseProperty.IMPACT, ValueCorrector.getSetter(0.5f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getSetter(1.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).addProperty(Property.PhaseProperty.HIT_SOUND, Sounds.BLUNT_HIT).addProperty(Property.PhaseProperty.PARTICLE, Particles.HIT_BLUNT).newPropertyLine().addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(50.0f)).addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getAdder(2.0f)).addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(0.7f)).addProperty(Property.PhaseProperty.SWING_SOUND, Sounds.WHOOSH_SHARP).registerPropertiesToAnimation(), false);
        RELENTLESS_COMBO = Skills.makeSkill("relentless_combo", skillName -> new SimpleSpecialAttackSkill(20.0f, (String)skillName, Animations.RELENTLESS_COMBO).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(1.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).addProperty(Property.PhaseProperty.PARTICLE, Particles.HIT_BLUNT).registerPropertiesToAnimation(), false);
        LIECHTENAUER = Skills.makeSkill("liechtenauer", skillName -> new LiechtenauerSkill((String)skillName), false);
        EVISCERATE = Skills.makeSkill("eviscerate", skillName -> new EviscerateSkill(25.0f, (String)skillName).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(1.0f)).addProperty(Property.PhaseProperty.IMPACT, ValueCorrector.getSetter(2.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(1.0f)).addProperty(Property.PhaseProperty.EXTRA_DAMAGE, ExtraDamageCalculator.get(ExtraDamageCalculator.PERCENT_OF_TARGET_LOST_HEALTH, 0.5f)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(50.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation(), false);
        BLADE_RUSH = Skills.makeSkill("blade_rush", skillName -> new BladeRushSkill(25.0f, (String)skillName).newPropertyLine().addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(1.0f)).newPropertyLine().addProperty(Property.PhaseProperty.DAMAGE, ValueCorrector.getMultiplier(1.5f)).addProperty(Property.PhaseProperty.ARMOR_NEGATION, ValueCorrector.getAdder(20.0f)).addProperty(Property.PhaseProperty.MAX_STRIKES, ValueCorrector.getSetter(1.0f)).addProperty(Property.PhaseProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).addProperty(Property.PhaseProperty.HIT_SOUND, Sounds.BLADE_RUSH_FINISHER).addProperty(Property.PhaseProperty.PARTICLE, Particles.BLADE_RUSH_SKILL).registerPropertiesToAnimation(), false);
    }

    public static Skill makeSkill(String skillName, Function<String, Skill> object, boolean registerSkillBook) {
        if (registerSkillBook) {
            MODIFIABLE_SKILLS.put(new ResourceLocation("epicfight", skillName), object.apply(skillName));
        }
        return object.apply(skillName);
    }
}

