/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.item;

import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.ModWeaponCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.item.WeaponItem;
import net.minecraft.block.BlockState;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;
import net.minecraft.util.Hand;

public class DaggerItem
extends WeaponItem {
    public DaggerItem(Item.Properties build, ItemTier materialIn) {
        super((IItemTier)materialIn, 1, -1.6f, build);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    @Override
    public void setWeaponCapability(IItemTier tier) {
        int harvestLevel = tier.func_200925_d();
        ModWeaponCapability weaponCapability = new ModWeaponCapability(CapabilityItem.WeaponCategory.DAGGER, playerdata -> {
            CapabilityItem item = playerdata.getHeldItemCapability(Hand.OFF_HAND);
            if (item != null && item.getWeaponCategory() == CapabilityItem.WeaponCategory.DAGGER) {
                return CapabilityItem.WieldStyle.TWO_HAND;
            }
            return CapabilityItem.WieldStyle.ONE_HAND;
        }, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.dagger, CapabilityItem.HeldOption.GENERAL);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.DAGGER_AUTO_1, Animations.DAGGER_AUTO_2, Animations.DAGGER_AUTO_3, Animations.SWORD_DASH);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.DAGGER_DUAL_AUTO_1, Animations.DAGGER_DUAL_AUTO_2, Animations.DAGGER_DUAL_AUTO_3, Animations.DAGGER_DUAL_AUTO_4, Animations.DAGGER_DUAL_DASH);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
        weaponCapability.addStyleAttributeSimple(CapabilityItem.WieldStyle.ONE_HAND, 0.0, 0.5 + (double)harvestLevel * 0.1, 0);
        weaponCapability.addStyleAttributeSimple(CapabilityItem.WieldStyle.TWO_HAND, 0.0, 0.5 + (double)harvestLevel * 0.1, 1);
        weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.EVISCERATE);
        weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.BLADE_RUSH);
        this.capability = weaponCapability;
    }
}

