/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.ModWeaponCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.item.WeaponItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GreatswordItem
extends WeaponItem {
    protected static final UUID MOVEMENT_SPEED_MODIFIER = UUID.fromString("16295ED8-B092-4A75-9A94-BCD8D56668BB");
    private final float attackDamage;
    private final float attackSpeed;

    public GreatswordItem(Item.Properties build, IItemTier tier) {
        super(tier, 0, 0.0f, build);
        this.attackDamage = 11.0f + tier.func_200929_c();
        this.attackSpeed = -2.85f - 0.05f * (float)tier.func_200925_d();
    }

    public int func_77619_b() {
        return 5;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    @Override
    public void setWeaponCapability(IItemTier tier) {
        ModWeaponCapability weaponCapability = new ModWeaponCapability(CapabilityItem.WeaponCategory.GREATSWORD, playerdata -> CapabilityItem.WieldStyle.TWO_HAND, null, Sounds.WHOOSH_BIG, Sounds.BLADE_HIT, Colliders.greatSword, CapabilityItem.HeldOption.TWO_HANDED);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.GREATSWORD_AUTO_1, Animations.GREATSWORD_AUTO_2, Animations.GREATSWORD_DASH);
        weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.GIANT_WHIRLWIND);
        weaponCapability.addStyleAttributeSimple(CapabilityItem.WieldStyle.TWO_HAND, tier.func_200925_d() >= 3 ? 10.0 * (double)(tier.func_200925_d() - 2) : 0.0, 2.8 + 0.4 * (double)tier.func_200925_d(), 4);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.IDLE, Animations.BIPED_IDLE_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.WALKING, Animations.BIPED_WALK_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.JUMPING, Animations.BIPED_JUMP_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
        this.capability = weaponCapability;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        if (slot == EquipmentSlotType.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(MOVEMENT_SPEED_MODIFIER, "Weapon modifier", -0.02, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

