/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.item;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.ModWeaponCapability;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.item.WeaponItem;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.block.BlockState;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemTier;

public class LongswordItem
extends WeaponItem {
    public LongswordItem(Item.Properties build, ItemTier materialIn) {
        super((IItemTier)materialIn, 4, -2.6f, build);
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    @Override
    public void setWeaponCapability(IItemTier tier) {
        int harvestLevel = tier.func_200925_d();
        ModWeaponCapability weaponCapability = new ModWeaponCapability(CapabilityItem.WeaponCategory.LONGSWORD, playerdata -> {
            if (playerdata instanceof PlayerData && ((PlayerData)playerdata).getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).getRemainDuration() > 0) {
                return CapabilityItem.WieldStyle.LIECHTENHAUER;
            }
            return CapabilityItem.WieldStyle.TWO_HAND;
        }, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.longsword, CapabilityItem.HeldOption.TWO_HANDED);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.LONGSWORD_AUTO_1, Animations.LONGSWORD_AUTO_2, Animations.LONGSWORD_AUTO_3, Animations.LONGSWORD_DASH);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.LIECHTENHAUER, Animations.LONGSWORD_AUTO_1, Animations.LONGSWORD_AUTO_2, Animations.LONGSWORD_AUTO_3, Animations.LONGSWORD_DASH);
        weaponCapability.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
        weaponCapability.addStyleAttributeSimple(CapabilityItem.WieldStyle.TWO_HAND, 0.0, 1.0 + (double)harvestLevel * 0.5, 2);
        weaponCapability.addStyleAttributeSimple(CapabilityItem.WieldStyle.LIECHTENHAUER, 0.0, 1.0 + (double)harvestLevel * 0.5, 2);
        weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.LIECHTENAUER);
        weaponCapability.addStyleSpecialAttack(CapabilityItem.WieldStyle.LIECHTENHAUER, Skills.LIECHTENAUER);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.IDLE, Animations.BIPED_IDLE_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.WALKING, Animations.BIPED_WALK_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.TWO_HAND, LivingMotion.JUMPING, Animations.BIPED_JUMP_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.IDLE, Animations.BIPED_IDLE_LONGSWORD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.WALKING, Animations.BIPED_WALK_LONGSWORD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
        weaponCapability.addLivingMotionModifier(CapabilityItem.WieldStyle.LIECHTENHAUER, LivingMotion.JUMPING, Animations.BIPED_JUMP_LONGSWORD);
        this.capability = weaponCapability;
    }
}

