/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.model;

import java.util.Map;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;

public class Armature {
    private final Map<Integer, Joint> jointTable;
    private final Joint jointHierarcy;
    private final int jointNumber;

    public Armature(int jointNumber, Joint rootJoint, Map<Integer, Joint> jointTable) {
        this.jointNumber = jointNumber;
        this.jointHierarcy = rootJoint;
        this.jointTable = jointTable;
    }

    public VisibleMatrix4f[] getJointTransforms() {
        VisibleMatrix4f[] jointMatrices = new VisibleMatrix4f[this.jointNumber];
        this.jointToTransformMatrixArray(this.jointHierarcy, jointMatrices);
        return jointMatrices;
    }

    public Joint findJointById(int id) {
        return this.jointTable.get(id);
    }

    public Joint findJointByName(String name) {
        for (int i : this.jointTable.keySet()) {
            if (!this.jointTable.get(i).getName().equals(name)) continue;
            return this.jointTable.get(i);
        }
        return null;
    }

    public void initializeTransform() {
        this.jointHierarcy.initializeAnimationTransform();
    }

    public int getJointNumber() {
        return this.jointNumber;
    }

    public Joint getJointHierarcy() {
        return this.jointHierarcy;
    }

    private void jointToTransformMatrixArray(Joint joint, VisibleMatrix4f[] jointMatrices) {
        VisibleMatrix4f result = new VisibleMatrix4f();
        VisibleMatrix4f.mul(joint.getAnimatedTransform(), joint.getInversedModelTransform(), result);
        jointMatrices[joint.getId()] = result;
        for (Joint childJoint : joint.getSubJoints()) {
            this.jointToTransformMatrixArray(childJoint, jointMatrices);
        }
    }
}

