/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.client;

import java.util.function.Supplier;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCToggleMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CTSToggleMode {
    private boolean battleMode;

    public CTSToggleMode(boolean battleMode) {
        this.battleMode = battleMode;
    }

    public static CTSToggleMode fromBytes(PacketBuffer buf) {
        return new CTSToggleMode(buf.readBoolean());
    }

    public static void toBytes(CTSToggleMode msg, PacketBuffer buf) {
        buf.writeBoolean(msg.battleMode);
    }

    public static void handle(CTSToggleMode msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerData entitydata;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (entitydata = (PlayerData)player.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                entitydata.setBattleMode(msg.battleMode);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCToggleMode(player.func_145782_y(), msg.battleMode), (Entity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

