/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.server;

import java.lang.constant.Constable;
import java.util.function.Supplier;
import maninhouse.epicfight.world.ModGamerules;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.network.NetworkEvent;

public class STCGameruleChange {
    private Gamerules gamerule;
    private int gameruleId;
    private Object object;

    public STCGameruleChange(Gamerules gamerule, Object object) {
        this.gamerule = gamerule;
        this.gameruleId = gamerule.id;
        this.object = object;
    }

    public static STCGameruleChange fromBytes(PacketBuffer buf) {
        int id = buf.readInt();
        Gamerules gamerule = Gamerules.values()[id];
        Constable obj = null;
        switch (gamerule.valueType) {
            case INTEGER: {
                obj = buf.readInt();
                break;
            }
            case BOOLEAN: {
                obj = Boolean.valueOf(buf.readBoolean());
            }
        }
        return new STCGameruleChange(gamerule, obj);
    }

    public static void toBytes(STCGameruleChange msg, PacketBuffer buf) {
        buf.writeInt(msg.gameruleId);
        switch (msg.gamerule.valueType) {
            case INTEGER: {
                buf.writeInt(((Integer)msg.object).intValue());
                break;
            }
            case BOOLEAN: {
                buf.writeBoolean(((Boolean)msg.object).booleanValue());
            }
        }
    }

    public static void handle(STCGameruleChange msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (msg.gamerule.valueType) {
                case INTEGER: {
                    ((GameRules.IntegerValue)Minecraft.func_71410_x().field_71441_e.func_82736_K().func_223585_a(msg.gamerule.key)).func_234909_b_(msg.object.toString());
                    break;
                }
                case BOOLEAN: {
                    ((GameRules.BooleanValue)Minecraft.func_71410_x().field_71441_e.func_82736_K().func_223585_a(msg.gamerule.key)).func_223570_a(((Boolean)msg.object).booleanValue(), null);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Gamerules {
        HAS_FALL_ANIMATION(0, ValueType.BOOLEAN, ModGamerules.HAS_FALL_ANIMATION),
        SPEED_PENALTY_PERCENT(1, ValueType.INTEGER, ModGamerules.SPEED_PENALTY_PERCENT);

        ValueType valueType;
        GameRules.RuleKey<?> key;
        int id;

        private Gamerules(int id, ValueType valueType, GameRules.RuleKey<?> key) {
            this.id = id;
            this.valueType = valueType;
            this.key = key;
        }

        static enum ValueType {
            INTEGER,
            BOOLEAN;

        }
    }
}

