/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class STCMobInitialSetting {
    private int entityId;
    private PacketBuffer buffer;

    public STCMobInitialSetting() {
        this.entityId = 0;
        this.buffer = new PacketBuffer(Unpooled.buffer());
    }

    public STCMobInitialSetting(int entityId) {
        this.entityId = entityId;
        this.buffer = new PacketBuffer(Unpooled.buffer());
    }

    public PacketBuffer getBuffer() {
        return this.buffer;
    }

    public static STCMobInitialSetting fromBytes(PacketBuffer buf) {
        STCMobInitialSetting msg = new STCMobInitialSetting(buf.readInt());
        while (buf.isReadable()) {
            msg.buffer.writeByte((int)buf.readByte());
        }
        return msg;
    }

    public static void toBytes(STCMobInitialSetting msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        while (msg.buffer.isReadable()) {
            buf.writeByte((int)msg.buffer.readByte());
        }
    }

    public static void handle(STCMobInitialSetting msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId);
            if (entity != null) {
                BipedMobData entitydata = (BipedMobData)entity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null);
                entitydata.clientInitialSettings((ByteBuf)msg.getBuffer());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

