/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.server;

import java.util.function.Supplier;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class STCNotifyPlayerYawChanged {
    private int entityId;
    private float yaw;

    public STCNotifyPlayerYawChanged() {
        this.entityId = 0;
        this.yaw = 0.0f;
    }

    public STCNotifyPlayerYawChanged(int entityId, float yaw) {
        this.entityId = entityId;
        this.yaw = yaw;
    }

    public static STCNotifyPlayerYawChanged fromBytes(PacketBuffer buf) {
        return new STCNotifyPlayerYawChanged(buf.readInt(), buf.readFloat());
    }

    public static void toBytes(STCNotifyPlayerYawChanged msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeFloat(msg.yaw);
    }

    public static void handle(STCNotifyPlayerYawChanged msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerData entitydata;
            Entity entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId);
            if (entity != null && (entitydata = (PlayerData)entity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null).orElse(null)) != null) {
                entitydata.changeYaw(msg.yaw);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

