/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.fml.network.NetworkEvent;

public class STCPotion {
    private Effect effect;
    private Action action;
    private int entityId;

    public STCPotion() {
        this.effect = null;
        this.entityId = 0;
        this.action = Action.Remove;
    }

    public STCPotion(Effect effect, Action action, int entityId) {
        this.effect = effect;
        this.entityId = entityId;
        this.action = action;
    }

    public static STCPotion fromBytes(PacketBuffer buf) {
        Effect effect = Effect.func_188412_a((int)buf.readInt());
        int entityId = buf.readInt();
        Action action = Action.getAction(buf.readInt());
        return new STCPotion(effect, action, entityId);
    }

    public static void toBytes(STCPotion msg, PacketBuffer buf) {
        buf.writeInt(Effect.func_188409_a((Effect)msg.effect));
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.action.getSymb());
    }

    public static void handle(STCPotion msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity livEntity = (LivingEntity)entity;
                switch (msg.action) {
                    case Active: {
                        livEntity.func_195064_c(new EffectInstance(msg.effect, 0));
                        break;
                    }
                    case Remove: {
                        livEntity.func_195063_d(msg.effect);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        Active(0),
        Remove(1);

        int action;

        private Action(int action) {
            this.action = action;
        }

        public int getSymb() {
            return this.action;
        }

        private static Action getAction(int symb) {
            if (symb == 0) {
                return Active;
            }
            if (symb == 1) {
                return Remove;
            }
            return null;
        }
    }
}

