/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Collider {
    protected final Vec3f modelCenter;
    protected final AxisAlignedBB outerAABB;
    protected Vec3f worldCenter;

    public Collider(Vec3f center, @Nullable AxisAlignedBB outerAABB) {
        this.modelCenter = center;
        this.outerAABB = outerAABB;
        this.worldCenter = new Vec3f();
    }

    protected void transform(VisibleMatrix4f mat) {
        Vec4f temp = new Vec4f(this.modelCenter.x, this.modelCenter.y, this.modelCenter.z, 1.0f);
        VisibleMatrix4f.transform(mat, temp, temp);
        this.worldCenter.x = temp.x;
        this.worldCenter.y = temp.y;
        this.worldCenter.z = temp.z;
    }

    public void updateTransform(LivingData<?> entitydata, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, int jointIndexer) {
        VisibleMatrix4f transformMatrix;
        if (jointIndexer == -1) {
            transformMatrix = new VisibleMatrix4f();
        } else {
            float partialTime = MathHelper.func_219799_g((float)0.5f, (float)prevElapsedTime, (float)elapsedTime);
            transformMatrix = entitydata.getServerAnimator().getJointTransformByIndex(attackAnimation.getPoseByTime(entitydata, partialTime), entitydata.getEntityModel(Models.LOGICAL_SERVER).getArmature().getJointHierarcy(), new VisibleMatrix4f(), jointIndexer);
        }
        VisibleMatrix4f.mul(entitydata.getModelMatrix(1.0f), transformMatrix, transformMatrix);
        this.transform(transformMatrix);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void drawInternal(MatrixStack var1, IRenderTypeBuffer var2, VisibleMatrix4f var3, boolean var4);

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingData<?> entitydata, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks) {
        int index = animation.getIndexer(elapsedTime);
        boolean flag3 = entitydata.getEntityState().shouldDetectCollision();
        VisibleMatrix4f mat = null;
        if (index == -1) {
            mat = new VisibleMatrix4f();
        } else {
            Armature armature = entitydata.getEntityModel(Models.LOGICAL_SERVER).getArmature();
            armature.initializeTransform();
            mat = entitydata.getClientAnimator().getJointTransformByIndex(animation.getPoseByTime(entitydata, elapsedTime), armature.getJointHierarcy(), new VisibleMatrix4f(), index);
        }
        this.drawInternal(matrixStackIn, buffer, mat, flag3);
    }

    public abstract boolean isCollideWith(Entity var1);

    public void extractHitEntities(List<Entity> entities) {
        Iterator<Entity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (this.isCollideWith(entity)) continue;
            iterator.remove();
        }
    }

    public AxisAlignedBB getHitboxAABB() {
        return this.outerAABB.func_72317_d((double)(-this.worldCenter.x), (double)this.worldCenter.y, (double)(-this.worldCenter.z));
    }
}

