/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class LineCollider
extends Collider {
    private Vec3f modelVec;
    private Vec3f worldVec;

    public LineCollider(float posX, float posY, float posZ, float vecX, float vecY, float vecZ) {
        this(LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ), posX, posY, posZ, vecX, vecY, vecZ);
    }

    public LineCollider(AxisAlignedBB outerAABB, float posX, float posY, float posZ, float vecX, float vecY, float vecZ) {
        super(new Vec3f(posX, posY, posZ), outerAABB);
        this.modelVec = new Vec3f(vecX, vecY, vecZ);
        this.worldVec = new Vec3f();
    }

    static AxisAlignedBB getInitialAABB(float posX, float posY, float posZ, float vecX, float vecY, float vecZ) {
        Vec3f start = new Vec3f(posX, posY, posZ);
        Vec3f end = new Vec3f(vecX + posX, vecY + posY, vecZ + posZ);
        float length = Math.max(start.length(), end.length());
        return new AxisAlignedBB((double)length, (double)length, (double)length, (double)(-length), (double)(-length), (double)(-length));
    }

    @Override
    public void transform(VisibleMatrix4f mat) {
        Vec4f tempVector = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        VisibleMatrix4f rotationMatrix = new VisibleMatrix4f(mat);
        rotationMatrix.m30 = 0.0f;
        rotationMatrix.m31 = 0.0f;
        rotationMatrix.m32 = 0.0f;
        tempVector.x = this.modelVec.x;
        tempVector.y = this.modelVec.y;
        tempVector.z = this.modelVec.z;
        VisibleMatrix4f.transform(rotationMatrix, tempVector, tempVector);
        this.worldVec.x = tempVector.x;
        this.worldVec.y = tempVector.y;
        this.worldVec.z = tempVector.z;
        super.transform(mat);
    }

    @Override
    public boolean isCollideWith(Entity entity) {
        float endZ;
        float endY;
        float maxStart;
        float minEnd;
        float temp;
        float endX;
        AxisAlignedBB opponent = entity.func_174813_aQ();
        if (this.worldVec.x == 0.0f && ((double)this.worldCenter.x < opponent.field_72340_a || (double)this.worldCenter.x > opponent.field_72336_d)) {
            return false;
        }
        float startX = MathHelper.func_76131_a((float)((float)(opponent.field_72340_a + (double)this.worldCenter.x) / -this.worldVec.x), (float)0.0f, (float)1.0f);
        if (startX > (endX = MathHelper.func_76131_a((float)((float)(opponent.field_72336_d + (double)this.worldCenter.x) / -this.worldVec.x), (float)0.0f, (float)1.0f))) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if ((minEnd = endX) == (maxStart = startX)) {
            return false;
        }
        if (this.worldVec.y == 0.0f && ((double)this.worldCenter.y < opponent.field_72338_b || (double)this.worldCenter.y > opponent.field_72337_e)) {
            return false;
        }
        float startY = MathHelper.func_76131_a((float)((float)(opponent.field_72338_b - (double)this.worldCenter.y) / this.worldVec.y), (float)0.0f, (float)1.0f);
        if (startY > (endY = MathHelper.func_76131_a((float)((float)(opponent.field_72337_e - (double)this.worldCenter.y) / this.worldVec.y), (float)0.0f, (float)1.0f))) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        maxStart = maxStart < startY ? startY : maxStart;
        float f = minEnd = minEnd > endY ? endY : minEnd;
        if (maxStart >= minEnd) {
            return false;
        }
        if (this.worldVec.z == 0.0f && ((double)this.worldCenter.z < opponent.field_72339_c || (double)this.worldCenter.z > opponent.field_72334_f)) {
            return false;
        }
        float startZ = MathHelper.func_76131_a((float)((float)(opponent.field_72339_c + (double)this.worldCenter.z) / -this.worldVec.z), (float)0.0f, (float)1.0f);
        if (startZ > (endZ = MathHelper.func_76131_a((float)((float)(opponent.field_72334_f + (double)this.worldCenter.z) / -this.worldVec.z), (float)0.0f, (float)1.0f))) {
            temp = startZ;
            startZ = endZ;
            endZ = temp;
        }
        maxStart = maxStart < startZ ? startZ : maxStart;
        float f2 = minEnd = minEnd > endZ ? endZ : minEnd;
        return !(maxStart >= minEnd);
    }

    @Override
    public void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, VisibleMatrix4f pose, boolean red) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(ModRenderTypes.getLine());
        VisibleMatrix4f transpose = new VisibleMatrix4f();
        VisibleMatrix4f.transpose(pose, transpose);
        MathUtils.translateStack(matrixStackIn, pose);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
        float startX = this.modelCenter.x;
        float startY = this.modelCenter.y;
        float startZ = this.modelCenter.z;
        float endX = this.modelCenter.x + this.modelVec.x;
        float endY = this.modelCenter.y + this.modelVec.y;
        float endZ = this.modelCenter.z + this.modelVec.z;
        float color = red ? 0.0f : 1.0f;
        vertexBuilder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
    }
}

