/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public abstract class MultiCollider<T extends Collider>
extends Collider {
    protected T[] colliders;
    protected float partialScale;

    public MultiCollider(int arrayLength, float posX, float posY, float posZ, AxisAlignedBB outerAABB) {
        super(new Vec3f(posX, posY, posZ), outerAABB);
        this.partialScale = 1.0f / (float)arrayLength;
    }

    @Override
    public void updateTransform(LivingData<?> entitydata, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, int jointIndexer) {
        float interpolation = this.partialScale;
        for (T lineCollider : this.colliders) {
            VisibleMatrix4f transformMatrix;
            if (jointIndexer == -1) {
                transformMatrix = new VisibleMatrix4f();
            } else {
                float partialTime = MathHelper.func_219799_g((float)interpolation, (float)prevElapsedTime, (float)elapsedTime);
                Armature armature = entitydata.getEntityModel(Models.LOGICAL_SERVER).getArmature();
                armature.initializeTransform();
                transformMatrix = entitydata.getServerAnimator().getJointTransformByIndex(attackAnimation.getPoseByTime(entitydata, partialTime), armature.getJointHierarcy(), new VisibleMatrix4f(), jointIndexer);
            }
            VisibleMatrix4f.mul(entitydata.getModelMatrix(interpolation), transformMatrix, transformMatrix);
            ((Collider)lineCollider).transform(transformMatrix);
            if (interpolation == this.partialScale) {
                this.transform(transformMatrix);
            }
            interpolation += this.partialScale;
        }
    }

    @Override
    protected void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, VisibleMatrix4f pose, boolean red) {
    }

    @Override
    public AxisAlignedBB getHitboxAABB() {
        AxisAlignedBB aabb = super.getHitboxAABB();
        for (T collider : this.colliders) {
            aabb = aabb.func_111270_a(((Collider)collider).getHitboxAABB());
        }
        return aabb;
    }

    @Override
    public boolean isCollideWith(Entity opponent) {
        for (T lineCollider : this.colliders) {
            if (!((Collider)lineCollider).isCollideWith(opponent)) continue;
            return true;
        }
        return false;
    }
}

