/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.physics.LineCollider;
import maninhouse.epicfight.physics.MultiCollider;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MultiLineCollider
extends MultiCollider<LineCollider> {
    public MultiLineCollider(int arrayLength, float posX, float posY, float posZ, float vecX, float vecY, float vecZ) {
        super(arrayLength, posX, posY, posZ, LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ));
        this.colliders = new LineCollider[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            ((LineCollider[])this.colliders)[i] = new LineCollider(this.outerAABB, posX, posY, posZ, vecX, vecY, vecZ);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingData<?> entitydata, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks) {
        int jointIndex = animation.getIndexer(elapsedTime);
        boolean flag3 = entitydata.getEntityState().shouldDetectCollision();
        float interpolation = this.partialScale;
        for (LineCollider lineCollider : (LineCollider[])this.colliders) {
            matrixStackIn.func_227860_a_();
            VisibleMatrix4f mat = null;
            Armature armature = entitydata.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature();
            armature.initializeTransform();
            float partialTime = MathHelper.func_219799_g((float)interpolation, (float)prevElapsedTime, (float)elapsedTime);
            mat = jointIndex == -1 ? new VisibleMatrix4f() : entitydata.getClientAnimator().getJointTransformByIndex(animation.getPoseByTime(entitydata, partialTime), armature.getJointHierarcy(), new VisibleMatrix4f(), jointIndex);
            lineCollider.drawInternal(matrixStackIn, buffer, mat, flag3);
            interpolation += this.partialScale;
            matrixStackIn.func_227865_b_();
        }
    }
}

