/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.physics.MultiCollider;
import maninhouse.epicfight.physics.OBBCollider;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MultiOBBCollider
extends MultiCollider<OBBCollider> {
    public MultiOBBCollider(int arrayLength, float posX, float posY, float posZ, float vecX, float vecY, float vecZ) {
        super(arrayLength, posX, posY, posZ, OBBCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ));
        this.colliders = new OBBCollider[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            ((OBBCollider[])this.colliders)[i] = new OBBCollider(this.outerAABB, posX, posY, posZ, vecX, vecY, vecZ);
        }
        this.partialScale = 1.0f / (float)((OBBCollider[])this.colliders).length;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingData<?> entitydata, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks) {
        int jointIndex = animation.getIndexer(elapsedTime);
        boolean flag3 = entitydata.getEntityState().shouldDetectCollision();
        float interpolation = 0.0f;
        for (OBBCollider lineCollider : (OBBCollider[])this.colliders) {
            if (interpolation <= partialTicks && partialTicks < interpolation + this.partialScale) {
                VisibleMatrix4f mat = null;
                Armature armature = entitydata.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature();
                armature.initializeTransform();
                mat = jointIndex == -1 ? new VisibleMatrix4f() : entitydata.getClientAnimator().getJointTransformByIndex(animation.getPoseByTime(entitydata, MathHelper.func_219799_g((float)partialTicks, (float)prevElapsedTime, (float)elapsedTime)), armature.getJointHierarcy(), new VisibleMatrix4f(), jointIndex);
                lineCollider.drawInternal(matrixStackIn, buffer, mat, flag3);
                break;
            }
            interpolation += this.partialScale;
        }
    }
}

