/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import maninhouse.epicfight.client.renderer.ModRenderTypes;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OBBCollider
extends Collider {
    private final Vec3f[] modelVertex;
    private final Vec3f[] modelNormal;
    private Vec3f[] rotatedVertex;
    private Vec3f[] rotatedNormal;

    public OBBCollider(float posX, float posY, float posZ, float center_x, float center_y, float center_z) {
        this(OBBCollider.getInitialAABB(posX, posY, posZ, center_x, center_y, center_z), posX, posY, posZ, center_x, center_y, center_z);
    }

    public OBBCollider(AxisAlignedBB outerAABB, float posX, float posY, float posZ, float center_x, float center_y, float center_z) {
        super(new Vec3f(center_x, center_y, center_z), outerAABB);
        this.modelVertex = new Vec3f[4];
        this.modelNormal = new Vec3f[3];
        this.rotatedVertex = new Vec3f[4];
        this.rotatedNormal = new Vec3f[3];
        this.modelVertex[0] = new Vec3f(posX, posY, -posZ);
        this.modelVertex[1] = new Vec3f(posX, posY, posZ);
        this.modelVertex[2] = new Vec3f(-posX, posY, posZ);
        this.modelVertex[3] = new Vec3f(-posX, posY, -posZ);
        this.modelNormal[0] = new Vec3f(1.0f, 0.0f, 0.0f);
        this.modelNormal[1] = new Vec3f(0.0f, 1.0f, 0.0f);
        this.modelNormal[2] = new Vec3f(0.0f, 0.0f, -1.0f);
        this.rotatedVertex[0] = new Vec3f();
        this.rotatedVertex[1] = new Vec3f();
        this.rotatedVertex[2] = new Vec3f();
        this.rotatedVertex[3] = new Vec3f();
        this.rotatedNormal[0] = new Vec3f();
        this.rotatedNormal[1] = new Vec3f();
        this.rotatedNormal[2] = new Vec3f();
    }

    static AxisAlignedBB getInitialAABB(float posX, float posY, float posZ, float center_x, float center_y, float center_z) {
        float xLength = Math.abs(posX) + Math.abs(center_x);
        float yLength = Math.abs(posY) + Math.abs(center_y);
        float zLength = Math.abs(posZ) + Math.abs(center_z);
        float maxLength = Math.max(xLength, Math.max(yLength, zLength));
        return new AxisAlignedBB((double)maxLength, (double)maxLength, (double)maxLength, (double)(-maxLength), (double)(-maxLength), (double)(-maxLength));
    }

    public OBBCollider(AxisAlignedBB entityCallAABB, float pos1_x, float pos1_y, float pos1_z, float pos2_x, float pos2_y, float pos2_z, float norm1_x, float norm1_y, float norm1_z, float norm2_x, float norm2_y, float norm2_z, float center_x, float center_y, float center_z) {
        super(new Vec3f(center_x, center_y, center_z), entityCallAABB);
        this.modelVertex = new Vec3f[2];
        this.modelNormal = new Vec3f[2];
        this.rotatedVertex = new Vec3f[2];
        this.rotatedNormal = new Vec3f[2];
        this.modelVertex[0] = new Vec3f(pos1_x, pos1_y, pos1_z);
        this.modelVertex[1] = new Vec3f(pos2_x, pos2_y, pos2_z);
        this.modelNormal[0] = new Vec3f(norm1_x, norm1_y, norm1_z);
        this.modelNormal[1] = new Vec3f(norm2_x, norm2_y, norm2_z);
        this.rotatedVertex[0] = new Vec3f();
        this.rotatedVertex[1] = new Vec3f();
        this.rotatedNormal[0] = new Vec3f();
        this.rotatedNormal[1] = new Vec3f();
    }

    public OBBCollider(AxisAlignedBB aabbCopy) {
        super(null, null);
        this.modelVertex = null;
        this.modelNormal = null;
        float xSize = (float)(aabbCopy.field_72336_d - aabbCopy.field_72340_a) / 2.0f;
        float ySize = (float)(aabbCopy.field_72337_e - aabbCopy.field_72338_b) / 2.0f;
        float zSize = (float)(aabbCopy.field_72334_f - aabbCopy.field_72339_c) / 2.0f;
        this.worldCenter = new Vec3f(-((float)aabbCopy.field_72340_a + xSize), (float)aabbCopy.field_72338_b + ySize, -((float)aabbCopy.field_72339_c + zSize));
        this.rotatedVertex = new Vec3f[4];
        this.rotatedNormal = new Vec3f[3];
        this.rotatedVertex[0] = new Vec3f(-xSize, ySize, -zSize);
        this.rotatedVertex[1] = new Vec3f(-xSize, ySize, zSize);
        this.rotatedVertex[2] = new Vec3f(xSize, ySize, zSize);
        this.rotatedVertex[3] = new Vec3f(xSize, ySize, -zSize);
        this.rotatedNormal[0] = new Vec3f(1.0f, 0.0f, 0.0f);
        this.rotatedNormal[1] = new Vec3f(0.0f, 1.0f, 0.0f);
        this.rotatedNormal[2] = new Vec3f(0.0f, 0.0f, 1.0f);
    }

    @Override
    public void transform(VisibleMatrix4f mat) {
        int i;
        Vec4f tempVector = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        VisibleMatrix4f rotationMatrix = new VisibleMatrix4f(mat);
        rotationMatrix.m30 = 0.0f;
        rotationMatrix.m31 = 0.0f;
        rotationMatrix.m32 = 0.0f;
        for (i = 0; i < this.modelVertex.length; ++i) {
            tempVector.x = this.modelVertex[i].x;
            tempVector.y = this.modelVertex[i].y;
            tempVector.z = this.modelVertex[i].z;
            VisibleMatrix4f.transform(rotationMatrix, tempVector, tempVector);
            this.rotatedVertex[i].x = tempVector.x;
            this.rotatedVertex[i].y = tempVector.y;
            this.rotatedVertex[i].z = tempVector.z;
        }
        for (i = 0; i < this.modelNormal.length; ++i) {
            tempVector.x = this.modelNormal[i].x;
            tempVector.y = this.modelNormal[i].y;
            tempVector.z = this.modelNormal[i].z;
            VisibleMatrix4f.transform(rotationMatrix, tempVector, tempVector);
            this.rotatedNormal[i].x = tempVector.x;
            this.rotatedNormal[i].y = tempVector.y;
            this.rotatedNormal[i].z = tempVector.z;
        }
        super.transform(mat);
    }

    public boolean isCollideWith(OBBCollider opponent) {
        Vec3f toOpponent = Vec3f.sub(opponent.worldCenter, this.worldCenter, null);
        for (Vec3f seperateAxis : this.rotatedNormal) {
            if (OBBCollider.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        for (Vec3f seperateAxis : opponent.rotatedNormal) {
            if (OBBCollider.collisionDetection(seperateAxis, toOpponent, this, opponent)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCollideWith(Entity entity) {
        OBBCollider obb = new OBBCollider(entity.func_174813_aQ());
        return this.isCollideWith(obb);
    }

    private static boolean collisionDetection(Vec3f seperateAxis, Vec3f toOpponent, OBBCollider box1, OBBCollider box2) {
        float dot;
        Vec3f temp;
        Vec3f maxProj1 = null;
        Vec3f maxProj2 = null;
        float maxDot1 = -1.0f;
        float maxDot2 = -1.0f;
        Vec3f distance = Vec3f.dot(seperateAxis, toOpponent) > 0.0f ? toOpponent : new Vec3f(-toOpponent.x, -toOpponent.y, -toOpponent.z);
        for (Vec3f vertexVector : box1.rotatedVertex) {
            temp = Vec3f.dot(seperateAxis, vertexVector) > 0.0f ? vertexVector : new Vec3f(-vertexVector.x, -vertexVector.y, -vertexVector.z);
            dot = Vec3f.dot(seperateAxis, temp);
            if (!(dot > maxDot1)) continue;
            maxDot1 = dot;
            maxProj1 = temp;
        }
        for (Vec3f vertexVector : box2.rotatedVertex) {
            temp = Vec3f.dot(seperateAxis, vertexVector) > 0.0f ? vertexVector : new Vec3f(-vertexVector.x, -vertexVector.y, -vertexVector.z);
            dot = Vec3f.dot(seperateAxis, temp);
            if (!(dot > maxDot2)) continue;
            maxDot2 = dot;
            maxProj2 = temp;
        }
        return !(OBBCollider.getProjectedScale(seperateAxis, distance) >= OBBCollider.getProjectedScale(seperateAxis, maxProj1) + OBBCollider.getProjectedScale(seperateAxis, maxProj2));
    }

    private static float getProjectedScale(Vec3f normal, Vec3f projecting) {
        float dot = Vec3f.dot(normal, projecting);
        float normalScale = 1.0f / (normal.x * normal.x + normal.y * normal.y + normal.z * normal.z);
        Vec3f projVec = new Vec3f(dot * normal.x * normalScale, dot * normal.y * normalScale, dot * normal.z * normalScale);
        return (float)Math.sqrt(projVec.x * projVec.x + projVec.y * projVec.y + projVec.z * projVec.z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, VisibleMatrix4f pose, boolean red) {
        IVertexBuilder vertexBuilder = buffer.getBuffer(ModRenderTypes.getBox());
        VisibleMatrix4f transpose = new VisibleMatrix4f();
        VisibleMatrix4f.transpose(pose, transpose);
        matrixStackIn.func_227860_a_();
        MathUtils.translateStack(matrixStackIn, pose);
        MathUtils.rotateStack(matrixStackIn, transpose);
        Matrix4f matrix = matrixStackIn.func_227866_c_().func_227870_a_();
        Vec3f vec = this.modelVertex[1];
        float maxX = this.modelCenter.x + vec.x;
        float maxY = this.modelCenter.y + vec.y;
        float maxZ = this.modelCenter.z + vec.z;
        float minX = this.modelCenter.x - vec.x;
        float minY = this.modelCenter.y - vec.y;
        float minZ = this.modelCenter.z - vec.z;
        float color = red ? 0.0f : 1.0f;
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(1.0f, color, color, 1.0f).func_181675_d();
        matrixStackIn.func_227865_b_();
    }
}

