/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.physics;

import com.mojang.blaze3d.matrix.MatrixStack;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;

public class PlaneCollider
extends Collider {
    private Vec3f[] modelPos;
    private Vec3f[] worldPos;

    public PlaneCollider(Vec3f center, AxisAlignedBB entityCallAABB) {
        super(center, entityCallAABB);
    }

    public PlaneCollider(AxisAlignedBB entityCallAABB, float centerX, float centerY, float centerZ, float pos1X, float pos1Y, float pos1Z, float pos2X, float pos2Y, float pos2Z) {
        super(new Vec3f(centerX, centerY, centerZ), entityCallAABB);
        this.modelPos = new Vec3f[2];
        this.worldPos = new Vec3f[2];
        this.modelPos[0] = new Vec3f(pos1X, pos1Y, pos1Z);
        this.modelPos[1] = new Vec3f(pos2X, pos2Y, pos2Z);
        this.worldPos[0] = new Vec3f();
        this.worldPos[1] = new Vec3f();
    }

    @Override
    public boolean isCollideWith(Entity entity) {
        AxisAlignedBB opponent = entity.func_174813_aQ();
        Vec3f planeNorm = Vec3f.cross(this.worldPos[0], this.worldPos[1], null);
        Vec3f pos = new Vec3f();
        Vec3f neg = new Vec3f();
        if (planeNorm.x >= 0.0f) {
            pos.x = (float)opponent.field_72336_d;
            neg.x = (float)opponent.field_72340_a;
        } else {
            pos.x = (float)opponent.field_72340_a;
            neg.x = (float)opponent.field_72336_d;
        }
        if (planeNorm.y >= 0.0f) {
            pos.y = (float)opponent.field_72337_e;
            neg.y = (float)opponent.field_72338_b;
        } else {
            pos.y = (float)opponent.field_72338_b;
            neg.y = (float)opponent.field_72337_e;
        }
        if (planeNorm.z >= 0.0f) {
            pos.z = (float)opponent.field_72334_f;
            neg.z = (float)opponent.field_72339_c;
        } else {
            pos.z = (float)opponent.field_72339_c;
            neg.z = (float)opponent.field_72334_f;
        }
        float planeD = Vec3f.dot(planeNorm, this.worldCenter);
        float dot1 = Vec3f.dot(planeNorm, pos) - planeD;
        if (dot1 < 0.0f) {
            return false;
        }
        float dot2 = Vec3f.dot(planeNorm, neg) - planeD;
        return !(dot2 > 0.0f);
    }

    @Override
    public void transform(VisibleMatrix4f mat) {
        Vec4f tempVector = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
        VisibleMatrix4f rotationMatrix = new VisibleMatrix4f(mat);
        rotationMatrix.m30 = 0.0f;
        rotationMatrix.m31 = 0.0f;
        rotationMatrix.m32 = 0.0f;
        for (int i = 0; i < 2; ++i) {
            tempVector.x = this.modelPos[i].x;
            tempVector.y = this.modelPos[i].y;
            tempVector.z = this.modelPos[i].z;
            VisibleMatrix4f.transform(rotationMatrix, tempVector, tempVector);
            this.worldPos[i].x = tempVector.x;
            this.worldPos[i].y = tempVector.y;
            this.worldPos[i].z = tempVector.z;
        }
        super.transform(mat);
    }

    @Override
    protected void drawInternal(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, VisibleMatrix4f pose, boolean red) {
    }

    @Override
    public void draw(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, LivingData<?> entitydata, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float partialTicks) {
    }
}

