/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import com.mojang.blaze3d.platform.GlStateManager;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.events.engine.ControllEngine;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCResetBasicAttackCool;
import maninhouse.epicfight.network.server.STCSkillExecutionFeedback;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.skill.SpecialAttackSkill;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BladeRushSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("444a1a6a-c2f1-11eb-8529-0242ac130003");
    private static final String NBT_KEY = "blade_combo";

    public BladeRushSkill(float restriction, String skillName) {
        super(restriction, 1, 4, Skill.ActivateType.TOGGLE, skillName);
    }

    @Override
    public PacketBuffer gatherArguments(ClientPlayerData executer, ControllEngine controllEngine) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.writeBoolean(true);
        return buf;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.skillVariables.func_74768_a(NBT_KEY, 0);
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.DEALT_DAMAGE_EVENT, EVENT_UUID, event -> {
            int animationId = event.getDamageSource().getSkillId();
            if (animationId >= Animations.BLADE_RUSH_FIRST.getId() && animationId <= Animations.BLADE_RUSH_FINISHER.getId() && !event.getTarget().func_70089_S()) {
                this.setStackSynchronize((ServerPlayerData)event.getPlayerData(), container.stack + 1);
            }
            return false;
        });
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            if (((ClientPlayerData)event.getPlayerData()).getSkill(this.slot.index).isActivated()) {
                PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                buf.writeBoolean(false);
                this.executeOnClient((ClientPlayerData)event.getPlayerData(), buf);
                return true;
            }
            return false;
        });
    }

    @Override
    public void onDeleted(SkillContainer container) {
        container.skillVariables.func_82580_o(NBT_KEY);
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.DEALT_DAMAGE_EVENT, EVENT_UUID);
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        if (executer.getSkill(this.slot).isActivated() && args.readBoolean()) {
            this.cancelOnServer(executer, null);
        } else {
            int animationId = 5012 + executer.getSkill((SkillSlot)this.slot).skillVariables.func_74762_e(NBT_KEY);
            executer.playAnimationSynchronize(Animations.findAnimationDataById(animationId), 0.0f);
            ModNetworkManager.sendToPlayer(new STCResetBasicAttackCool(), executer.getOriginalEntity());
            executer.getSkill((SkillSlot)this.slot).skillVariables.func_74768_a(NBT_KEY, (animationId - 5011) % 4);
            this.setDurationSynchronize(executer, this.maxDuration);
            this.setStackSynchronize(executer, executer.getSkill(this.slot).getStack() - 1);
            executer.getSkill(this.slot).activate();
        }
    }

    @Override
    public void cancelOnClient(ClientPlayerData executer, PacketBuffer args) {
        executer.getSkill(this.slot).deactivate();
    }

    @Override
    public void cancelOnServer(ServerPlayerData executer, PacketBuffer args) {
        executer.getSkill(this.slot).deactivate();
        executer.getSkill((SkillSlot)this.slot).skillVariables.func_74768_a(NBT_KEY, 0);
        ModNetworkManager.sendToPlayer(new STCSkillExecutionFeedback(this.slot.getIndex(), false), executer.getOriginalEntity());
    }

    @Override
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerCap) {
        List<ITextComponent> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Last Strike:");
        return list;
    }

    @Override
    public void onScreen(ClientPlayerData playerdata, float resolutionX, float resolutionY) {
        if (playerdata.getSkill(this.slot).isActivated()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("epicfight", "textures/gui/screen/blade_rush.png"));
            GlStateManager.func_227740_m_();
            GlStateManager.func_227731_j_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_225582_a_(0.0, 0.0, 1.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, (double)resolutionY, 1.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)resolutionX, (double)resolutionY, 1.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)resolutionX, 0.0, 1.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        ((AttackAnimation)Animations.BLADE_RUSH_FIRST).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_SECOND).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_THIRD).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)Animations.BLADE_RUSH_FINISHER).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }
}

