/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCResetBasicAttackCool;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SpecialAttackSkill;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class EviscerateSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("f082557a-b2f9-11eb-8529-0242ac130003");
    private StaticAnimation first = Animations.EVISCERATE_FIRST;
    private StaticAnimation second = Animations.EVISCERATE_SECOND;

    public EviscerateSkill(float restriction, String skillName) {
        super(restriction, skillName);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            List<LivingEntity> hitEnemies;
            if (event.getAnimationId() == Animations.EVISCERATE_FIRST.getId() && (hitEnemies = event.getAttackedEntity()).size() > 0 && hitEnemies.get(0).func_70089_S()) {
                ((ServerPlayerData)event.getPlayerData()).reserverAnimationSynchronize(this.second);
                ((Animator)((ServerPlayerData)event.getPlayerData()).getAnimator()).getPlayer().resetPlayer();
                ((ServerPlayerData)event.getPlayerData()).currentlyAttackedEntity.clear();
                this.second.onUpdate((LivingData<?>)event.getPlayerData());
            }
            return false;
        });
    }

    @Override
    public void onDeleted(SkillContainer container) {
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        executer.playAnimationSynchronize(this.first, 0.0f);
        ModNetworkManager.sendToPlayer(new STCResetBasicAttackCool(), executer.getOriginalEntity());
        super.executeOnServer(executer, args);
    }

    @Override
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerCap) {
        List<ITextComponent> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "First Strike:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Second Strike:");
        return list;
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        AttackAnimation _first = (AttackAnimation)this.first;
        AttackAnimation _second = (AttackAnimation)this.second;
        _first.phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        _second.phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }
}

