/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import java.util.UUID;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import maninhouse.epicfight.network.server.STCModifySkillVariable;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.entity.player.ServerPlayerEntity;

public class KatanaPassive
extends Skill {
    private static final String NBT_KEY = "sheath";
    private static final UUID EVENT_UUID = UUID.fromString("a416c93a-42cb-11eb-b378-0242ac130002");

    public KatanaPassive() {
        super(SkillSlot.WEAPON_GIMMICK, 5.0f, Skill.ActivateType.ONE_SHOT, Skill.CooldownType.REGEN_PER_TICK, "katana_passive");
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.getVariableNBT().func_74757_a(NBT_KEY, false);
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.ACTION_EVENT, EVENT_UUID, event -> {
            container.getContaining().setCooldownSynchronize((ServerPlayerData)event.getPlayerData(), 0.0f);
            container.getContaining().setStackSynchronize((ServerPlayerData)event.getPlayerData(), 0);
            return false;
        });
    }

    @Override
    public void onDeleted(SkillContainer container) {
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.ACTION_EVENT, EVENT_UUID);
        container.getVariableNBT().func_82580_o(NBT_KEY);
    }

    @Override
    public void onReset(SkillContainer container) {
        PlayerData<?> executer = container.executer;
        if (!executer.isRemote()) {
            ServerPlayerEntity executePlayer = (ServerPlayerEntity)executer.getOriginalEntity();
            container.getVariableNBT().func_74757_a(NBT_KEY, false);
            STCLivingMotionChange msg = new STCLivingMotionChange(executePlayer.func_145782_y(), 3);
            msg.setMotions(LivingMotion.IDLE, LivingMotion.WALKING, LivingMotion.RUNNING);
            msg.setAnimations(Animations.BIPED_IDLE_UNSHEATHING, Animations.BIPED_WALK_UNSHEATHING, Animations.BIPED_RUN_UNSHEATHING);
            ((ServerPlayerData)executer).modifyLivingMotion(msg);
            STCModifySkillVariable msg2 = new STCModifySkillVariable(STCModifySkillVariable.VariableType.BOOLEAN, SkillSlot.WEAPON_GIMMICK, NBT_KEY, (Object)false);
            ModNetworkManager.sendToPlayer(msg2, executePlayer);
        }
    }

    @Override
    public void setCooldown(SkillContainer container, float value) {
        PlayerData<?> executer = container.executer;
        if (!executer.isRemote() && this.cooldown < value) {
            ServerPlayerEntity executePlayer = (ServerPlayerEntity)executer.getOriginalEntity();
            container.getVariableNBT().func_74757_a(NBT_KEY, true);
            STCLivingMotionChange msg = new STCLivingMotionChange(executePlayer.func_145782_y(), 6);
            msg.setMotions(LivingMotion.IDLE, LivingMotion.WALKING, LivingMotion.RUNNING, LivingMotion.JUMPING, LivingMotion.KNEELING, LivingMotion.SNEAKING);
            msg.setAnimations(Animations.BIPED_IDLE_SHEATHING, Animations.BIPED_WALK_SHEATHING, Animations.BIPED_RUN_SHEATHING, Animations.BIPED_JUMP_SHEATHING, Animations.BIPED_KNEEL_SHEATHING, Animations.BIPED_SNEAK_SHEATHING);
            ((ServerPlayerData)executer).modifyLivingMotion(msg);
            STCModifySkillVariable msg2 = new STCModifySkillVariable(STCModifySkillVariable.VariableType.BOOLEAN, SkillSlot.WEAPON_GIMMICK, NBT_KEY, (Object)true);
            ModNetworkManager.sendToPlayer(msg2, executePlayer);
            STCPlayAnimation msg3 = new STCPlayAnimation(Animations.BIPED_KATANA_SCRAP.getId(), executePlayer.func_145782_y(), 0.0f, true);
            ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg3, executePlayer);
        }
        super.setCooldown(container, value);
    }

    @Override
    public boolean shouldDeactivateAutomatically(PlayerData<?> executer) {
        return true;
    }

    @Override
    public float getRegenTimePerTick(PlayerData<?> player) {
        return 1.0f;
    }
}

