/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCResetBasicAttackCool;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SpecialAttackSkill;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class LethalSlicingSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("bfa79c04-97a5-11eb-a8b3-0242ac130003");
    private StaticAnimation elbow = Animations.LETHAL_SLICING;
    private StaticAnimation swing = Animations.LETHAL_SLICING_ONCE;
    private StaticAnimation doubleSwing = Animations.LETHAL_SLICING_TWICE;

    public LethalSlicingSkill(float restriction, String skillName) {
        super(restriction, skillName);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (event.getAnimationId() == Animations.LETHAL_SLICING.getId()) {
                List<LivingEntity> hitEnemies = event.getAttackedEntity();
                if (hitEnemies.size() <= 1) {
                    ((ServerPlayerData)event.getPlayerData()).reserverAnimationSynchronize(this.swing);
                } else if (hitEnemies.size() > 1) {
                    ((ServerPlayerData)event.getPlayerData()).reserverAnimationSynchronize(this.doubleSwing);
                }
            }
            return false;
        });
    }

    @Override
    public void onDeleted(SkillContainer container) {
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        executer.playAnimationSynchronize(this.elbow, 0.0f);
        ModNetworkManager.sendToPlayer(new STCResetBasicAttackCool(), executer.getOriginalEntity());
        super.executeOnServer(executer, args);
    }

    @Override
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerCap) {
        List<ITextComponent> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Elbow:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Each Strike:");
        return list;
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        AttackAnimation _elbow = (AttackAnimation)this.elbow;
        AttackAnimation _swing = (AttackAnimation)this.swing;
        AttackAnimation _doubleSwing = (AttackAnimation)this.doubleSwing;
        _elbow.phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        _swing.phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        _doubleSwing.phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        _doubleSwing.phases[1].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }
}

