/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import java.util.UUID;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SpecialAttackSkill;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class LiechtenauerSkill
extends SpecialAttackSkill {
    private static final UUID EVENT_UUID = UUID.fromString("244c57c0-a837-11eb-bcbc-0242ac130002");

    public LiechtenauerSkill(String skillName) {
        super(40.0f, 4, Skill.ActivateType.DURATION_INFINITE, skillName);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.DEALT_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (container.isActivated() && !event.getTarget().func_70089_S()) {
                this.setDurationSynchronize((ServerPlayerData)event.getPlayerData(), container.duration + 1);
            }
            return false;
        });
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.HIT_EVENT, EVENT_UUID, event -> {
            DamageSource damageSource = event.getDamageSource();
            boolean isFront = false;
            Vector3d vector3d2 = damageSource.func_188404_v();
            if (vector3d2 != null) {
                Vector3d vector3d = ((ServerPlayerData)event.getPlayerData()).getOriginalEntity().func_70676_i(1.0f);
                Vector3d vector3d1 = vector3d2.func_72444_a(((ServerPlayerData)event.getPlayerData()).getOriginalEntity().func_213303_ch()).func_72432_b();
                vector3d1 = new Vector3d(vector3d1.field_72450_a, 0.0, vector3d1.field_72449_c);
                if (vector3d1.func_72430_b(vector3d) < 0.0) {
                    isFront = true;
                }
            }
            if (isFront && container.duration > 0 && this.isExecutableState((PlayerData<?>)event.getPlayerData())) {
                this.setDurationSynchronize((ServerPlayerData)event.getPlayerData(), container.duration - 1);
                ((ServerPlayerData)event.getPlayerData()).playAnimationSynchronize(Animations.LONGSWORD_GUARD, 0.0f);
                ((ServerPlayerData)event.getPlayerData()).playSound(Sounds.CLASH, -0.1f, 0.2f);
                ServerPlayerEntity playerentity = ((ServerPlayerData)event.getPlayerData()).getOriginalEntity();
                ((HitParticleType)Particles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerWorld)playerentity.field_70170_p, HitParticleType.POSITION_MIDDLE_OF_EACH_ENTITY, HitParticleType.ARGUMENT_ZERO, (Entity)playerentity, damageSource.func_76364_f());
                float knockback = 0.25f;
                if (damageSource instanceof IExtendedDamageSource) {
                    knockback += ((IExtendedDamageSource)damageSource).getImpact() * 0.1f;
                }
                if (damageSource.func_76364_f() instanceof LivingEntity) {
                    knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)((LivingEntity)damageSource.func_76364_f())) * 0.1f;
                }
                ((ServerPlayerData)event.getPlayerData()).knockBackEntity(damageSource.func_76364_f(), knockback);
                return true;
            }
            return false;
        });
        container.executer.getEventListener().addEventListener(EntityEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((ClientPlayerData)event.getPlayerData()).getSkill(this.slot).isActivated()) {
                ClientPlayerEntity clientPlayer = (ClientPlayerEntity)((ClientPlayerData)event.getPlayerData()).getOriginalEntity();
                clientPlayer.func_70031_b(false);
                clientPlayer.field_71156_d = -1;
                ClientEngine.INSTANCE.inputController.setKeyBind(Minecraft.func_71410_x().field_71474_y.field_151444_V, false);
            }
            return false;
        });
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        this.setDurationSynchronize(executer, this.maxDuration);
        executer.getSkill(this.slot).activate();
        STCLivingMotionChange msg = new STCLivingMotionChange(executer.getOriginalEntity().func_145782_y(), 6);
        msg.setMotions(LivingMotion.IDLE, LivingMotion.WALKING, LivingMotion.RUNNING, LivingMotion.JUMPING, LivingMotion.KNEELING, LivingMotion.SNEAKING);
        msg.setAnimations(Animations.BIPED_IDLE_LONGSWORD, Animations.BIPED_WALK_LONGSWORD, Animations.BIPED_RUN_MASSIVE_HELD, Animations.BIPED_JUMP_LONGSWORD, Animations.BIPED_KNEEL_MASSIVE_HELD, Animations.BIPED_SNEAK_MASSIVE_HELD);
        executer.modifyLivingMotion(msg);
    }

    @Override
    public void cancelOnServer(ServerPlayerData executer, PacketBuffer args) {
        super.cancelOnServer(executer, args);
        this.setCooldownSynchronize(executer, 0.0f);
        this.setStackSynchronize(executer, executer.getSkill(this.slot).getStack() - 1);
        executer.modifiLivingMotions(executer.getHeldItemCapability(Hand.MAIN_HAND));
    }

    @Override
    public void onDeleted(SkillContainer container) {
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.HIT_EVENT, EVENT_UUID);
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.DEALT_DAMAGE_EVENT, EVENT_UUID);
        container.executer.getEventListener().removeListener(EntityEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        return this;
    }
}

