/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCResetBasicAttackCool;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SpecialAttackSkill;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;

public class SimpleSpecialAttackSkill
extends SpecialAttackSkill {
    protected final StaticAnimation attackAnimation;

    public SimpleSpecialAttackSkill(float restriction, String skillName, StaticAnimation animation) {
        this(restriction, 0, skillName, animation);
    }

    public SimpleSpecialAttackSkill(float restriction, int duration, String skillName, StaticAnimation animation) {
        super(restriction, duration, Skill.ActivateType.ONE_SHOT, skillName);
        this.properties = Lists.newArrayList();
        this.attackAnimation = animation;
    }

    @Override
    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        executer.playAnimationSynchronize(this.attackAnimation, 0.0f);
        ModNetworkManager.sendToPlayer(new STCResetBasicAttackCool(), executer.getOriginalEntity());
        super.executeOnServer(executer, args);
    }

    @Override
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerCap) {
        List<ITextComponent> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        return list;
    }

    @Override
    public SpecialAttackSkill registerPropertiesToAnimation() {
        AttackAnimation anim = (AttackAnimation)this.attackAnimation;
        for (AttackAnimation.Phase phase : anim.phases) {
            phase.addProperties(((Map)this.properties.get(0)).entrySet());
        }
        return this;
    }
}

