/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.events.engine.ControllEngine;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCSetSkillValue;
import maninhouse.epicfight.network.server.STCSkillExecutionFeedback;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.math.Formulars;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Skill {
    protected ResourceLocation registryName;
    protected final SkillSlot slot;
    protected final boolean isActiveSkill;
    protected final float cooldown;
    protected final int maxDuration;
    protected final int maxStackSize;
    protected ActivateType activateType;
    protected CooldownType cooldownType;

    public Skill(SkillSlot index, float cooldown, ActivateType activateType, CooldownType cooldownType, String skillName) {
        this(index, cooldown, 0, 1, true, activateType, cooldownType, skillName);
    }

    public Skill(SkillSlot index, float cooldown, int maxStack, ActivateType activateType, CooldownType cooldownType, String skillName) {
        this(index, cooldown, 0, maxStack, true, activateType, cooldownType, skillName);
    }

    public Skill(SkillSlot index, float cooldown, int duration, boolean isActiveSkill, ActivateType activateType, CooldownType cooldownType, String skillName) {
        this(index, cooldown, duration, 1, true, activateType, cooldownType, skillName);
    }

    public Skill(SkillSlot index, float cooldown, int duration, int maxStack, boolean isActiveSkill, ActivateType activateType, CooldownType cooldownType, String skillName) {
        this.slot = index;
        this.cooldown = cooldown;
        this.maxDuration = duration;
        this.isActiveSkill = isActiveSkill;
        this.maxStackSize = maxStack;
        this.registryName = new ResourceLocation("epicfight", skillName);
        this.activateType = activateType;
        this.cooldownType = cooldownType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PacketBuffer gatherArguments(ClientPlayerData executer, ControllEngine controllEngine) {
        return null;
    }

    public boolean isExecutableState(PlayerData<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !((PlayerEntity)executer.getOriginalEntity()).func_184613_cA() && executer.currentMotion != LivingMotion.FALL && playerState.canAct();
    }

    public boolean canExecute(PlayerData<?> executer) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(ClientPlayerData executer, PacketBuffer args) {
    }

    public void cancelOnServer(ServerPlayerData executer, PacketBuffer args) {
        ModNetworkManager.sendToPlayer(new STCSkillExecutionFeedback(this.slot.getIndex(), false), executer.getOriginalEntity());
    }

    public void executeOnServer(ServerPlayerData executer, PacketBuffer args) {
        this.setCooldownSynchronize(executer, 0.0f);
        this.setStackSynchronize(executer, executer.getSkill(this.slot).getStack() - 1);
        this.setDurationSynchronize(executer, this.maxDuration);
        executer.getSkill(this.slot).activate();
    }

    public void cancelOnClient(ClientPlayerData executer, PacketBuffer args) {
    }

    public void onInitiate(SkillContainer container) {
    }

    public void onDeleted(SkillContainer container) {
    }

    public void onReset(SkillContainer container) {
    }

    public void setCooldown(SkillContainer container, float value) {
        container.cooldown = Math.min(Math.max(value, 0.0f), this.cooldown);
        if (value >= this.cooldown) {
            if (container.stack < this.maxStackSize) {
                ++container.stack;
                container.cooldown = 0.0f;
                container.prevCooldown = 0.0f;
            } else {
                container.cooldown = this.cooldown;
                container.prevCooldown = this.cooldown;
            }
        } else if (value == 0.0f && container.stack > 0) {
            --container.stack;
        }
    }

    public void update(SkillContainer container) {
        PlayerData<?> executer = container.executer;
        container.prevCooldown = container.cooldown;
        container.prevDuration = container.duration;
        if (this.cooldownType == CooldownType.REGEN_PER_TICK && container.stack < container.containingSkill.maxStackSize) {
            container.setCooldown(container.cooldown + this.getRegenTimePerTick(executer) * 0.05f);
        }
        if (container.isActivated()) {
            if (this.activateType == ActivateType.DURATION_NORMAL) {
                --container.duration;
            }
            boolean isEnd = false;
            if (this.activateType == ActivateType.TOGGLE) {
                if (container.stack <= 0 && !((PlayerEntity)executer.getOriginalEntity()).func_184812_l_()) {
                    isEnd = true;
                }
            } else if (container.duration <= 0) {
                isEnd = true;
            }
            if (isEnd) {
                if (!container.executer.isRemote()) {
                    container.containingSkill.cancelOnServer((ServerPlayerData)executer, null);
                }
                container.deactivate();
            }
        }
    }

    public void setCooldownSynchronize(ServerPlayerData executer, float amount) {
        Skill.setCooldownSynchronize(executer, this.slot, amount);
    }

    public void setDurationSynchronize(ServerPlayerData executer, int amount) {
        Skill.setDurationSynchronize(executer, this.slot, amount);
    }

    public void setStackSynchronize(ServerPlayerData executer, int amount) {
        Skill.setStackSynchronize(executer, this.slot, amount);
    }

    public static void setCooldownSynchronize(ServerPlayerData executer, SkillSlot slot, float amount) {
        executer.getSkill(slot).setCooldown(amount);
        ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.COOLDOWN, slot.index, amount, false), executer.getOriginalEntity());
    }

    public static void setDurationSynchronize(ServerPlayerData executer, SkillSlot slot, int amount) {
        executer.getSkill(slot).setDuration(amount);
        ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.DURATION, slot.index, (float)amount, false), executer.getOriginalEntity());
    }

    public static void setStackSynchronize(ServerPlayerData executer, SkillSlot slot, int amount) {
        executer.getSkill(slot).setStack(amount);
        ModNetworkManager.sendToPlayer(new STCSetSkillValue(STCSetSkillValue.Target.STACK, slot.index, (float)amount, false), executer.getOriginalEntity());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreen(ClientPlayerData playerdata, float resolutionX, float resolutionY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerData<?> playerData) {
        ArrayList list = Lists.newArrayList();
        return list;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public float getRegenTimePerTick(PlayerData<?> player) {
        return Formulars.getSkillRegen((float)player.getWeight(), player);
    }

    public SkillSlot getSlot() {
        return this.slot;
    }

    public int getMaxStack() {
        return this.maxStackSize;
    }

    public boolean isActiveSkill() {
        return this.isActiveSkill;
    }

    public boolean shouldDeactivateAutomatically(PlayerData<?> executer) {
        return !((PlayerEntity)executer.getOriginalEntity()).func_184812_l_();
    }

    public ActivateType getActivateType() {
        return this.activateType;
    }

    public static enum CooldownType {
        NONE,
        REGEN_PER_TICK;

    }

    public static enum ActivateType {
        ONE_SHOT,
        DURATION_NORMAL,
        DURATION_INFINITE,
        TOGGLE;

    }
}

