/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.skill;

import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.skill.Skill;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillContainer {
    protected Skill containingSkill;
    protected PlayerData<?> executer;
    protected int prevDuration = 0;
    protected int duration = 0;
    protected float cooldown = 0.0f;
    protected float prevCooldown = 0.0f;
    protected boolean isActivated = false;
    protected int stack;
    protected CompoundNBT skillVariables;

    public SkillContainer(PlayerData<?> executer) {
        this.executer = executer;
        this.skillVariables = new CompoundNBT();
    }

    public void setExecuter(PlayerData<?> executer) {
        this.executer = executer;
    }

    public SkillContainer setSkill(Skill skill) {
        if (this.containingSkill != null) {
            this.containingSkill.onDeleted(this);
        }
        this.containingSkill = skill;
        this.resetValues();
        for (String key : this.skillVariables.func_150296_c()) {
            this.skillVariables.func_82580_o(key);
        }
        if (skill != null) {
            skill.onInitiate(this);
        }
        this.stack = 0;
        return this;
    }

    public void resetValues() {
        this.isActivated = false;
        this.prevDuration = 0;
        this.duration = 0;
        this.prevCooldown = 0.0f;
        this.cooldown = 0.0f;
    }

    public boolean isEmpty() {
        return this.containingSkill == null;
    }

    public void setCooldown(float value) {
        if (this.containingSkill != null) {
            this.containingSkill.setCooldown(this, value);
        } else {
            this.prevCooldown = 0.0f;
            this.cooldown = 0.0f;
        }
    }

    public void setDuration(int value) {
        if (this.containingSkill != null) {
            if (!this.isActivated() && value > 0) {
                this.isActivated = true;
            }
            this.duration = value;
            this.duration = Math.min(this.containingSkill.maxDuration, Math.max(this.duration, 0));
        } else {
            this.duration = 0;
        }
    }

    public void setStack(int stack) {
        this.stack = Math.min(this.containingSkill.maxStackSize, Math.max(stack, 0));
        if (this.stack <= 0 && this.containingSkill.shouldDeactivateAutomatically(this.executer)) {
            this.deactivate();
            this.containingSkill.onReset(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendExecuteRequest(ClientPlayerData executer) {
        if (this.canExecute(executer)) {
            this.containingSkill.executeOnClient(executer, this.containingSkill.gatherArguments(executer, ClientEngine.INSTANCE.inputController));
        }
    }

    public boolean requestExecute(ServerPlayerData executer, PacketBuffer buf) {
        if (this.canExecute(executer)) {
            this.containingSkill.executeOnServer(executer, buf);
            return true;
        }
        return false;
    }

    public CompoundNBT getVariableNBT() {
        return this.skillVariables;
    }

    public float getRemainCooldown() {
        return this.cooldown;
    }

    public int getRemainDuration() {
        return this.duration;
    }

    public boolean canExecute(PlayerData<?> executer) {
        if (this.containingSkill == null) {
            return false;
        }
        return (this.stack > 0 || ((PlayerEntity)executer.getOriginalEntity()).func_184812_l_()) && this.containingSkill.canExecute(executer);
    }

    public void update() {
        if (this.containingSkill != null) {
            this.containingSkill.update(this);
        }
    }

    public int getStack() {
        return this.stack;
    }

    public Skill getContaining() {
        return this.containingSkill;
    }

    public void activate() {
        if (!this.isActivated) {
            this.prevDuration = this.containingSkill.maxDuration;
            this.duration = this.containingSkill.maxDuration;
            this.isActivated = true;
        }
    }

    public void deactivate() {
        if (this.isActivated) {
            this.prevDuration = 0;
            this.duration = 0;
            this.isActivated = false;
        }
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public boolean hasSkill(Skill skill) {
        return this.containingSkill != null ? this.containingSkill.equals(skill) : false;
    }

    public boolean isFull() {
        return this.containingSkill != null ? this.stack >= this.containingSkill.maxStackSize : true;
    }

    public float getCooldownRatio(float partialTicks) {
        return this.containingSkill != null && this.containingSkill.cooldown > 0.0f ? (this.prevCooldown + (this.cooldown - this.prevCooldown) * partialTicks) / this.containingSkill.cooldown : 0.0f;
    }

    public float getCooldownSec() {
        return this.containingSkill != null ? this.containingSkill.cooldown - this.cooldown : 0.0f;
    }

    public float getDurationRatio(float partialTicks) {
        return this.containingSkill != null && this.containingSkill.maxDuration > 0 ? ((float)this.prevDuration + (float)(this.duration - this.prevDuration) * partialTicks) / (float)this.containingSkill.maxDuration : 0.0f;
    }
}

